!+
!KWIC hedgx.f
!
!$Id: hedgx.f,v 1.2 2004/03/17 21:23:36 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . eliminate G(.) - not used
!-
!
!  UPDATED 02/26/88 TO OUTPUT ALL 20 SYS PARAMS AND NO MORE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE HEDGX
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    HEDGX FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/28/80
C    *
C    *    UPDATE:   11/30/81
C    *    TIME:     13:18:03
C    *
C    ******************************************/
C
C  W#12 : HEADER RECORD OF GX FILE
C
C  INPUT VIA LABELED COMMON /IDENT/:
C    GID (1 TO 16) : 64 CHARACTER IDENTIFICATION RECORD
C    GDATE         : CHAR * 8 - 8 CHARACTER GEOMETRY DATE
C    GTIME         : R * 8 - 8 CHARACTER GEOMETRY TIME + 8 CHAR DUMMY
C
C  INPUT VIA LABELED COMMON /PARM/  ALL ARE DOUBLE PRECISION :
C    GEN ( 1) : XAP = X OF CENTER OF ANNULAR APERTURE
C    GEN ( 2) : YAP = Y OF CENTER OF ANNULAR APERTURE
C    GEN ( 3) : ZOFF - Z OFFSET OF FOCAL PLANE
C    GEN ( 4) : NS - TOTAL NUMBER OF SURFACES (EXCLUDE FOCAL PLANE)
C    GEN ( 5) : PSI - POLARIZATION MAJOR AXIS ANGLE (WAS EP1)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 6) : E - RATIO OF MINOR TO MAJOR AXIS AMPLITUDE (WAS EP2)
C               (ABS VALUE BETWEEN 0 AND 1)
C               (POSITIVE FOR LEFT HANDED, NEGATIVE FOR RIGHT HANDED)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 7) : AZBU - AZIMUTH ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 8) : ELBU - ELEVATION ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 9) : R1 - INNER RADIUS OF APERTURE ANNULUS
C    GEN (10) : R2 - OUTER RADIUS OF APERTURE ANNULUS
C    GEN (11) : MING - NUMBER OF RINGS IN FIRST SPOKE
C    GEN (12) : M2 - NUMBER OF SPOKES
C    GEN (13 & 14)  NOT USED
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C    NS   : I*4 - ACTUAL NUMBER OF SURFACES
C    KURF : I*4 - SURFACE NUMBER
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C    RZER : R*4 - INITIAL NON-ZERO RADIUS OF ANNULAR APERTURE
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C    H2   : R*4 - NOT NEEDED, DUMMIED TO -1. IN NEW VERSION
C
C  /SWITCH/ VARIABLES INITIALIZED, ALL ARE LOGICAL * 1:
C    LSW0 (1 TO 10) : GENERAL SYSTEM SWITCHES
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      DIMENSION M (4), H (3)
C
      WRITE (12, 140) GID, GDATE, GTIME (1)
      M (1) = NS
      M (2) = KURF
      M (3) = MING
      M (4) = M2
      H (1) = RZER
      H (2) = DR
      H (3) = H2
      WRITE (12, 750)  M, H, GFOC
C
!
!  DO NOT OUTPUT THE FIRST 4 PARAM'S SEPARATELY
!
!     G (1) = GEN (1)
!     G (2) = GEN (2)
!     G (3) = GEN (3)
!     G (4) = GEN (4)
!     WRITE (12, 220)  G
!
!  CALL THE MODIFIED WRGX WITH GEN(1) INSTEAD OF G(5)
!
      CALL WRGX (GEN(1), LSW0)
      RETURN
140   FORMAT (1X, 15A4, A1, 1X, A8, 1X, A8)
220   FORMAT (1P, 4D20.12)
750   FORMAT (4I5, 1P, 3E15.6, D15.8)
      END
