!+
!KWIC hedngs.f
!
!$Id: hedngs.f,v 1.2 2004/03/17 21:23:36 dtn Exp $
!
!Revisions:
!   97-May-20[D. Grumm]
!      . changed rtime to CHARACTER*(8)
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 5/9/88 TO MAKE DFID CHARACTER * 4
!  PAUL GLENN, BAUER ASSOICATES, INC.
!
      SUBROUTINE HEDNGS
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    HEDNGS FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/23/81
C    *
C    *    UPDATE:   03/05/82
C    *    TIME:     10:20:16
C    *
C    ******************************************/
C
C  READ AND CHECK HEADINGS OF 'RAY' AND 'SCAL' FILES, AND
C  WRITE HEADING TO 'ARAY' FILE
C
C  INPUT VIA # 2 : FILE 'SCAL' = SUSEQ SCALE FACTOR FILE
C
C  INPUT VIA # 3 : FILE 'SCAT' = SCATTER DEFINITION FILE
C
C  INPUT VIA # 9 AND UP : DRAT 'RAY' FILES
C
C  TEMPORARY INPUT/OUTPUT VIA LABELED COMMON /PARX/ :
C    KURF : I*4 - SURFACE NUMBER
C
C  OUTPUT VIA # 7 : FILE 'ARAY' = STREHL-ATTENUATED RAY FILE
C
C  OUTPUT VIA LABELED COMMON /IDENT/ :
C    RID : R*4 - 64 CHARACTER SCATTER FILE IDENTIFIER
C
C  XR : HEDRAY, REHEAD
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/ident.h'

C      COMMON /IDENT/ GID (16), GDATE, GTIME (2),
C     1               RID (16), RDATE, RTIME (2),
C     2               DFID (16)
C      DOUBLE PRECISION    GTIME
C      CHARACTER*4 GID,RID
C      CHARACTER*4 DFID
C      CHARACTER*(8) GDATE , RDATE, RTIME !*** WERE DOUBLE PRECISION
C
C
C  READ THE SCATTER FILE IDENTIFIER
      READ (3, 8020) RID
C
C  READ 'SCAL' FILE HEADER
      KURF = -2
      CALL REHEAD (2, -1, IER)
      IF (IER .EQ. 0) GO TO 200
      WRITE (8, 8000)
      STOP 8
C
C  READ EACH 'RAY' FILE HEADER
200   JTOP = NS + 1
      DO 300 J = 1, JTOP
      KURF = J + 1
      ND = J + 8
      CALL REHEAD (ND, 1, IER)
      IF (IER .EQ. 0) GO TO 300
      WRITE (8, 8010) J
      STOP 8
300   CONTINUE
C
C  WRITE 'ARAY' FILE HEADER AS IF FOR SURFACE # -1
      CALL HEDRAY (-1, 7)
      RETURN
C
8000  FORMAT ('  HEDNGS - FATAL ERR READING HEADING OF ''SCAL'' FILE')
8010  FORMAT ('  HEDNGS - FATAL ERR READING HEADING OF RAY FILE, SURF',
     1         I3)
8020  FORMAT (16A4)
      END
