!+
!KWIC hedray.f
!
!$Id: hedray.f,v 1.2 2004/03/17 21:23:36 dtn Exp $
!
!Revisions:
!   97-May-20[D. Grumm]
!      . changed RTIME to CHARACTER*(8)
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Aug-16[T. Gaetz]
!      . add new include file:  /RF_IOFMT/ IOFMT;
!        encodes IO type to distinguish different ascii formats;
!        initialize to 102 (Via parameter statement)
!      . write out new header record giving IO format version
!-

      SUBROUTINE HEDRAY (J, ND)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    HEDRAY FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/02/80
C    *
C    *    UPDATE:   11/30/81
C    *    TIME:     13:39:51
C    *
C    ******************************************/
C  WRITE THE HEADER RECORD OF A RAY FILE
C
C  INPUT ARGUMENTS :
C    J    : I*4 SURFACE #
C    ND   : I*4 DEVICE # ASSOCIATED WITH RAY FILE # J
C
C  INPUT VIA LABELED COMMON /IDENT/:
C    GID (1 TO 16) : 64 CHARACTER GEOMETRY IDENTIFICATION RECORD
C    GDATE         : CHAR*8 - 8 CHARACTER GEOMETRY DATE
C    GTIME         : R*8 - 8 CHARACTER GEOMETRY TIME + 8 CHAR DUMMY
C    RID (1 TO 16) : 64 CHARACTER RAY FILE IDENTIFICATION RECORD
C    RDATE         : R*8 - 8 CHARACTER RAY FILE DATE
C    RTIME         : CHAR*8 - 8 CHARACTER RAY FILE TIME
C
C  INPUT VIA LABELED COMMON /PARX/:
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C    NS   : I*4 - ACTUAL NUMBER OF SURFACES
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C    RZER : R*4 - INITIAL NON-ZERO RADIUS OF ANNULAR APERTURE
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C    H2   : R*4 - NOT NEEDED, DUMMIED TO -1. IN NEW VERSION
C
C  OUTPUT VIA # ND :
C    THE 3 CARD HEADER RECORD FOR RAY FILE # J
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      INTEGER     IOFMT_VERSION
      PARAMETER ( IOFMT_VERSION = 102 )

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/ident.h'
C      COMMON /IDENT/ GID (16), GDATE, GTIME (2),
C     1               RID (16), RDATE, RTIME (2)
      INTEGER           IOFMT
      COMMON /RF_IOFMT/ IOFMT             ! io type
C      DOUBLE PRECISION    GTIME
C      CHARACTER*4 GID,RID
C      CHARACTER*(8) GDATE , RDATE, RTIME !*** WERE DOUBLE PRECISION
C
      IOFMT = IOFMT_VERSION
      WRITE (ND, 600) RID, RDATE, RTIME (1)
      WRITE (ND, 600) GID, GDATE, GTIME (1)
      WRITE (ND, 610) IOFMT
      WRITE (ND, 620) NS, J, MING, M2, RZER, DR, H2, GFOC
C
      RETURN
600   FORMAT (1X, 15A4, A1, 1X, A8, 1X, A8)
610   FORMAT ( T1, ' IOFVN: ' , I3 )
620   FORMAT (4I5, 1P,3E15.6, D15.8)
      END
