!+
!KWIC itozer.f
!
!$Id: itozer.f,v 1.2 2004/03/17 21:23:37 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /COMIC/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Jan-23[T. Gaetz]
!      . imported from OSAC V7.0
!-
!  UPDATED 8/18/89 TO FIX ERROR IN Q3 SYMMETRIC MATRIX STORAGE MODE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE ITOZER (RTOR, K, P, TEL, KODE, Q0)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    ITOZER FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/16/89
C    *
C   /******************************************/
C
C  ITERATIVELY CORRECT FOR THE ZERNIKE DEFORMATIONS
C  OF A TORIC OPTICAL SURFACE.
C  ALSO, IN CONTRAST TO THE EQUIVALENT CONIC SURFACE ROUTINES,
C  FIND THE NORMALIZED (BUT UN-TRANSFORMED) SURFACE SECOND DERIVATIVE
C  MATRIX Q0.
C
C  IN CONTRAST TO ICZERN, THE EQUIVALENT ROUTINE FOR CONIC SURFACES,
C  THIS ROUTINE IS USED FOR FINAL TOUCHUP OF THE INTERSECTION EVEN
C  WHEN THERE ARE NO ZERNIKE DEFORMATIONS.
C
C  INPUT ARGUMENTS:
C    RTOR : R*8 - HEIGHT OF ROTATION AXIS ABOVE X-Y PLANE
C           (AN ABSOLUTE VALUE .GE. 1.D15 MEANS INFINITY)
C    K    : R*8 - 1 / 2 LINEAR TERM IN SURFACE EQUATION
C           (AN ABSOLUTE VALUE LARGER THAN 1.D15 MEANS INFINITY)
C    P    : R*8 - CONIC CONSTANT = 1 - ECCENTRICITY ** 2
C    KODE : I*4 - INDICATOR SHOWING HOW RAY IS TO INTERSECT SURFACE
C        (SEE TORZER)
C
C  INPUT VIA LABELED COMMON /COMIC/:
C    XD   : R*8 - X COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    YD   : R*8 - Y COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    ZD   : R*8 - Z COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    XL   : R*8 - X COMPONENT OF INPUT DIRECTION
C    YL   : R*8 - Y COMPONENT OF INPUT DIRECTION
C    ZL   : R*8 - Z COMPONENT OF INPUT DIRECTION
C    PHIL : R*8 - 1 / R2S (CALCULATED IN VINIT)
C
C  INPUT VIA LABELED COMMON /PARX/:
C    KURF : I*4 - SURFACE NUMBER
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    LSW (2, KURF) : F - NO DEFORMATIONS, T - DEFORMATIONS
C
C  OUTPUT ARGUMENTS:
C    TEL  : R*8 - TOTAL DISTANCE CORRECTION
C    KODE : I*4 - INDICATOR SHOWING HOW RAY INTERSECTED SURFACE
C        (SEE TORZER)
C    Q0   : R*8 - NORMALIZED BUT UN-TRANSFORMED SURFACE SECOND
C                 DERIVATIVE MATRIX (IN SYMMETRIC STORAGE MODE)
C
C  OUTPUT VIA LABELED COMMON /COMIC/:
C    XD : R*8 - X COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    YD : R*8 - Y COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    ZD : R*8 - Z COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    XG : R*8 - X COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C    YG : R*8 - Y COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C    ZG : R*8 - Z COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C
C  EXTERNAL REFERENCES: ABZERN
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DOUBLE PRECISION K
      DIMENSION Q0 (6)

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/comic.h'     ! xd,yd,zd,xl,yl,zl,xg,yg,zg,phil
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
C
C
C  BEGIN THE ITERATIONS, WITH THE FOLLOWING PARAMETER DEFINITIONS:
C    F     = SURFACE FUNCTION (F = 0)
C            (HERE, IN CONTRAST TO ICZERN, F HAS UNITS OF DISTANCE,
C            INSTEAD OF DISTANCE SQUARED)
C    FDOT  = GRADIENT OF F, DOTTED INTO THE RAY DIRECTION
C    FLIT0 = 'LITTLE F' FUNCTION, WHERE Z=f(Y) IS THE TORIC DEFINITION
C            OF THE CURVE TO BE ROTATED ABOUT {X=0, Z=R}
C    FLIT1 = FIRST DERIVATIVE OF 'LITTLE F'
C    FLIT2 = SECOND DERIVATIVE OF 'LITTLE F'
C    TS    = CONVERGENCE CRITERION FOR F
C    DEL   = - F / FDOT = GUESS AT INCREMENTAL DISTANCE TO SURFACE
C    TEL   = RUNNING TOTAL OF DEL
C    IT    = ITERATION COUNTER (ALLOWED TO GO UP TO 5)
C
      TS = 1.D-14 * (DABS (XD) + DABS (YD) + DABS (ZD) + 1.D0)
      TEL = 0.D0
      IT = 0
      GO TO 130
C
C  NOT CLOSE ENOUGH YET: GIVEN F AND ITS GRADIENT, EVALUATE DEL
C
110   CONTINUE
      FDOT = XG * XL + YG * YL + ZG * ZL
      IF (DABS (FDOT) .LT. 1.D-6) GO TO 280
      DEL = - F / FDOT
      TEL = TEL + DEL
      XD = XD + DEL * XL
      YD = YD + DEL * YL
      ZD = ZD + DEL * ZL
C
C  BEGIN NEW CALCULATIONS FOR F AND ITS GRADIENT
C
130   IF (DABS (K) .GE. 0.99999D15) GO TO 150
      IF (P .EQ. 0.D0) GO TO 140
      DARG = 1.D0 - P * (YD / K) ** 2
      IF (DARG .LE. 0.D0) GO TO 280
      DSQ = DSQRT (DARG)
      FLIT0 = (K / P) * (1.D0 - DSQ)
      FLIT1 = YD / (K * DSQ)
      GO TO 160
140   FLIT0 = YD * YD / (K + K)
      FLIT1 = YD / K
      GO TO 160
150   FLIT0 = 0.D0
      FLIT1 = 0.D0
C
C  WITH FLIT0 AND FLIT1 CALCULATED, GET ON WITH F AND ITS GRADIENT
C  (FIRST DISPENSE WITH THE INFINITE RADIUS CASE)
C
160   IF (DABS (RTOR) .LT. 0.99999D15) GO TO 165
      F = - ZD + FLIT0
      XG = 0.D0
      YG = FLIT1
      ZG = -1.D0
      GO TO 185
C
C  SET UP FOR THE MORE GENERAL FINITE RADIUS CASE
C
165   DARG = (1.D0 - FLIT0 / RTOR) ** 2 - (XD / RTOR) ** 2
      IF (DARG .LE. 0.D0) GO TO 280
      DSQ = DSQRT (DARG)
C
C  TAKE SPECIAL CARE IF THE SQUARE ROOT IS CLOSE TO UNITY
C
      IF ((1.D0 - DSQ) .LT. 1.D-4) GO TO 170
      F = - ZD + RTOR * (1.D0 - DSQ)
      GO TO 180
170   DARG = - (FLIT0 + FLIT0) + (FLIT0 * FLIT0 - XD * XD) / RTOR
      DARGR = DARG / RTOR
      F = - ZD - (DARG / 2.D0) *
     *    (1.D0 - (DARGR / 4.D0) *
     *    (1.D0 - (DARGR / 2.D0) *
     *    (1.D0 - (5.D0 * DARGR / 8.D0))))
C
180   XG = XD / (RTOR * DSQ)
      YG = (1.D0 - FLIT0 / RTOR) * FLIT1 / DSQ
      ZG = - 1.D0
C
C  F AND GRADIENT ARE DONE - CHECK FOR ZERNIKE'S
C
185   IF (.NOT. LSW (2, KURF)) GO TO 190
C
C  THERE ARE ZERNIKE'S: EVALUATE THEM AT (XD, YD), UPDATE F, GRADIENT
C
      XN = XD * PHIL
      YN = YD * PHIL
      CALL ABZERN (XN, YN, ZAP, XAP, YAP, IER)
      IF (IER .GT. 1 .OR. IER .LT. 0) GO TO 290
      IF (IER .EQ. 1) GO TO 270
      F = F + ZAP
      XG = XG + XAP * PHIL
      YG = YG + YAP * PHIL
C
C  SEE IF THIS IS CLOSE ENOUGH
C
190   IF (DABS (F) .LT. TS) GO TO 300
      IT = IT + 1
      IF (IT .LE. 5) GO TO 110
C
C  KODE = 9 : TOO MANY ITERATIONS
C
      KODE = 9
      GO TO 400
C
C  KODE = 6 : (XN, YN) IS OUTSIDE THE UNIT DISK
C
270   CONTINUE
      KODE = 6
      GO TO 400
C
C  KODE = 8 : EXCESSIVE DEFORMATION OR ZERO DIVIDE
C
280   CONTINUE
      KODE = 8
      GO TO 400
C
C  KODE = 12 : UNDETERMINED ERROR
C
290   CONTINUE
      KODE = 12
      WRITE (8, 1000) IER
      GO TO 400
C
C  ITERATIONS DONE - DERIVE THE CONSTANTS FOR THE CURVATURE MATRIX
C
300   IF (DABS (K) .GE. 0.99999D15) GO TO 350
      IF (P .EQ. 0.D0) GO TO 340
      DARG = 1.D0 - P * (YD / K) ** 2
      FLIT2 = 1.D0 / (K * DARG ** 1.5D0)
      GO TO 360
340   FLIT2 = 1.D0 / K
      GO TO 360
350   FLIT2 = 0.D0
360   IF (DABS (RTOR) .GE. 0.99999D15) GO TO 370
C
C  FINITE RADIUS CASE
C
      Q0 (1) = 1.D0 / RTOR
      Q0 (2) = 0.D0
!
!      Q0 (3) = 0.D0
!      Q0 (4) = FLIT2 * (1.D0 - FLIT0 / RTOR) - FLIT1 * FLIT1 / RTOR
!
      Q0 (3) = FLIT2 * (1.D0 - FLIT0 / RTOR) - FLIT1 * FLIT1 / RTOR
      Q0 (4) = 0.D0
!
      Q0 (5) = 0.D0
      Q0 (6) = 1.D0 / RTOR
      XGTEMP = XD / RTOR
      YGTEMP = FLIT1 * (1.D0 - FLIT0 / RTOR)
      ZGTEMP = ZD / RTOR - 1.D0
      GO TO 380
C
C  ININITE RADIUS CASE
C
370   Q0 (1) = 0.D0
      Q0 (2) = 0.D0
!
!      Q0 (3) = 0.D0
!      Q0 (4) = FLIT2
!
      Q0 (3) = FLIT2
      Q0 (4) = 0.D0
!
      Q0 (5) = 0.D0
      Q0 (6) = 0.D0
      XGTEMP = 0.D0
      YGTEMP = FLIT1
      ZGTEMP = -1.D0
C
C  NORMALIZE THE RESULT, MAKING SURE TO CHANGE NORMALIZATION SIGN
C  IF THE GRADIENT POINTS OUT OF THE SURFACE
C
380   RNRM = 1.D0 / DSQRT (
     *       XGTEMP * XGTEMP + YGTEMP * YGTEMP + ZGTEMP * ZGTEMP)
      GDOTS0 = XGTEMP * XL + YGTEMP * YL + ZGTEMP * ZL
      IF (GDOTS0 .LT. 0.D0) RNRM = - RNRM
      DO 390 J = 1, 6
      Q0 (J) = Q0 (J) * RNRM
390   CONTINUE
C
C  RETURN
C
400   CONTINUE
      RETURN
1000  FORMAT (' ITOZER ERROR : UNDETERMINED ERROR - IER = ', I5)
      END
