!+
!KWIC ixern.f
!
!$Id: ixern.f,v 1.2 2004/03/17 21:23:37 dtn Exp $
!
!Revisions:
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   96-Jun-05[T. Gaetz]
!      . /COMIC/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate formatted io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE IXERN (R2, K, P, TEL, KODE)
C
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    IXERN FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 07/01/80
C    *
C    *    UPDATE:   10/23/80
C    *    TIME:     16:06:24
C    *
C    ******************************************/
C
C  ITERATIVELY CORRECT FOR THE ZERNIKE DEFORMATIONS
C  OF AN OFF-AXIS OPTICAL SURFACE
C
C  INPUT ARGUMENTS:
C    R2   : R*8 - CONSTANT TERM OF SURFACE EQUATION
C    K    : R*8 - 1 / 2 LINEAR TERM IN SURFACE EQUATION
C    P    : R*8 - CONIC CONSTANT = 1 - ECCENTRICITY ** 2
C    KODE : I*4 - INDICATOR SHOWING HOW RAY IS TO INTERSECT SURFACE
C        (SEE COXERN)
C
C  INPUT VIA LABELED COMMON /AXOFF/:
C    BETA : BORE SIGHT ANGLE (NOT INPUT)
C    PHIL : SCALING FACTOR = 1 / R2S (NOT INPUT FROM AXOFF)
C    CB  : R*4 - COSINE OF BETA
C    CE  : R*4 - CB * PHIL
C    SB  : R*4 - SINE OF BETA
C    SE  : R*4 - SB * PHIL
C    YEP : R*4 - Y COORDINATE OF EPICENTER
C
C  INPUT VIA LABELED COMMON /COMIC/:
C    XD   : R*8 - X COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    YD   : R*8 - Y COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    ZD   : R*8 - Z COORD. OF RAY INTERSECTION WITH UNDEFORMED SURFACE
C    XL   : R*8 - X COMPONENT OF INPUT DIRECTION
C    YL   : R*8 - Y COMPONENT OF INPUT DIRECTION
C    ZL   : R*8 - Z COMPONENT OF INPUT DIRECTION
C    PHIL : R*4 - 1 / R2S (CALCULATED IN VINIT)
C
C  INPUT VIA LABELED COMMON /DEFORM/:
C    DEF2 : R*4 - SUM OF THE SQUARES OF THE DEFORMATION COEFFICIENTS
C
C  OUTPUT ARGUMENTS:
C    TEL  : R*8 - TOTAL DISTANCE CORRECTION
C    KODE : I*4 - INDICATOR SHOWING HOW RAY INTERSECTED SURFACE
C        (SEE COXERN)
C
C  OUTPUT VIA LABELED COMMON /COMIC/:
C    XD : R*8 - X COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    YD : R*8 - Y COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    ZD : R*8 - Z COORD. OF RAY INTERSECTION WITH DEFORMED SURFACE
C    XG : R*8 - X COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C    YG : R*8 - Y COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C    ZG : R*8 - Z COMPONENT OF GRADIENT OF SURFACE AT INTERSECTION
C
C  EXTERNAL REFERENCES: ABZERN
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DOUBLE PRECISION K
      DOUBLE PRECISION CB, CE, SB, SE, YEP,
     1         DEL, F, FDOT, TS, XN, YN, ZAP, XAP, YAP
      COMMON /AXOFF/ CB, CE, SB, SE, YEP

      include 'saosacLib/comic.h'     ! xd,yd,zd,xl,yl,zl,xg,yg,zg,phil
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs

      PZK = P * ZD - K
      DEL = DBLE(XD)**2 + DBLE(YD)**2 + DBLE(PZK)**2 + DBLE(ZD)**2 + 1.0
      TS = DEL * 1.0E-14 + DEF2 * 1.0E-05
      TEL = 0.0
C
      IT = 0
      GO TO 20
10    CONTINUE
      FDOT = XG * XL + YG * YL + ZG * ZL
      IF (ABS (FDOT * DEL ) .LT. ABS (F + F)) GO TO 40
C
C  EVALUATE AND USE DEL
C
      DEL = - F / (FDOT + FDOT)
      TEL = TEL + DEL
      XD = XD + DEL * XL
      YD = YD + DEL * YL
      ZD = ZD + DEL * ZL
20    CONTINUE
C
C  EVALUATE THE SURFACE FUNCTION F
C
      XN = XD*PHIL
      YN = CE*(YD - YEP) - SE*ZD
      CALL ABZERN (XN, YN, ZAP, XAP, YAP, IER)
      IF (IER .GT. 1 .OR. IER .LT. 0) GO TO 50
      IF (IER .EQ. 1) GO TO 30
      ZF = ZD - CB*ZAP
      YF = YD - SB*ZAP
      PZK = P*ZF - K
      YX = -SE * XAP
      ZX = -CE * XAP
      YY = 1.0D0 - SB * CE * YAP
      ZY = -CB * CE * YAP
      YZ = SB * SE * YAP
      ZZ = 1.0D0 - CB * SE * YAP
      XG = XD + YF * YX + PZK * ZX
      YG = YF * YY + PZK * ZY
      ZG = PZK * ZZ + YF * YZ
      F = XD ** 2 + YF ** 2 + ZF*(PZK - K) - R2
      IF(ABS(F) .LT. TS) GO TO 60
      IT = IT + 1
      IF (IT .LE. 5) GO TO 10
C
C  KODE = 9 : TOO MANY ITERATIONS
      KODE = 9
      GO TO 60
C
30    CONTINUE
C  KODE = 6 : (XN, YN) IS OUTSIDE THE UNIT DISK
      KODE = 6
      GO TO 60
C
40    CONTINUE
C  KODE = 8 : EXCESSIVE DEFORMATION OR ZERO DIVIDE
      KODE = 8
      GO TO 60
C
50    CONTINUE
C  KODE = 12 : UNDETERMINED ERROR
      KODE = 12
      WRITE (8, 1000) IER
      GO TO 60
C
60    CONTINUE
      RETURN
1000  FORMAT (' IXERN ERROR : UNDETERMINED ERROR - IER = ', I5)
      END
