!+
!KWIC lkin1.f
!
!$Id: lkin1.f,v 1.2 2004/03/17 21:23:37 dtn Exp $
!
!Revisions:
!   97-May-20[D. Grumm]
!      . changed RTIME to CHARACTER*(8)
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

!
!  UPDATED 5/9/88 TO MAKE DFID CHARACTER * 4
!  PAUL GLENN, BAUER ASSOICATES, INC.
!
      SUBROUTINE LKIN1 (NSPEC, NPIXL, IMODE)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    LKIN1 FORTRAN
C    *    WRITTEN BY P. GLENN M/S 241 X (203) 797-5768
C    *            ON 02/09/82
C    *
C    *    UPDATE:   02/11/82
C    *    TIME:     11:04:42
C    *
C    ******************************************/
C
C  PURPOSE : TO READ THE FIRST THREE LINES OF INPUT FROM THE 'LOOK' FILE
C
C  OUTPUT PARAMETERS :
C    NSPEC : I*4 - NUMBER OF SPECULAR RAY FILES INPUT
C    NPIXL : I*4 - NUMBER OF PIXEL ARRAY FILES INPUT
C    IMODE : I*4 - 0 = READ FOLLOWING 'LOOK' PARAMS FROM TERM
C                  1 = READ FOLLOWING 'LOOK' PARAMS FROM FILE
C
C  INPUT VIA # 1 :
C    'LOOK' FILE
C
C  OUTPUT VIA LABELED COMMON /IDENT/ :
C    RID : R*4 - IDENTIFICATION ARRAY
C
C  XR : INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
      include 'saosacLib/ident.h' 
C      COMMON /IDENT/ GID (16), GDATE, GTIME (2),
C     1               RID (16), RDATE, RTIME (2),
C     2               DFID (16)
C      DOUBLE PRECISION GTIME
C      CHARACTER*4 GID,RID
C      CHARACTER*4 DFID
C      CHARACTER*(8) GDATE , RDATE, RTIME !*** WERE DOUBLE PRECISION
C
C
C  READ AND CHECK THE PARAMETERS
      READ (1, 9000, END = 2000, ERR = 2010) RID
      READ (1, 9010, END = 2000, ERR = 2010) NSPEC, NPIXL
      IF (NSPEC .LT. 0 .OR. NSPEC .GT. 7) GO TO 2020
      IF (NPIXL .LT. 0 .OR. NPIXL .GT. 14) GO TO 2020
      IF (NSPEC .EQ. 0 .AND. NPIXL .EQ. 0) GO TO 2020
      READ (1, 9020, END = 2000, ERR = 2010) IMODE
      IF (IMODE .NE. 0 .AND. IMODE .NE. 1) GO TO 2030
      RETURN
C
2000  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000)
      STOP 8
2010  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8010)
      STOP 8
2020  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8020) NSPEC, NPIXL
      STOP 8
2030  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8030) IMODE
      STOP 8
C
8000  FORMAT ('  LKIN1 - FATAL ERROR - UNEXPECTED EOF IN LOOK FILE')
8010  FORMAT ('  LKIN1 - FATAL ERROR - UNEXPECTED ERR IN LOOK FILE')
8020  FORMAT ('  LKIN1 - FATAL ERROR IN (NSPEC, NPIXL) =', 2I5)
8030  FORMAT ('  LKIN1 - FATAL ERROR IN (IMODE) =', I5)
9000  FORMAT (16A4)
9010  FORMAT (2I5)
9020  FORMAT (I5)
      END
