!+
!KWIC madd.f
!
!$Id: madd.f,v 1.2 2004/03/17 21:23:38 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to IMPLICIT NONE
!-

      SUBROUTINE MADD (JV, KV, LV, CON1, CON2)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    MADD FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/05/81
C    *
C    *    UPDATE:   05/06/81
C    *    TIME:     09:04:01
C    *
C    ******************************************/
C
C  PURPOSE :
C     TO FORM A LINEAR COMBINATION OF TWO MATRICES
C
C  INPUT ARGUMENTS :
C     JV   :  V# OF FIRST ROW OF FIRST MATRIX
C     KV   :  V# OF FIRST ROW OF SECOND MATRIX
C     LV   :  V# OF FIRST ROW OF OUTPUT MATRIX
C     CON1 :  CONSTANT BY WHICH TO MULTIPLY FIRST MATRIX
C     CON2 :  CONSTANT BY WHICH TO MULTIPLY SECOND MATRIX
C
C  OUTPUT :
C     VIA V# (LV, LV + 1, LV + 2) :
C       CON1 * (MATRIX JV) + CON2 * (MATRIX KV)
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER          JV, KV, LV
      DOUBLE PRECISION CON1, CON2

      INTEGER J
C
C  PERFORM ALL CALCULATIONS
      DO 100 J = 1, 3
      XV (LV + J - 1) = CON1 * XV (JV + J - 1)
     1                + CON2 * XV (KV + J - 1)
      YV (LV + J - 1) = CON1 * YV (JV + J - 1)
     1                + CON2 * YV (KV + J - 1)
      ZV (LV + J - 1) = CON1 * ZV (JV + J - 1)
     1                + CON2 * ZV (KV + J - 1)
100   CONTINUE
      RETURN
      END
