!+
!KWIC mout.f
!
!$Id: mout.f,v 1.2 2004/03/17 21:23:38 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to implicit none
!-

      SUBROUTINE MOUT (JV, KV, LV)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    MOUT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/05/81
C    *
C    *    UPDATE:   05/06/81
C    *    TIME:     09:37:12
C    *
C    ******************************************/
C
C  PURPOSE :  TO PERFORM AN OUTER VECTOR PRODUCT BETWEEN TWO VECTORS
C
C  INPUT ARGUMENTS :
C     JV :  V# OF VECTOR FOR LEFT SIDE OF MULTIPLICATION
C     KV :  V# OF VECTOR (TRANSPOSE) FOR RIGHT SIDE OF MULTIPLICATION
C     LV :  V# OF START OF RESULTANT MATRIX
C
C  OUTPUT :
C     VIA V# (LV, LV + 1, LV + 2) :
C       (VECTOR JV) * (VECTOR (TRANSPOSE) KV)
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER JV, KV, LV
C
C
C  PERFORM ALL CALCULATIONS
      XV (LV) = XV (JV) * XV (KV)
      YV (LV) = XV (JV) * YV (KV)
      ZV (LV) = XV (JV) * ZV (KV)
      XV (LV + 1) = YV (JV) * XV (KV)
      YV (LV + 1) = YV (JV) * YV (KV)
      ZV (LV + 1) = YV (JV) * ZV (KV)
      XV (LV + 2) = ZV (JV) * XV (KV)
      YV (LV + 2) = ZV (JV) * YV (KV)
      ZV (LV + 2) = ZV (JV) * ZV (KV)
      RETURN
      END
