!+
!KWIC mvmult.f
!
!$Id: mvmult.f,v 1.2 2004/03/17 21:23:38 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to IMPLICIT NONE
!-
      SUBROUTINE MVMULT (JV, KV, LV)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    MVMULT FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/7/88
C    *
C   /******************************************/
C
C
C  PURPOSE :  TO MULTIPLY A VECTOR BY A MATRIX
C
C  INPUT ARGUMENTS :
C     JV :  V# OF START OF MATRIX
C     KV :  V# OF VECTOR
C     LV :  V# OF RESULTANT VECTOR
C
C  OUTPUT :
C     VIA V# (LV) :  (MATRIX JV) * (VECTOR KV)
C
C
      IMPLICIT NONE

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER JV, KV, LV
C
C
C  PERFORM ALL CALCULATIONS
C
      XV (LV) = XV (JV    ) * XV (KV)
     1        + YV (JV    ) * YV (KV)
     2        + ZV (JV    ) * ZV (KV)
      YV (LV) = XV (JV + 1) * XV (KV)
     1        + YV (JV + 1) * YV (KV)
     2        + ZV (JV + 1) * ZV (KV)
      ZV (LV) = XV (JV + 2) * XV (KV)
     1        + YV (JV + 2) * YV (KV)
     2        + ZV (JV + 2) * ZV (KV)
      RETURN
      END
