!+
!KWIC nexrap.f
!
!$Id: nexrap.f,v 1.2 2004/03/17 21:23:38 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!      . convert TPI, RADDEG initialization to parameter
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . comment out declaration for VDOT
!-
!
!  UPDATED 2/8/88 TO INITIALIZE THE POLARIZATION DATA
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO ALLOW FOR FINITE DISTANCE POINT SOURCE
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE NEXRAP (IER)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    NEXRAP FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 01/11/80
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     07:58:23
C    *
C    ******************************************/
C  GENERATE NEXT RAY POSITION IN ANNULAR APERTURE
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (1) : R*8 - XAP = X COORD. OF CENTER OF ANNULUS
C    GEN (2) : R*8 - YAP = Y COORD. OF CENTER OF ANNULUS
C    GEN (5) : PSI - POLARIZATION MAJOR AXIS ANGLE (WAS EP1)
C              (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN (6) : E - RATIO OF MINOR TO MAJOR AXIS AMPLITUDE (WAS EP2)
C              (ABS VALUE BETWEEN 0 AND 1)
C              (POSITIVE FOR LEFT HANDED, NEGATIVE FOR RIGHT HANDED)
C              (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN (7)  : R*8 - AZIMUTH ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN (8)  : R*8 - ELEVATION ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN (9)  : R*8 - INNER RADIUS OF APERTURE ANNULUS
C    GEN (10) : R*8 - OUTER RADIUS OF APERTURE ANNULUS
C    GEN (13) : PTSRC - DISTANCE FROM PT SOURCE TO PUPIL CENTER
C
C  INPUT VIA LABELED COMMON /PARX/:
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C    H2   : R*4 - NOT NEEDED, DUMMIED TO -1. IN NEW VERSION
C
C  INPUT VIA LABELED COMMON /PLRZ/:
C    CPSI : R*8 - COSINE OF PSI (MAJOR AXIS ANGULAR POSITION)
C    SPSI : R*8 - SINE OF PSI
C    SQRE : R*8 - SQRT (1 + E**2) (OR SQRT (2) FOR RANDOM PLRZTION)
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    JRAY : I*4 - CURRENT RAY NUMBER
C    JING : I*4 - CURRENT RING NUMBER
C    MR   : I*4 - NUMBER OF RINGS IN CURRENT SPOKE
C    J2   : I*4 - CURRENT SPOKE NUMBER
C    R    : R*4 - RADIUS OF CURRENT RING
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    LSW0 (4) : F - RANDOM POLARIZATION, T - DISCRETE POLARIZATION
C
!  INPUT/OUTPUT OF DIRECTIONS CHANGED 5/9/88 - HAD BEEN COLLIMATED
!  BUNDLE DIRECTION INPUT VIA V#2.  NOW -
!
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, ZCOMP/:
C    V#40 : DIRECTION FROM PT SOURCE TO PUPIL CENTER (SET BY NABRAT)
C
C  OUPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, ZCOMP/:
C    V#2 : DIRECTION FROM PT SOURCE TO POINT IN PUPIL
C
C  OUTPUT VIA LABELED COMMON /RAIN/:
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
C  OUTPUT ARGUMENT:
C    IER : I*4 - ERROR CODE
C        : 0 - NO ERROR
C        : -JRAY = # RAYS IN PATTERN, NO MORE RAYS AVAILABLE
C
C  OUTPUT VIA LABELED COMMON /RAIN/:
C    FOP  : R*8 - FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : I*4 - INTEGER PORTION OF PATH LENGTH
C    JRAY : I*4 - CURRENT RAY NUMBER
C    JING : I*4 - CURRENT RING NUMBER
C    MR   : I*4 - NUMBER OF RINGS IN CURRENT SPOKE
C    J2   : I*4 - CURRENT SPOKE NUMBER
C    R    : R*4 - RADIUS OF CURRENT RING
C
C  XR : VDOT, VUNIT
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /PLRZ/ CPSI, SPSI, SQRE
!!!   DOUBLE PRECISION VDOT
      DOUBLE PRECISION      TPI
      PARAMETER ( TPI = 6.28318 53071 79586D0 )
      DOUBLE PRECISION      RADDEG
      PARAMETER ( RADDEG = 0.01745 32925 19943 3D0 )
      SAVE THT, C, S, XP, YP
!
!
!  BEGIN BY INITIALIZING THE COMPLEX POLARIZATION MATRICES
!
      ECC = 1.D0
      IF (LSW0 (4)) ECC = GEN (6)
      C2COMP (1) = DCMPLX (  CPSI / SQRE, 0.D0)
      C2COMP (2) = DCMPLX (  SPSI / SQRE, 0.D0)
      S2COMP (1) = DCMPLX (- SPSI / SQRE, 0.D0) * ECC
      S2COMP (2) = DCMPLX (  CPSI / SQRE, 0.D0) * ECC
C
C  SET NUM OF CURRENT RING, INIT ERROR CODE
      JING = JING + 1
      IER = 0
C
C  Q, SEE IF CURRENT RING NUM GREATER THAN TOTAL NUMBER OF RINGS
      IF (JING .LE. MR) GO TO 40
C
C  Y1, GO TO NEXT SPOKE
      J2 = J2 + 1
C
C  Y2, SEE IF CURRENT SPOKE NUM GREATER THAN TOTAL NUMBER OF SPOKES
      IF (J2 .GT. M2) GO TO 70
C
C  YN1, INITIALIZE VALUES FOR THIS SPOKE
      MR = MING
      THT = TPI * (J2 - 1.) / M2
      JING = 1
      C = DCOS (THT)
      S = DSIN (THT)
      IF (GEN (9) .GT. 0.D0) GO TO 35
      IF (JRAY .GT. 0) GO TO 30
C  (FIRST RAY, R1 = 0.D0)
      R = 0.
      XP = 0.
      YP = 0.
      GO TO 40
C  (NOT FIRST RAY, R1 = 0.D0)
30    MR = MR - 1
C  (ANY RAY, R1 .GT. 0.D0)
35    R = RZER
      XP = R * C
      YP = R * S
C
C  N2, YN2 SET X, Y VALUES FOR THIS RAY
40    JRAY = JRAY + 1
      KODE = 0
      XV (1) = XP + GEN (1)
      YV (1) = YP + GEN (2)
      ZV (1) = 0.0D0
!
!  THE S-VECTOR (PUPIL DISPLACEMENT) IS (XP,YP,0), AND THE DIRECTION
!  FROM PT SOURCE TO THE PUPIL CENTER IS IN VECTOR #40 - PROVIDE NEW
!  CALCULATIONS FOR THE RAY DIRECTION (VECTOR #2), AND THE OPD (FOP)
!
!     FOP = VDOT (1, 2)
!
C  (FOR ALL OF THE CALCULATIONS BELOW, USE THE TOTAL OFF-AXIS DISTANCE,
C  WHICH IS LARGER THAN JUST GEN (13) BECAUSE OF THE COSINE EFFECT.)
      COSEFF = DCOS (GEN (7) * RADDEG) * DCOS (GEN (8) * RADDEG)
      GEN13 = GEN (13) / COSEFF
C  (START WITH THE DIRECTION VECTOR)
      XV (2) = XV (40) + XP / GEN13
      YV (2) = YV (40) + YP / GEN13
      ZV (2) = ZV (40)
      CALL VUNIT (2, 2, SIZE)
C  (FINISH WITH THE OPD)
      GAMMA = R / GEN13
      E0DOTS = XV (40) * C + YV (40) * S
      DELTA = GAMMA * (E0DOTS + E0DOTS + GAMMA)
      IF (DABS (DELTA) .LT. 6.5D-4) GO TO 45
C  (USE THE STRAIGHT SQUARE ROOT EVALUATION)
      FOP = GEN (10) + GEN13 * (DSQRT (1.D0 + DELTA) - 1.D0)
      GO TO 47
C  (USE THE POWER SERIES EVALUATION)
45    ALPHA = E0DOTS + GAMMA / 2.D0
      FOP = GEN (10) + ALPHA * R * (1.D0 - 0.25D0 * DELTA *
     *      (1.D0 - 0.5D0 * DELTA * (1.D0 - 0.625D0 * DELTA)))
47    CONTINUE
!
      IOP = 0
C
C  N3, EXPAND XP AND YP TO NEXT POSITION
      IF (R .EQ. 0.) GO TO 50
      R = DSQRT (R * R + DR)
      GO TO 55
50    R = RZER
55    XP = R * C
      YP = R * S
      GO TO 200
C
C  YYI, FINISHED ALL RINGS, SET IER AND EXIT
70    IER = -JRAY
200   RETURN
      END
