!+
!KWIC ninit.f
!
!$Id: ninit.f,v 1.2 2004/03/17 21:23:38 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

!
!  UPDATED 12/22/88 TO BYPASS CALCULATIONS FOR OBSCURATIONS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE NINIT (DP0)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    NINIT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/05/81
C    *
C    *    UPDATE:   11/10/81
C    *    TIME:     11:53:23
C    *
C    ******************************************/
C
C  PURPOSE :  FOR ONE RAY, INITIALIZE NORMAL UNIT VECTORS
C             AT ALL INTERMEDIATE SURFACES
C             AND EVALUATE THE SINS OF THE GRAZING ANGLES
C
C  INPUT :
C     VIA /PARX/ :
C       NS   :  NUMBER OF SURFACES
C     VIA /SWITCH/ :
C       LSW (3, J) :  SURFACE FLATNESS SWITCH
C       LSW (5, J) :  ANNULAR OBSCURATION SWITCH
C       LSW (6, J) :  RECTANGULAR OBSCURATION SWITCH
C
C  OUTPUT :
C     VIA V# (VARIOUS) :  NORMALIZED UNIT VECTORS
C     DP0 (J)          :  ARRAY OF SINS OF GRAZING ANGLES
C
C  XR : VDOT, VUNIT
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION VDOT
      DOUBLE PRECISION RNRM
      DIMENSION DP0 (1)
C
C
C  LOOP ONCE FOR EACH SURFACE
      DO 200 J = 1, NS
C
C  CHECK FOR SURFACE FLATNESS
      IF (LSW (3, J)) GO TO 190
!
!  CHECK FOR OBSCURATION
      IF (LSW (5, J) .OR. LSW (6, J)) GO TO 190
C
C  SET INDECES FOR INCIDENT RAY, REFLECTED RAY, AND NORMAL VECTOR
      NS0 = J + NDIM + 31
      NS1 = NS0 + 1
      NNORM = NS0 + NDIM + 2
C
C  PERFORM CALCULATIONS
      XV (NNORM) = XV (NS0) - XV (NS1)
      YV (NNORM) = YV (NS0) - YV (NS1)
      ZV (NNORM) = ZV (NS0) - ZV (NS1)
      CALL VUNIT (NNORM, NNORM, RNRM)
      DP0 (J) = VDOT (NS0, NNORM)
      GO TO 200
C
C  SET SIN OF GRAZING ANGLE TO DUMMY ZERO
190   DP0 (J) = 0.
200   CONTINUE
      RETURN
      END
