!+
!KWIC ogsum.f
!
!$Id: ogsum.f,v 1.2 2004/03/17 21:23:39 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /SENS/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE OGSUM (RPUPIL, XBFTOT, YBFTOT, RMS1, RMS2, RMS3)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    OGSUM FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: WRITE A SUMMARY REPORT FOR OPDGEN TO UNITS 6 AND 8
C
C  INPUT PARAMETERS:
C    RPUPIL: R*8 - PUPIL OUTER RADIUS
C    XBFTOT: R*8 - X-COORD OF BEST FOCUS AFTER CHANGES AND TILT REMOVAL
C    YBFTOT: R*8 - Y-COORD
C    RMS1: R*8 - RMS WAVEFRONT ERROR AFTER TILT REMOVAL, BUT
C                BEFORE THE CONSTRUCTIONAL CHANGES
C    RMS2: R*8 - RMS WAVEFRONT ERROR FROM THE CONSTRUCTIONAL
C                CHANGES ONLY (NO TILT)
C    RMS3: R*8 - RMS WAVEFRONT ERROR AFTER BOTH TILT REMOVAL AND
C                THE CONSTRUCTIONAL CHANGES
C
C  INPUT VIA LABELED COMMON /DEFORM/:
C    NDF: I*4 - NUMBER OF ZERNIKE'S USED IN CHARACTERIZING THE
C               EFFECTS OF THE CHANGES
C    DEFC: R*8 - ZERNIKE COEFFICIENTS CAUSED BY THE CHANGES
C    OBSC: R*8 - LINEAR OBSCURATION RATIO
C
C  INPUT VIA LABELED COMMON /SENS/:
C    DFID: 64-CHARACTER ID TEXT
C    NCH: I*4 - NUMBER OF CONSTRUCTIONAL CHANGES BEING CONSIDERED
C    CHGS (J): R*8 - AMOUNT BY WHICH TO VARY THE J'TH CONSTRUCTIONAL
C                    CHANGE PARAMETER.  (THE CONSTRUCTIONAL CHANGE
C                    PARAMETERS ARE DEFINED IN THE .SNS FILE BELOW.)
C                    (IT IS THE USER'S RESPONSIBILITY TO BE SURE THAT
C                    THE DESIRED CHANGES MATCH IN NUMBER AND FORM
C                    WITH THE CHANGES DEFINED IN THE SENSITIVITY
C                    CALCULATIONS LEADING TO THE .SNS FILE.)
C    ICHS (J): I*4 -
C         ARRAY OF INTEGERS DENOTING WHICH CONSTRUCTIONAL
C         PARAMETER TO VARY FOR THE J'TH DESIRED CHANGE.
C         CHANGES ARE EITHER TO GI FILE PARAMETERS (WHICH
C         ARE DEFINED WITH PARAMETER NUMBERS CALLED 'ITN' -
C         SEE OSAC DOCUMENTATION), OR TO DEFORM FILE
C         PARAMETERS (WHICH ARE DEFINED WITH ZERNIKE
C         COEFFICIENT NUMBER 'IDF').  THE TYPE AND NUMBER
C         OF THE DESIRED CHANGE CAN BE GATHERED FROM THE
C         ICHS ELEMENT AS FOLLOWS:
C       1-99:     ICHS = (SYSTEM) ITN NUMBER
C       .GT. 100: ICHS / 100 = SURFACE NUMBER
C                 MOD (ICHS, 100) = (SURFACE) ITN NUMBER
C       .LT. 0:   (- ICHS) / 100 = SURFACE NUMBER
C                 MOD ((- ICHS), 100) = IDF NUMBER
C    ZCOF0 (I): R*8 -
C         I'TH ANNULAR ZERNIKE POLYNOMIAL COEFFICIENT FOR THE
C         NOMINAL OPD FILE
C
C  OUTPUT VIA FILE #'S 6 AND 8:
C    SUMMARY REPORTS
C
C  EXTERNAL REFERENCES: INCLIN
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
C      COMMON /IDENT/ GID (16), GDATE, GTIME (2),
C     1               RID (16), RDATE, RTIME (2),
C     2               DFID (16)

      include 'saosacLib/ident.h'
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...

C      CHARACTER*4 GID,RID
C      CHARACTER * 4 DFID
C      CHARACTER*8 GDATE , RDATE !*** WERE DOUBLE PRECISION
C
C
C  DISPLAY THE SENSITIVITY FILE TEXT
C
      CALL INCLIN (3)
      WRITE (8, 8000) DFID
C
C  DISPLAY THE NUMBERS OF CHANGES AND COEFFICIENTS TO THE TERMINAL
C
C
C  DISPLAY THE CONSTRUCTIONAL CHANGES
C
      CALL INCLIN (4)
      WRITE (8, 8020) NCH
      DO 120 ICH = 1, NCH
      IABSCH = IABS (ICHS (ICH))
      KURF = IABSCH / 100
      ITNIDF = MOD (IABSCH, 100)
      IF (ICHS (ICH) .LT. 0) ITNIDF = - ITNIDF
      CALL INCLIN (1)
      WRITE (8, 8030) ICH, KURF, ITNIDF, CHGS (ICH)
120   CONTINUE
C
C  DISPLAY THE BEST FOCUS COORDINATES
C
      CALL INCLIN (3)
      WRITE (8, 8040) XBFTOT, YBFTOT
C
C  DISPLAY THE ZERNIKE COEFFICIENTS AND WAVEFRONT RMS VALUES
C
      CALL INCLIN (8)
      WRITE (8, 8050) NDF, RPUPIL, OBSC
      DO 140 IDF = 1, NDF
      COMP = ZCOF0 (IDF) + DEFC (IDF)
      CALL INCLIN (1)
      WRITE (8, 8060) IDF, ZCOF0 (IDF), DEFC (IDF), COMP
140   CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8080) RMS1, RMS2, RMS3
      RETURN
C
8000  FORMAT (/ '  ID TEXT FROM THE SENSITIVITY FILE:' / 6X, 16A4)
8010  FORMAT (/ '  NUMBER OF CONSTRUCTIONAL CHANGES:', I3 /
     *          '  NUMBER OF ZERNIKE COEFFICIENTS:  ', I3)
8020  FORMAT (/ '  NUMBER OF CONSTRUCTIONAL CHANGES:', I4 /
     *          '                SURF. #       PARAM #' /
     *          '  CHANGE #      (0: SYS)      (-: POLY #)   CHANGE')
8030  FORMAT (I8, 2I14, 1P,D20.4)
8040  FORMAT (/ '  BEST FOCUS X-COORDINATE AFTER CHANGES:', 1P,D14.6 /
     *          '  BEST FOCUS Y-COORDINATE AFTER CHANGES:', 1P,D14.6)
8050  FORMAT (/ '  NUMBER OF ZERNIKE POLYNOMIALS:', I4 /
     *       '  PUPIL OUTER RADIUS:           ', 1P,D14.6 /
     *       '  LINEAR OBSCURATION RATIO:     ', 0P,F10.6 //
     *       '                ------- RMS WAVEFRONT VALUES --------' /
     *       '                NOMINAL       CHANGES       TOTAL' /
     *       '  POLY #        (NO CHANGES)  ONLY          COMPOSITE')
8060  FORMAT (I6, 1P,D22.6, 1P,2D14.6)
8070  FORMAT (/ '      --- WAVEFRONT RMS (WITHOUT TILT) ----' /
     *          '      NOMINAL       CHANGES       TOTAL' /
     *          '      (NO CHANGES)  ONLY          COMPOSITE' /
     *          1P,D18.6, 1P,2D14.6)
8080  FORMAT (/ '  TOTAL RMS:  ', 1P,3D14.6)
      END
