!+
!KWIC opdchg.f
!
!$Id: opdchg.f,v 1.2 2004/03/17 21:23:39 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . reorder /SENS/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE OPDCHG (RPUPIL, XBFTOT, YBFTOT, RMS1, RMS2, RMS3)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    OPDCHG FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: INPUT THE NOMINAL OPD FILE, CALCULATE THE NEW OPD
C           DUE TO THE CONSTRUCTIONAL CHANGES, AND OUTPUT THE
C           NEW OPD FILE.  ALSO, KEEP TRACK OF RMS WAVEFRONT
C           BEFORE AND AFTER THE CHANGES
C
C  INPUT PARAMETER:
C    RPUPIL: R*8 - PUPIL OUTER RADIUS
C
C  INPUT VIA LABELED COMMON /DEFORM/:
C    NDF: I*4 - NUMBER OF ZERNIKE'S USED IN CHARACTERIZING THE
C               EFFECTS OF THE CHANGES
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (1): R*8 - XAP = X OF CENTER OF ANNULAR APERTURE
C    GEN (2): R*8 - YAP = Y OF CENTER OF ANNULAR APERTURE
C
C  INPUT VIA LABELED COMMON /SENS/:
C    NCH: I*4 - NUMBER OF CONSTRUCTIONAL CHANGES BEING CONSIDERED
C    CHGS (J): R*8 - AMOUNT BY WHICH TO VARY THE J'TH CONSTRUCTIONAL
C                    CHANGE PARAMETER.  (THE CONSTRUCTIONAL CHANGE
C                    PARAMETERS ARE DEFINED IN THE .SNS FILE BELOW.)
C                    (IT IS THE USER'S RESPONSIBILITY TO BE SURE THAT
C                    THE DESIRED CHANGES MATCH IN NUMBER AND FORM
C                    WITH THE CHANGES DEFINED IN THE SENSITIVITY
C                    CALCULATIONS LEADING TO THE .SNS FILE.)
C    ICHS (J): I*4 -
C         ARRAY OF INTEGERS DENOTING WHICH CONSTRUCTIONAL
C         PARAMETER TO VARY FOR THE J'TH DESIRED CHANGE.
C         CHANGES ARE EITHER TO GI FILE PARAMETERS (WHICH
C         ARE DEFINED WITH PARAMETER NUMBERS CALLED 'ITN' -
C         SEE OSAC DOCUMENTATION), OR TO DEFORM FILE
C         PARAMETERS (WHICH ARE DEFINED WITH ZERNIKE
C         COEFFICIENT NUMBER 'IDF').  THE TYPE AND NUMBER
C         OF THE DESIRED CHANGE CAN BE GATHERED FROM THE
C         ICHS ELEMENT AS FOLLOWS:
C       1-99:     ICHS = (SYSTEM) ITN NUMBER
C       .GT. 100: ICHS / 100 = SURFACE NUMBER
C                 MOD (ICHS, 100) = (SURFACE) ITN NUMBER
C       .LT. 0:   (- ICHS) / 100 = SURFACE NUMBER
C                 MOD ((- ICHS), 100) = IDF NUMBER
C    SNSMAT (I, J): R*8 -
C         CHANGE IN THE I'TH ANNULAR ZERNIKE POLYNOMIAL COEFFICIENT
C         FOR A UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE
C         PARAMETER.  SNSMAT (1, J) = 0.D0, SINCE PISTON IS ALWAYS
C         THROWN AWAY.
C    XBFSNS (J): R*8 -
C         CHANGE IN X-COORDINATE OF THE BEST FOCUS LOCATION FOR A
C         UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE PARAMETER.
C    YBFSNS (J): R*8 -
C         CHANGE IN Y-COORDINATE OF THE BEST FOCUS LOCATION FOR A
C         UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE PARAMETER.
C    ZCOF0 (I): R*8 -
C         I'TH ANNULAR ZERNIKE POLYNOMIAL COEFFICIENT FOR THE
C         NOMINAL OPD FILE (ON OUTPUT, COEFFICIENTS 1-3 ARE SET
C         TO ZERO TO SHOW LACK OF PISTON AND TILT AT BEST FOCUS)
C
C  INPUT VIA FILE #9 (.OPD FILE):
C    OPD FILE FOR NOMINAL SYSTEM (I.E., WITH ALL CHANGES = 0)
C
C  INPUT VIA FILE #11 (.DFR FILE):
C    DEFORM FILE FOR NOMINAL SYSTEM (I.E., WITH ALL CHANGES = 0)
C
C  OUPUT PARAMETERS:
C    XBFTOT: R*8 - X-COORD OF BEST FOCUS AFTER CHANGES AND TILT REMOVAL
C    YBFTOT: R*8 - Y-COORD
C    RMS1: R*8 - RMS WAVEFRONT ERROR AFTER TILT REMOVAL, BUT
C                BEFORE THE CONSTRUCTIONAL CHANGES
C    RMS2: R*8 - RMS WAVEFRONT ERROR FROM THE CONSTRUCTIONAL
C                CHANGES ONLY (NO TILT)
C    RMS3: R*8 - RMS WAVEFRONT ERROR AFTER BOTH TILT REMOVAL AND
C                THE CONSTRUCTIONAL CHANGES
C
C  OUTPUT VIA LABELED COMMON /SENS/:
C    ZCOF0 (I): R*8 - COEFFICIENTS 1-3 ARE SET TO ZERO TO SHOW LACK
C                     OF PISTON AND TILT AT BEST FOCUS
C
C  OUTPUT VIA FILE #2:
C    OPD FILE FOR SYSTEM INCORPORATING ALL CHANGES
C
C  EXTERNAL REFERENCES: ANNULR, HEDRAY, INCLIN, REHEAD, ZERNIK
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION ZVAL (325), ZDUM (325)
      CHARACTER * 4 DFSAVE (16)

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      LOGICAL * 1 LSWSAV
C
C
C  READ AND WRITE THE FIRST THREE OPD HEADER LINES
C
      KURF = -1
      CALL REHEAD (9, -1, IER)
      IF (IER .NE. 0) GO TO 2000
      CALL HEDRAY (-2, 2)
C
C  READ THE BASELINE OPD FILE REFERENCE SPHERE DATA
C
      READ (9, 7000, END = 2010, ERR = 2020) XBF0, YBF0, EFL
C
C  READ THE BASELINE WAVEFRONT DEFORM FILE, BUT SAVE THE TEXT
C  IN DFID (FROM THE SENSITIVITY FILE)
!  (TEMPORARILY SET KURF TO 1, AND THE CORRESPONDING X-RAY FLAG TO
!  FALSE, SO THAT THE NEW REDECO WILL ASSUME A CONVENTIONAL 'SURFACE')
C
      NDF0 = NDF
      OBSC0 = OBSC
      DO 110 I = 1, 16
      DFSAVE (I) = DFID (I)
110   CONTINUE
!
      KURF = 1
      LSWSAV = LSW (9, KURF)
      LSW (9, KURF) = .FALSE.
      CALL REDECO (11, 0, IER)
      IF (IER .NE. 0) STOP 8
      KURF = -1
      LSW (9, KURF) = LSWSAV
!
      IF (NDF .NE. NDF0 .OR. DABS (OBSC - OBSC0) .GT. 1.D-5) GO TO 2000
      DO 120 I = 1, 16
      DFID (I) = DFSAVE (I)
120   CONTINUE
      DO 140 IDF = 1, NDF
      ZCOF0 (IDF) = DEFC (IDF)
140   CONTINUE
C
C  FIND THE ZERNIKE COEFFICIENTS AND REFERENCE SPHERE SHIFT TO ADD
C  TO THE NOMINAL OPD FILE IN MAKING THE NEW OPD FILE
C
      DO 150 IDF = 1, NDF
      DEFC (IDF) = 0.D0
150   CONTINUE
      XBFTOT = 0.D0
      YBFTOT = 0.D0
C
      DO 180 ICH = 1, NCH
      DO 160 IDF = 1, NDF
      DEFC (IDF) = DEFC (IDF) + SNSMAT (IDF, ICH) * CHGS (ICH)
160   CONTINUE
      XBFTOT = XBFTOT + XBFSNS (ICH) * CHGS (ICH)
      YBFTOT = YBFTOT + YBFSNS (ICH) * CHGS (ICH)
180   CONTINUE
C
C  ADD ALL THE TILT COEFFICIENTS TO THE REFERENCE SPHERE SHIFT, TO
C  PREPARE FOR THE FINAL OPD FILE HAVING NO TILT IN IT AT ALL
C
      CONST = 2.D0 * EFL / (DSQRT (1.D0 + OBSC * OBSC) * RPUPIL)
      XBFTOT = XBF0 + XBFTOT + CONST * (ZCOF0 (2) + DEFC (2))
      YBFTOT = YBF0 + YBFTOT + CONST * (ZCOF0 (3) + DEFC (3))
      WRITE (2, 7000) XBFTOT, YBFTOT, EFL
C
C  SET DEFC (CHANGE) TERMS 2 AND 3 (TILT) AND 1 (PISTON) TO BE MINUS
C  THE ORIGINAL (ZCOF0), SO THAT THERE REALLY WILL BE NO TILT (OR
C  PISTON) IN THE FINAL OPD FILE
C
      DEFC (1) = - ZCOF0 (1)
      DEFC (2) = - ZCOF0 (2)
      DEFC (3) = - ZCOF0 (3)
C
C  LOOP THROUGH THE OPD FILE
C
      OBSCSQ = OBSC * OBSC
      RMS1 = 0.D0
      RMS2 = 0.D0
      RMS3 = 0.D0
      WTOT = 0.D0
      JRAY = 0
200   JRAY = JRAY + 1
      READ (9, *, END = 2010, ERR = 2020) KRAY, KING, K2, KODE2,
     1                                    IN102
      WRITE (2, 7005) KRAY, KING, K2, KODE2, IN102
      IF (KRAY .GT. 0) GO TO 240
      IF (KRAY .EQ. (1 - JRAY)) GO TO 400
      JRAY = 1 - JRAY
      GO TO 2030
240   CONTINUE
      IF (KRAY .NE. JRAY) GO TO 2030
      IF (KODE2 .GT. 4) GO TO 200
C
C  THE CURRENT RAY IS GOOD - SET THE WEIGHT, AND READ THE
C  PUPIL LOCATION AND OPD
C
      W = 1.D-8 * IN102
      WTOT = WTOT + W
      READ (9, *, END = 2010, ERR = 2020) XPU, YPU, ZPU,
     *                                    XD, YD, ZD, OPDIN
C
C  DEFINE SEPARATE OPD CHANGES FOR (1) THE ZERNIKE TERMS ABOVE 3,
C  AND (2) MINUS THE PISTON AND TILT IN THE ORIGINAL FILE
C
      XN = (XPU - GEN (1)) / RPUPIL
      YN = (YPU - GEN (2)) / RPUPIL
      RSQ = XN * XN + YN * YN
      IF (RSQ .LT. OBSCSQ .OR. RSQ .GT. 1.D0) GO TO 2040
      IF (OBSC .EQ. 0.D0)
     *   CALL ZERNIK (NDF, XN, YN, ZVAL, ZDUM, ZDUM, IER)
      IF (OBSC .GT. 0.D0)
     *   CALL ANNULR (NDF, OBSC, NNDX, NDXARR, COFMAT,
     *                XN, YN, ZVAL, ZDUM, ZDUM, IER)
      DELOPD = 0.D0
      IF (NDF .EQ. 3) GO TO 280
      DO 260 IDF = 4, NDF
      DELOPD = DELOPD + DEFC (IDF) * ZVAL (IDF)
260   CONTINUE
280   DELTLT = DEFC (1) + DEFC (2) * ZVAL (2) + DEFC (3) * ZVAL (3)
C
C  DEFINE THE OUTPUT OPD AS THE INPUT OPD, PLUS THE INCREMENT
C  DEFINED BY THE NEGATIVE OF THE NOMINAL PISTON AND TILT, PLUS THE
C  INCREMENT REQUIRED BY THE CONSTRUCTIONAL CHANGES
C
      WOTILT = OPDIN + DELTLT
      OPDOUT = WOTILT + DELOPD
C
C  MODIFY THE RMS'S AND DO THE OUTPUT
C
      RMS1 = RMS1 + WOTILT * WOTILT
      RMS2 = RMS2 + DELOPD * DELOPD
      RMS3 = RMS3 + OPDOUT * OPDOUT
      WRITE (2, 7010) XPU, YPU, ZPU, XD, YD, ZD, OPDOUT
      GO TO 200
C
C  ALL DONE WITH THE FILE - FINISH THE RMS CALCULATIONS, WRITE
C  THE REST OF THE OPD TRAILER RECORD, AND RETURN
C
400   RMS1 = DSQRT (RMS1 / WTOT)
      RMS2 = DSQRT (RMS2 / WTOT)
      RMS3 = DSQRT (RMS3 / WTOT)
      READ (9, *, END = 2010, ERR = 2020) WF2, WS2
      WRITE (2, 7020) WF2, WS2
      RETURN
C
2000  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000) IER
      STOP 8
2010  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8010)
      STOP 8
2020  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8020)
      STOP 8
2030  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8030) JRAY, KRAY
      STOP 8
2040  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8040) JRAY, XPU, YPU, XN, YN
      STOP 8
2050  CONTINUE
      CALL INCLIN (3)
      WRITE (8, 8050) NDF, NDF0, OBSC, OBSC0
      STOP 8
C
7000  FORMAT (1P,3D20.12)
7005  FORMAT (5I10)
7010  FORMAT (1P,3D25.17 / 0P,3F21.17, 1P,D16.6)
7020  FORMAT (1P,2D20.12)
8000  FORMAT ('  OPDCHG FATAL ERROR - REHEAD IER =', I6)
8010  FORMAT ('  OPDCHG FATAL ERROR - EOF READING OPD FILE')
8020  FORMAT ('  OPDCHG FATAL ERROR - ERROR READING OPD FILE')
8030  FORMAT ('  OPDCHG FATAL ERROR IN OPD FILE INPUT:' /
     *        '    RAY NUMBER (EXPECTED, ACTUAL) =', 2I6)
8040  FORMAT ('  OPDCHG FATAL ERROR - RAY PUPIL COORDINATES ARE' /
     *        '                       OUTSIDE OF SPECIFIED ANNULUS' /
     *        '    JRAY:', I6 /
     *        '    ABSOLUTE RAY PUPIL COORDINATES:  ', 1P,2D14.6 /
     *        '    NORMALIZED RAY PUPIL COORDINATES:', 1P,2D14.6)
8050  FORMAT ('  OPDCHG FATAL ERROR IN NOMINAL DEFORM FILE' /
     *        '    NDF (INPUT, EXPECTED) =', 2I6 /
     *        '    OBSC (INPUT, EXPECTED) =', 1P,2D14.6)
      END
