!+
!KWIC opdsum.f
!
!$Id: opdsum.f,v 1.2 2004/03/17 21:23:39 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE OPDSUM (LURF, EFLBAR, OPDRMS)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    OPDSUM FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 10/28/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:05:47
C    *
C    ******************************************/
C
C  WRITE SUMMARY REPORT TO # 6 AND # 8
C
C  INPUT PARAMETER :
C    LURF   : I*4 - SURFACE NUMBER OF SPECULAR RAY FILE
C    EFLBAR : R*8 - AVERAGE EFFECTIVE FOCAL LENGTH
C    OPDRMS : R*8 - RMS VALUE OF OPD'S
C                 (-1 FOR 'ARAY', NS+1 FOR 'RAY' FILE)
C
C  INPUT VIA LABELED COMMON /PARM/ :
C    GEN ( 9) : R*8 - INNER RADIUS OF APERTURE ANNULUS
C    GEN (10) : R*8 - OUTER RADIUS OF APERTURE ANNULUS
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS   : I*4 - NUMBER OF SURFACES IN SYSTEM
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C
C  INPUT VIA LABELED COMMON /SUMRY/ :
C    WS2   : R*8 - TOTAL RAY WEIGHT
C    LEFT2 : I*4 - NUMBER OF SUCCESSFUL RAYS
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/
C    V # 5 : BEST FOCUS POSITION = CENTER OF REFERENCE SPHERE
C
C  OUTPUT VIA # 6 AND # 8 :
C    OPD CALCULATION SUMMARY REPORT
C
C  XR : INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION EFLBAR, OPDRMS
C
C
C  WRITE SYSTEM INFORMATION
      CALL INCLIN (15)
      WRITE (8, 8000)
!     IF (LSW0 (1)) GO TO 110
!     WRITE (8, 8010)
!     GO TO 120
!110  CONTINUE
!     WRITE (8, 8020)
120   CONTINUE
      IF (LURF .EQ. -1) GO TO 130
      WRITE (8, 8030)
      GO TO 140
130   CONTINUE
      WRITE (8, 8040)
140   NORIG = MING * M2
      IF (GEN (9) .EQ. 0.D0) NORIG = NORIG - M2 + 1
      WRITE (8, 8050) NS, NORIG, LEFT2, WS2, XV (5), YV (5)
      WRITE (8, 8060) EFLBAR, GEN (9), GEN (10), OPDRMS
      RETURN
C
8000  FORMAT (/ T25, 'OPD CALCULATION SUMMARY REPORT' /
     1          T25, '------------------------------' /)
!8010 FORMAT ('  TYPE OF SYSTEM (XRAY / CONV) :', T40, 'CONVENTIONAL')
!8020 FORMAT ('  TYPE OF SYSTEM (XRAY / CONV) :', T40, '       X-RAY')
8030  FORMAT ('  SOURCE OF INPUT RAY FILE :', T40, ' NABRAT/DRAT')
8040  FORMAT ('  SOURCE OF INPUT RAY FILE :', T40, '      DEDRIQ')
8050  FORMAT ('  NUMBER OF SURFACES IN SYSTEM :', T40, I12 /
     1        '  NUMBER OF TRACED RAYS :', T40, I12 /
     2        '  NUMBER OF SUCCESSFUL RAYS :', T40, I12 /
     3        '  TOTAL RAY WEIGHT :', T40, F12.5 /
     4        '  X COORD OF REF SPHERE (BEST FOCUS) :', T40, 1P,D12.5 /
     5        '  Y COORD OF REF SPHERE (BEST FOCUS) :', T40, 1P,D12.5)
8060  FORMAT ('  EFFECTIVE FOCAL LENGTH :', T40, 1P,D12.5 /
     2        '  INNER RADIUS OF TRACED ANNULUS :', T40, 1P,D12.5 /
     3        '  OUTER RADIUS OF TRACED ANNULUS :', T40, 1P,D12.5 /
     4        '  RMS OPD VALUE OVER PUPIL :', T40, 1P,D12.5)
      END
