!+
!KWIC poldsp.f
!
!$Id: poldsp.f,v 1.1 2004/03/16 15:50:01 dtn Exp $
!
!Revisions:
!   93-Oct-15[T. Gaetz]
!      . eliminate ascii io to unit 6; unit 6 now feeds binary pipe and
!        should be clear of ascii output; see unit 8 for messages
!-

      SUBROUTINE POLDSP (IZERK, NORD, MORD, ICS, FIRST, NTERMS, POLY)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    POLDSP FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 4/12/88
C    *
C   /******************************************/
C
C  PURPOSE: DISPLAY THE DEFINING COEFFICIENTS OF A ZERNIKE POLYNOMIAL
C           (DISPLAYS SIMULTANEOUSLY TO UNITS 6 AND 8)
C           (DISPLAYS BOTH COSINE AND SINE POLYNOMIALS IF THE
C            AZIMUTHAL ORDER IS GREATER THAN 0)
C
C  INPUT PARAMETERS:
C    IZERK: I*4 - ZERNIKE POLYNOMIAL NUMBER, IN THE STANDARD OSAC ORDER
C    NORD: I*4 - RADIAL ORDER OF THE POLYNOMIAL
C    MORD: I*4 - AZIMUTHAL ORDER OF THE POLYNOMIAL
C    ICS: I*4 - 1 FOR COSINE (OR MORD=0), 2 FOR SINE M-THETA
C    FIRST: R*8 - COEFFICIENT OF THE HIGHEST RADIAL ORDER
C    NTERMS: I*4 - NUMBER OF TERMS IN THE POLYNOMIAL
C    POLY: R*8 - A 1-D ARRAY OF LENGTH NTERMS, CONTAINING THE
C               COEFFICIENTS IN DESCENDING RADIAL ORDER, ALL
C               NORMALIZED BY 'FIRST'
C
C  EXTERNAL REFERENCES: INCLIN
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      CHARACTER * 4 CS (2)
      DIMENSION POLY (NTERMS)
      DATA CS /' COS', ' SIN'/
C
C
C  SEE WHETHER A WHOLE POLYNOMIAL WILL FIT ON ONE LINE
C
      IF (NTERMS .GT. 3) GO TO 300
C
C  IT FITS ON ONE LINE - CHOOSE THE PROPER FORMAT AND EXIT
C
      CALL INCLIN (1)
      IF (NTERMS .GT. 1) GO TO 150
C  (ONE TERM)
      IF (MORD .GT. 0) GO TO 110
      WRITE (8, 8000) IZERK, FIRST
      GO TO 1000
110   IF (MORD .GT. 1) GO TO 120
      WRITE (8, 8030) IZERK, FIRST, CS (ICS)
      GO TO 1000
120   CONTINUE
      WRITE (8, 8060) IZERK, FIRST, NORD, CS (ICS), MORD
      GO TO 1000
150   IF (NTERMS .GT. 2) GO TO 200
C  (TWO TERMS)
      IF (MORD .GT. 0) GO TO 160
      WRITE (8, 8010) IZERK, FIRST, POLY (2)
      GO TO 1000
160   IF (MORD .GT. 1) GO TO 170
      WRITE (8, 8040) IZERK, FIRST, POLY (2), CS (ICS)
      GO TO 1000
170   MORD2 = MORD + 2
      WRITE (8, 8070) IZERK, FIRST, MORD2, POLY (2), MORD,
     &                CS (ICS), MORD
      GO TO 1000
C  (THREE TERMS)
200   IF (MORD .GT. 0) GO TO 210
      WRITE (8, 8020) IZERK, FIRST, POLY (2), POLY (3)
      GO TO 1000
210   IF (MORD .GT. 1) GO TO 220
      WRITE (8, 8050) IZERK, FIRST, POLY (2), POLY (3), CS (ICS)
      GO TO 1000
220   MORD4 = MORD + 4
      MORD2 = MORD + 2
      WRITE (8, 8080) IZERK, FIRST, MORD4, POLY (2), MORD2, POLY (3),
     *                MORD, CS (ICS), MORD
      GO TO 1000
C
C  IT WILL NOT FIT ON ONE LINE - BEGIN BY WRITING THE FIRST LINE
C
300   NLINES = (NTERMS + 2) / 3
      CALL INCLIN (NLINES)
      NA = NORD
      NB = NA - 2
      NC = NA - 4
      WRITE (8, 8090) IZERK, FIRST, NA, POLY (2), NB, POLY (3), NC
C
C  NEXT, INSERT AS MANY INTERMEDIATE LINES AS NECESSARY
C
      NINTER = (NTERMS - 4) / 3
      IF (NINTER .EQ. 0) GO TO 350
      DO 340 INTER = 1, NINTER
      INTER3 = INTER * 3
      NA = NORD - 6 * INTER
      NB = NA - 2
      NC = NA - 4
      WRITE (8, 8190) POLY (INTER3 + 1), NA, POLY (INTER3 + 2), NB,
     &                POLY (INTER3 + 3), NC
340   CONTINUE
C
C  NOW WRITE THE LAST LINE
C
350   NLAST = NTERMS - 3 * (NINTER + 1)
      IF (NLAST .GT. 1) GO TO 400
C  (ONE TERM)
      IF (MORD .GT. 0) GO TO 360
      WRITE (8, 8100) POLY (NTERMS)
      GO TO 1000
360   IF (MORD .GT. 1) GO TO 370
      WRITE (8, 8130) POLY (NTERMS), CS (ICS)
      GO TO 1000
370   CONTINUE
      WRITE (8, 8160) POLY (NTERMS), MORD, CS (ICS), MORD
      GO TO 1000
400   CONTINUE
      IF (NLAST .GT. 2) GO TO 450
C  (TWO TERMS)
      IF (MORD .GT. 0) GO TO 410
      WRITE (8, 8110) POLY (NTERMS - 1), POLY (NTERMS)
      GO TO 1000
410   CONTINUE
      IF (MORD .GT. 1) GO TO 420
      WRITE (8, 8140) POLY (NTERMS - 1), POLY (NTERMS), CS (ICS)
      GO TO 1000
420   MORD2 = MORD + 2
      WRITE (8, 8170) POLY (NTERMS - 1), MORD2, POLY (NTERMS), MORD,
     *                CS (ICS), MORD
      GO TO 1000
C  (THREE TERMS)
450   IF (MORD .GT. 0) GO TO 460
      WRITE (8, 8120) POLY (NTERMS - 2), POLY (NTERMS - 1),
     *                POLY (NTERMS)
      GO TO 1000
460   IF (MORD .GT. 1) GO TO 470
      WRITE (8, 8150) POLY (NTERMS - 2), POLY (NTERMS - 1),
     *                POLY (NTERMS), CS (ICS)
      GO TO 1000
470   MORD4 = MORD + 4
      MORD2 = MORD + 2
      WRITE (8, 8180) POLY (NTERMS - 2), MORD4, POLY (NTERMS - 1),
     *                MORD2, POLY (NTERMS), MORD, CS (ICS), MORD
C
1000  RETURN
C
C
C  FORMAT STATEMENTS:
C
C  (INCLUDE NORMALIZATION, END WITH R**0)
C
8000  FORMAT (I4, 1P,D16.7)
8010  FORMAT (I4, 1P,D16.7, '  (R^( 2) +', 0P,F10.6, ')')
8020  FORMAT (I4, 1P,D16.7, '  (R^( 4) +', 0P,F10.6,
     *                        ' R^( 2) +', 0P,F10.6, ')')
C
C  (INCLUDE NORMALIZATION, END WITH R**1)
C
8030  FORMAT (I4, 1P,D16.7, '  R', A4, '(O)')
8040  FORMAT (I4, 1P,D16.7, '  (R^( 3) +', 0P,F10.6, ' R)', A4, '(O)')
8050  FORMAT (I4, 1P,D16.7, '  (R^( 5) +', 0P,F10.6,
     *                        ' R^( 3) +', 0P,F10.6, ' R)', A4, '(O)')
C
C  (INCLUDE NORMALIZATION, END WITH R**(>1))
C
8060  FORMAT (I4, 1P,D16.7, '  (R^(', I2, '))', A4, '(', I2, ' O)')
8070  FORMAT (I4, 1P,D16.7, '  (R^(', I2, ') +',
     *              0P,F10.6, ' R^(', I2, '))', A4, '(', I2, ' O)')
8080  FORMAT (I4, 1P,D16.7, '  (R^(', I2, ') +',
     *              0P,F10.6, ' R^(', I2, ') +',
     *              0P,F10.6, ' R^(', I2, '))', A4, '(', I2, ' O)')
C
C  (INCLUDE NORMALIZATION, END WITH R**(>1), READY FOR CONTINUATION)
C
8090  FORMAT (I4, 1P,D16.7, '  (R^(', I2, ') +',
     *              0P,F10.6, ' R^(', I2, ') +',
     *              0P,F10.6, ' R^(', I2, ')')
C
C  (EXCLUDE NORMALIZATION, END WITH R**0)
C
8100  FORMAT (48X, ' +', F10.6, ')')
8110  FORMAT (29X, ' +', F10.6, ' R^( 2) +', F10.6, ')')
8120  FORMAT (10X, ' +', F10.6, ' R^( 4) +', F10.6, ' R^( 2) +',
     *                   F10.6, ')')
C
C  (EXCLUDE NORMALIZATION, END WITH R**1)
C
8130  FORMAT (48X, ' +', F10.6, ' R)', A4, '(O)')
8140  FORMAT (29X, ' +', F10.6, ' R^( 3) +', F10.6, ' R)', A4, '(O)')
8150  FORMAT (10X, ' +', F10.6, ' R^( 5) +', F10.6, ' R^( 3) +',
     *                   F10.6, ' R)', A4, '(O)')
C
C  (EXCLUDE NORMALIZATION, END WITH R**(>1))
C
8160  FORMAT (48X, ' +', F10.6, ' R^(', I2, '))', A4, '(', I2, ' O)')
8170  FORMAT (29X, ' +', F10.6, ' R^(', I2, ') +',
     *                   F10.6, ' R^(', I2, '))', A4, '(', I2, ' O)')
8180  FORMAT (10X, ' +', F10.6, ' R^(', I2, ') +',
     *                   F10.6, ' R^(', I2, ') +',
     *                   F10.6, ' R^(', I2, '))', A4, '(', I2, ' O)')
C
C  (INTERMEDIATE LINE - JUST THREE TERMS)
C
8190  FORMAT (10X, ' +', F10.6, ' R^(', I2, ') +',
     *                   F10.6, ' R^(', I2, ') +',
     *                   F10.6, ' R^(', I2, ')')
      END
