!+
!KWIC polgen.f
!
!$Id: polgen.f,v 1.2 2004/03/17 21:23:39 dtn Exp $
!
!Revisions:
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!-
!
!  UPDATED 5/9/88 TO ALLOW FOR ANNULAR ZERNIKE POLYNOMIALS, AND
!  TO ALLOW FOR 325 ZERNIKE'S OR 500 LEGENDRE-FOURIER POLYNOMIALS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE POLGEN (ITYPE, NDFI, NDFJ, CO1, CO2, G)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    POLGEN FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 02/25/82
C    *
C    *    UPDATE:   03/01/82
C    *    TIME:     10:43:08
C    *
C    ******************************************/
C
C  GENERATE POLYNMIAL VALUES AT A GIVEN COORDINATE
C
C  INPUT PARAMETERS :
C    ITYPE : I*4 - 1 MEANS CONVENTIONAL SURFACE, ZERNIKE DEFORMATION
C                  2 MEANS X-RAY SURFACE, LEGENDRE-FOURIER DEFORMATION
C    NDFI  : I*4 - TOTAL NUMBER OF DEFORMATION COEFF'S FOR CONV. SYSTEM
C    NDFI  : I*4 - TOTAL NUMBER OF LEGENDRE TERMS FOR X-RAY SYSTEM
C                  TOTAL NUMBER OF DEFORMATION COEFF'S FOR CONV. SYSTEM
C    NDFJ  : I*4 - AZIMUTHAL INDEX LIMIT (HIGHEST DEGREE OF FOURIER
C                  TERMS) FOR X-RAY SYSTEM
C                  (NOT USED FOR CONVENTIONAL SYSTEM)
C    CO1   : R*4 - X-COORD FOR CONVENTIONAL SYSTEMS, OF
C                  Z-COORD FOR X-RAY SYSTEMS
C    CO2   : R*4 - Y-COORD FOR CONVENTIONAL SYSTEMS, OR
C                  THETA-COORD FOR X-RAY SYSTEMS
C
C  INPUT VIA LABELED COMMON /DEFORM/ :
C    NDF  : I*4 - NUMBER OF POLYNOMIALS
C    OBSC : R*8 - LINEAR OBSCURATION RATIO
C
C  OUTPUT PARAMETER :
C    G : R*4 - ARRAY (NDF) OF POLYNOMIAL VALUES AT (CO1, CO2)
C
C  XR : ANNULR, INCLIN, LEGEND, ZERNIK
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs

      DIMENSION G (500), GDUM (500)
      DOUBLE PRECISION COST, SINT, CJ, SJ, H, C (500), S (500)
C
C
      IF (ITYPE .EQ. 2) GO TO 500
C
C  GENERATE ZERNIKE POLYNOMIALS
!  (OR ANNULAR ZERNIKE'S, IF OBSCURATION .GT. 0)
      IF (OBSC .EQ. 0.D0)
     *   CALL ZERNIK (NDF, CO1, CO2, G, GDUM, GDUM, IER)
      IF (OBSC .GT. 0.D0)
     *   CALL ANNULR (NDF, OBSC, NNDX, NDXARR, COFMAT,
     *                CO1, CO2, G, GDUM, GDUM, IER)
      IF (IER .NE. 0) GO TO 2000
      GO TO 900
C
C  GENERATE LEGENDRE POLYNOMIALS
500   CALL LEGEND (NDFI, CO1, G, GDUM, IER)
      IF (IER .NE. 0) GO TO 2010
C
C  ADD IN FOURIER TERMS IF NECESSARY
      IF (NDFJ .EQ. 0) GO TO 900
      COST = DCOS (DBLE (CO2))
      SINT = DSIN (DBLE (CO2))
      CJ = COST
      SJ = SINT
      DO 600 J = 1, NDFJ
      C (J) = CJ
      S (J) = SJ
      H = CJ
      CJ = H * COST - SJ * SINT
      SJ = H * SINT + SJ * COST
600   CONTINUE
      NDX1 = NDFI
      NDX2 = NDFI * (1 + NDFJ)
      DO 700 J = 1, NDFJ
      DO 650 I = 1, NDFI
      NDX1 = NDX1 + 1
      NDX2 = NDX2 + 1
      G (NDX1) = G (I) * C (J)
      G (NDX2) = G (I) * S (J)
650   CONTINUE
700   CONTINUE
900   RETURN
C
2000  continue
      CALL INCLIN (1)
      WRITE (8, 8000) IER
      STOP 8
2010  continue
      CALL INCLIN (1)
      WRITE (8, 8010) IER
      STOP 8
C
8000  FORMAT ('  POLGEN - FATAL ERROR -',
     *        ' ERROR CODE (ZERNIK OR ANNULR) =', I4)
8010  FORMAT ('  POLGEN - FATAL ERROR - LEGEND ERROR CODE =', I4)
      END
