      SUBROUTINE POWDOT (SER1, NARR1, N1, SER2, NARR2, N2, OBSC, DOT)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    POWDOT FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 4/1/88
C    *
C   /******************************************/
C
C  PURPOSE: FORM THE DOT PRODUCT OF TWO POWER SERIES
C
C  INPUT PARAMETERS:
C    SER1 (N1): R*8 - FIRST SERIES OF COEFFICIENTS
C    NARR1 (N1): I*4 - FIRST SERIES OF EXPONENTS (I.E., F1 =
C                      SUM(I=1 TO N1) OF SER1(I)*R**NARR1(I))
C    N1: I*4 - NUMBER OF TERMS IN THE FIRST SERIES
C    SER2 (N2): R*8 - FIRST SERIES OF COEFFICIENTS
C    NARR2 (N2): I*4 - FIRST SERIES OF EXPONENTS (I.E., F2 =
C                      SUM(I=1 TO N2) OF SER2(I)*R**NARR2(I))
C    N2: I*4 - NUMBER OF TERMS IN THE FIRST SERIES
C    OBSC: R*8 - LOWER LIMIT OF INTEGRATION
C
C  OUTPUT PARAMETER:
C    DOT: R*8 - DOT PRODUCT, DEFINED AS INTEGRAL, FROM OBSC
C               TO 1, OF (F1(R) * F2(R) * R * DR)
C
C  EXTERNAL REFERENCES: NONE
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION SER1 (N1), NARR1 (N1), SER2 (N2), NARR2 (N2)
C
C
C  SUM OVER THE ELEMENTS IN EACH POWER SERIES
C
      DOT = 0.D0
      DO 190 I1 = 1, N1
      DOTI2 = 0.D0
      DO 180 I2 = 1, N2
C
C  ADD IN THE PROPER TERM TO THE INTEGRAL
C
      NTOTP1 = 2 + NARR1 (I1) + NARR2 (I2)
      DOTI2 = DOTI2 + ((1.D0 - OBSC ** NTOTP1) / NTOTP1) * SER2 (I2)
180   CONTINUE
      DOT = DOT + DOTI2 * SER1 (I1)
190   CONTINUE
      RETURN
      END
