!+
!KWIC prgi.f
!
!$Id: prgi.f,v 1.2 2004/03/17 21:23:39 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-27[T. Gaetz]
!      . change dimension of LSW to (10, 21) for consistency w/ other routines
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        ! UPDATED 5/17/89 TO PRINT TOROIDAL SURFACE INFO
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-
!
!  UPDATED 1/22/88 TO PRINT OBSCURATION-TYPE SURFACE INFO
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 2/4/88 TO PRINT POLARIZATION INFO
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO PRINT POINT SOURCE DISTANCE INFO
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE PRGI
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    PRGI FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   01/07/82
C    *    TIME:     12:48:30
C    *
C    ******************************************/
C
C PURPOSE:
C     TO PRINT OUT THE INFORMATION READ INTO MEMORY FROM THE 'GI' FILE
C
C  INPUT VIA LABELED COMMON /IDENT/:
C    GID (1 TO 16) : 64 CHARACTER GEOMETRY IDENTIFICATION RECORD
C    GDATE         : CHAR*8 - 8 CHARACTER GEOMETRY DATE
C    GTIME         : R*8 - 8 CHARACTER GEOMETRY TIME
C
C INPUT VIA LABELED COMMON /PARM/:
C    GEN ( 1) : XAP = X OF CENTER OF ANNULAR APERTURE
C    GEN ( 2) : YAP = Y OF CENTER OF ANNULAR APERTURE
C    GEN ( 3) : ZOFF - Z OFFSET OF FOCAL PLANE
C    GEN ( 4) : NS - TOTAL NUMBER OF SURFACES (EXCLUDE FOCAL PLANE)
C    GEN ( 5) : PSI - POLARIZATION MAJOR AXIS ANGLE (WAS EP1)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 6) : E - RATIO OF MINOR TO MAJOR AXIS AMPLITUDE (WAS EP2)
C               (ABS VALUE BETWEEN 0 AND 1)
C               (POSITIVE FOR LEFT HANDED, NEGATIVE FOR RIGHT HANDED)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 7) : AZBU - AZIMUTH ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 8) : ELBU - ELEVATION ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 9) : R1 - INNER RADIUS OF APERTURE ANNULUS
C    GEN (10) : R2 - OUTER RADIUS OF APERTURE ANNULUS
C    GEN (11) : MING - NUMBER OF RINGS
C    GEN (12) : M2 - NUMBER OF POINTS IN OUTERMOST RING
C    GEN (13) : PTSRC - DISTANCE FROM PT SOURCE TO PUPIL CENTER
C    GEN (14 - 20)  ARE NOT USED
C
C    IF J = SURFACE NUMBER THEN,
C    SURF (1, J) : X - X COORD. AT SURFACE CENTER
C    SURF (2, J) : Y - Y COORD. AT SURFACE CENTER
C    SURF (3, J) : Z - Z COORD. AT SURFACE CENTER
C    SURF (4, J) : P - CONIC CONSTANT = 1 - ECCEN. ** 2
C    SURF (5, J) : VERTEX RADIUS OF CURV. OR K FACTOR OF XRAY SURFACE
C    SURF (6, J) : P0 - CENTER RADIUS  (USUALLY 0 FOR CONVEN), OR
C                  RTOR - TOROIDAL RADIUS
C    SURF (7, J) : AZMIS - AZIMUTH MISALIGNMENT OF SURFACE (DEG.)
C    SURF (8, J) : ELMIS - ELEVATION MISALIGNMENT OF SURFACE (DEG.)
C    SURF (9, J) : INNER RADIUS OF CONVENTIONAL SURFACE OR
C                  EPICENTER OF OFFSET SURFACE OR
C                  INNER RADIUS OR X-WIDTH OF OBSCURATION
C    SURF (10,J) : OUTER RADIUS OF CONV. OR LENGTH OF X-RAY SURFACE OR
C                  OUTER RADIUS OR Y-WIDTH OF OBSCURATION
C    SURF (11,J) : BORESIGHT ANGLE OF OFFSET SURFACE OR
C                  AZF - AZIMUTH OF NORMAL TO FOLD PLANE OF FLAT SURFACE
!                  ZROT8 - ANGLE ABOUT Z FOR TOROIDAL SURFACE
C    SURF (12,J) : ELF - ELEVATION NORMAL TO FOLD PLANE OF FLAT SURFACE
C    SURF (13,J) : ZFOLD - Z COORD. OF INTERSECTION OF STD Z AXIS
C                  WITH FOLD PLANE OF FLAT SURFACE, OR
C                  ZROT8 - ROTATION ABOUT Z OF A RECTANGULAR OBSCURATION
C    SURF (14,J) : EP1 - REAL PART OF DIELECTRIC CONSTANT
C    SURF (15,J) : EP2 - IMAGINARY PART OF DIELECTRIC CONSTANT
C    SURF (16 - 20,J) : NOT USED
C
C  INPUT VIA LABELED COMMON /PARX/:
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C    NDIM : I*4 - NUMBER OF SURFACES ALLOWED FOR
C    NS   : I*4 - ACTUAL NUMBER OF SURFACES
C    KURF : I*4 - SURFACE NUMBER
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C    RZER : R*4 - INITIAL NON-ZERO RADIUS OF ANNULAR APERTURE
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C    H2   : R*4 - NOT NEEDED, DUMMIED TO -1. IN NEW VERSION
C
C INPUT VIA LABELED COMMON /SWITCH/:
C    LSW0 (1 TO 10) : GENERAL SYSTEM SWITCHES
C    LSW (1 TO 10, J) : SWITCHES FOR SURFACE J
C
C OUTPUT OF SUBROUTINE:
C     PRINTED REPORT OF SYSTEM GEOMETRY ON UNIT 8.
C
C  EXTERNAL REFERENCES: INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

C  WRITE THE GENERAL SYSTEM INFORMATION
      IF (LSW0 (4)) GO TO 3
C  (RANDOM POLARIZATION)
      WRITE (8, 130) GID, GDATE, GTIME (1), LSW0
      CALL INCLIN (16)
      WRITE (8, 1001) (GEN(I), I = 1, 3), NS,
     1 (GEN(I), I = 7, 10), MING, M2, GEN (13), LSW0
      GO TO 4
C  (DISCRETE POLARIZATION)
3     WRITE (8, 130) GID, GDATE, GTIME (1), LSW0
      CALL INCLIN (18)
      WRITE (8, 100) (GEN(I), I = 1, 3), NS,
     1 (GEN(I), I = 5, 10), MING, M2, GEN (13), LSW0
C
C  WRITE THE SURFACE INFORMATION FOR EACH SURFACE
4     DO 20 J = 1, NS
!
!  IS THE SURFACE AN OBSCURATION?
      IF (LSW (5, J) .OR. LSW (6, J)) GO TO 18
!
!  IS THE SURFACE A TOROID?
      IF (LSW (8, J)) GO TO 19
C
!C  IS SYSTEM XRAY OR CONVENTIONAL?
!     IF (LSW0 (1)) GO TO 10
C  IS SURFACE XRAY OR CONVENTIONAL?
      IF (LSW (9, J)) GO TO 10
C
C  IS THE SURFACE FLAT?
      IF (LSW (3, J)) GO TO 15
C
C  IS THE SURFACE OFF-AXIS?
      IF (LSW (4, J)) GO TO 5
C
C  WRITE CONVENTIONAL GEOMETRY REPORT FOR ON-AXIS SURFACE #J
      CALL INCLIN (15)
      WRITE (8, 110) J, (SURF(I, J), I = 1, 10),
     *      (SURF(I, J), I = 14, 15), (LSW (I, J), I = 1, 10)
      GO TO 20
C
C  WRITE CONVENTIONAL GEOMETRY REPORT FOR OFF-AXIS SURFACE #J
5     CALL INCLIN (16)
      WRITE (8, 115) J, (SURF (I,J), I = 1, 11),
     *      (SURF(I, J), I = 14, 15), (LSW (I,J), I = 1, 10)
      GO TO 20
C
C WRITE XRAY GEOMETRY REPORT FOR SURFACE #J
10    CALL INCLIN (14)
      WRITE (8, 120) J, (SURF (I, J), I = 1, 8), SURF (10, J),
     *      (SURF(I, J), I = 14, 15), (LSW (I, J), I = 1, 10)
      GO TO 20
C
C  WRITE GEOMETRY REPORT FOR FLAT SURFACE #J
15    CALL INCLIN (14)
      WRITE (8, 125) J, (SURF (I, J), I = 1, 3), (SURF (I,J), I = 7, 8),
     1 (SURF (I, J), I = 10, 15), (LSW (I, J), I = 1, 10)
      GO TO 20
!
!  WRITE GEOMETRY REPORT FOR OBSCURATION-TYPE SURFACE #J
18    CALL INCLIN (11)
      WRITE (8, 128) J, (SURF (I, J), I = 1, 3),
     1 (SURF (I, J), I = 7, 10), SURF (13, J), (LSW (I, J), I = 1, 10)
!
!  WRITE GEOMETRY REPORT FOR TOROIDAL SURFACE #J
19    CALL INCLIN (16)
      WRITE (8, 129) J, (SURF(I, J), I = 1, 11),
     *      (SURF(I, J), I = 14, 15), (LSW (I, J), I = 1, 10)
C
20    CONTINUE
C
      RETURN
C
100   FORMAT (/ 1X, 'INPUT SYSTEM GEOMETRY :' /
     *1X, 16(1H-),/,
     *2X, 20HGENERAL INFORMATION:,/,
     *3X, 7HXAP   =,1P,D22.14, 2X,31HX OF CENTER OF ANNULAR APERTURE,/,
     *3X, 7HYAP   =, D22.14, 2X,31HY OF CENTER OF ANNULAR APERTURE,/,
     *3X, 7HZOFF  =, D22.14, 2X,24HZ OFFSET OF FOCAL PLANE.,/,
     *3X, 7HNS    =, I22, 2X,19HNUMBER OF SURFACES.,/,
     *3X, 7HPSI   =, D22.14, 2X,29HPOLARIZATION MAJOR AXIS ANGLE,/,
     *3X, 7HE     =, D22.14, 2X,28HRATIO OF MINOR TO MAJOR AXIS,/,
     *3X, 7HAZBU  =, D22.14, 2X, 'AZIMUTH   OF INCOMING BUNDLE (DEG.)'
     *     ,/,
     *3X, 7HELBU  =, D22.14, 2X, 'ELEVATION OF INCOMING BUNDLE (DEG.)'
     *    ,/,
     *3X, 7HR1    =, D22.14, 2X,33HINNER RADIUS OF APERTURE ANNULUS.,/
     *,3X, 7HR2    =, D22.14, 2X,33HOUTER RADIUS OF APERTURE ANNULUS.,
     */,3X, 7HMING  =, I22, 2X,16HNUMBER OF RINGS.,/,
     *3X, 7HM2    =, I22, 2X,23HNO. OF POINTS PER RING.,/,
     *3X, 7HPTSRC =, D22.14, 2X, 'DISTANCE TO POINT SOURCE', /,
     *3X, 7HLSW0  =,12X,10L1, 2X,16HSYSTEM SWITCHES.
     *  )
1001  FORMAT (/ 1X, 'INPUT SYSTEM GEOMETRY :' /
     *1X, 16(1H-),/,
     *2X, 20HGENERAL INFORMATION:,/,
     *3X, 7HXAP   =,1P,D22.14, 2X,31HX OF CENTER OF ANNULAR APERTURE,/,
     *3X, 7HYAP   =, D22.14, 2X,31HY OF CENTER OF ANNULAR APERTURE,/,
     *3X, 7HZOFF  =, D22.14, 2X,24HZ OFFSET OF FOCAL PLANE.,/,
     *3X, 7HNS    =, I22, 2X,19HNUMBER OF SURFACES.,/,
     *3X, 7HAZBU  =, D22.14, 2X, 'AZIMUTH   OF INCOMING BUNDLE (DEG.)'
     *     ,/,
     *3X, 7HELBU  =, D22.14, 2X, 'ELEVATION OF INCOMING BUNDLE (DEG.)'
     *    ,/,
     *3X, 7HR1    =, D22.14, 2X,33HINNER RADIUS OF APERTURE ANNULUS.,/
     *,3X, 7HR2    =, D22.14, 2X,33HOUTER RADIUS OF APERTURE ANNULUS.,
     */,3X, 7HMING  =, I22, 2X,16HNUMBER OF RINGS.,/,
     *3X, 7HM2    =, I22, 2X,23HNO. OF POINTS PER RING.,/,
     *3X, 7HPTSRC =, D22.14, 2X, 'DISTANCE TO POINT SOURCE', /,
     *3X, 7HLSW0  =,12X,10L1, 2X,16HSYSTEM SWITCHES.
     *  )
110   FORMAT(/ 2X,14HSURFACE NUMBER, I4,/,
     *3X, 7HX0    =, 1P,D22.14, 2X,19HX COORD. AT CENTER.,/,
     *3X, 7HY0    =, D22.14, 2X,19HY COORD. AT CENTER.,/,
     *3X, 7HZ0    =, D22.14, 2X,19HZ COORD. AT CENTER.,/,
     *3X, 7HP     =, D22.14, 2X, 'CONIC CONSTANT = 1 - ECCEN. ** 2',/,
     *3X, 7HK     =, D22.14, 2X,27HVERTEX RADIUS OF CURVATURE.,/,
     *3X, 7HP0    =, D22.14, 2X,25HCENTER RADIUS OF SURFACE.,/,
     *3X, 7HAZMIS =, D22.14, 2X, 'AZIMUTH   MISALIGNMENT (DEG.)'
     *   ,/,
     *3X, 7HELMIS =, D22.14, 2X, 'ELEVATION MISALIGNMENT (DEG.)'
     *      ,/,
     *3X, 7HR1S   =, D22.14, 2X,30HINNER RADIUS OF CONV. SURFACE.,/,
     *3X, 7HR2S   =, D22.14, 2X,30HOUTER RADIUS OF CONV. SURFACE.,/,
     *3X, 7HEP1   =, D22.14, 2X,31HREAL  PART OF DIELECTRIC CONST.,/,
     *3X, 7HEP2   =, D22.14, 2X,31HIMAG. PART OF DIELECTRIC CONST.,/,
     *3X, 7HLSW   =,12X,10L1, 2X,17HSURFACE SWITCHES.
     *   )
115   FORMAT(/ 2X,14HSURFACE NUMBER, I4,/,
     *3X, 7HX0    =, 1P,D22.14, 2X,19HX COORD. AT CENTER.,/,
     *3X, 7HY0    =, D22.14, 2X,19HY COORD. AT CENTER.,/,
     *3X, 7HZ0    =, D22.14, 2X,19HZ COORD. AT CENTER.,/,
     *3X, 7HP     =, D22.14, 2X, 'CONIC CONSTANT = 1 - ECCEN. ** 2',/,
     *3X, 7HK     =, D22.14, 2X,27HVERTEX RADIUS OF CURVATURE.,/,
     *3X, 7HP0    =, D22.14, 2X,25HCENTER RADIUS OF SURFACE.,/,
     *3X, 7HAZMIS =, D22.14, 2X, 'AZIMUTH   MISALIGNMENT (DEG.)'
     *   ,/,
     *3X, 7HELMIS =, D22.14, 2X, 'ELEVATION MISALIGNMENT (DEG.)'
     *      ,/,
     *3X, 7HYE    =, D22.14, 2X, 'EPICENTER OF OFFSET' /
     *3X, 7HR2S   =, D22.14, 2X,30HOUTER RADIUS OF CONV. SURFACE.,/,
     *3X, 7HB     =, D22.14, 2X, 'BORESIGHT ANGLE (DEG.)' /
     *3X, 7HEP1   =, D22.14, 2X,31HREAL  PART OF DIELECTRIC CONST.,/,
     *3X, 7HEP2   =, D22.14, 2X,31HIMAG. PART OF DIELECTRIC CONST.,/,
     *3X, 7HLSW   =,12X,10L1, 2X,17HSURFACE SWITCHES.
     *   )
120   FORMAT(/ 2X,14HSURFACE NUMBER, I4,/,
     *3X, 7HX0    =, 1P,D22.14, 2X,19HX COORD. AT CENTER.,/,
     *3X, 7HY0    =, D22.14, 2X,19HY COORD. AT CENTER.,/,
     *3X, 7HZ0    =, D22.14, 2X,19HZ COORD. AT CENTER.,/,
     *3X, 7HP     =, D22.14, 2X, 'CONIC CONSTANT = 1 - ECCEN. ** 2',/,
     *3X, 7HK     =, D22.14, 2X,18HFACTOR OF SURFACE.,/,
     *3X, 7HP0    =, D22.14, 2X,25HCENTER RADIUS OF SURFACE.,/,
     *3X, 7HAZMIS =, D22.14, 2X, 'AZIMUTH   MISALIGNMENT (DEG.)'
     *   ,/,
     *3X, 7HELMIS =, D22.14, 2X, 'ELEVATION MISALIGNMENT (DEG.)'
     *      ,/,
     *3X, 7HL     =, D22.14, 2X,18HLENGTH OF SURFACE.,/,
     *3X, 7HEP1   =, D22.14, 2X,31HREAL  PART OF DIELECTRIC CONST.,/,
     *3X, 7HEP2   =, D22.14, 2X,31HIMAG. PART OF DIELECTRIC CONST.,/,
     *3X, 7HLSW   =,12X,10L1,2X,17HSURFACE SWITCHES.
     *   )
125   FORMAT(/ 2X,14HSURFACE NUMBER, I4,/,
     *3X, 7HX0    =, 1P,D22.14, 2X,19HX COORD. AT CENTER.,/,
     *3X, 7HY0    =, D22.14, 2X,19HY COORD. AT CENTER.,/,
     *3X, 7HZ0    =, D22.14, 2X,19HZ COORD. AT CENTER.,/,
     *3X, 7HAZMIS =, D22.14, 2X, 'AZIMUTH   MISALIGNMENT (DEG.)'
     *   ,/,
     *3X, 7HELMIS =, D22.14, 2X, 'ELEVATION MISALIGNMENT (DEG.)'
     *      ,/,
     *3X, 7HR2S   =, D22.14, 2X, 'RADIUS OF MIRROR' /
     *3X, 7HAZF   =, D22.14, 2X, 'AZIMUTH ANGLE OF NORMAL (DEG.)' /
     *3X, 7HELF   =, D22.14, 2X, 'ELEVATION ANGLE OF NORMAL (DEG.)' /
     *3X, 7HZFOLD = , D22.14, 2X, 'Z COORD. OF FOLD PLANE' /
     *3X, 7HEP1   =, D22.14, 2X,31HREAL  PART OF DIELECTRIC CONST.,/,
     *3X, 7HEP2   =, D22.14, 2X,31HIMAG. PART OF DIELECTRIC CONST.,/,
     *3X, 7HLSW   =,12X,10L1,2X,17HSURFACE SWITCHES.
     *   )
128   FORMAT(/ 2X,14HSURFACE NUMBER, I4,/,
     *3X, 7HX0    =, 1P,D22.14, 2X,19HX COORD. AT CENTER.,/,
     *3X, 7HY0    =, D22.14, 2X,19HY COORD. AT CENTER.,/,
     *3X, 7HZ0    =, D22.14, 2X,19HZ COORD. AT CENTER.,/,
     *3X, 7HAZNOR =, D22.14, 2X, 'AZIMUTH ANGLE OF NORMAL (DEG.)',/,
     *3X, 7HELNOR =, D22.14, 2X, 'ELEVATION ANGLE OF NORMAL (DEG.)',/,
     *3X, 7HDIM1  =, D22.14, 2X, 'INNER RADIUS OR X-WIDTH OF OBSC' /
     *3X, 7HDIM2  =, D22.14, 2X, 'OUTER RADIUS OR Y-WIDTH OF OBSC' /
     *3X, 7HZROT8 =, D22.14, 2X, 'ANGLE ABOUT Z FOR RECT OBSC (DEG.)' /
     *3X, 7HLSW   =,12X,10L1,2X,17HSURFACE SWITCHES.
     *   )
129   FORMAT(/ 2X,14HSURFACE NUMBER, I4,/,
     *3X, 7HX0    =, 1P,D22.14, 2X,19HX COORD. AT CENTER.,/,
     *3X, 7HY0    =, D22.14, 2X,19HY COORD. AT CENTER.,/,
     *3X, 7HZ0    =, D22.14, 2X,19HZ COORD. AT CENTER.,/,
     *3X, 7HP     =, D22.14, 2X, 'CONIC CONSTANT = 1 - ECCEN. ** 2',/,
     *3X, 7HK     =, D22.14, 2X,27HVERTEX RADIUS OF CURVATURE.,/,
     *3X, 7HRTOR  =, D22.14, 2X,27HTOROIDAL RADIUS OF SURFACE.,/,
     *3X, 7HAZMIS =, D22.14, 2X, 'AZIMUTH   MISALIGNMENT (DEG.)'
     *   ,/,
     *3X, 7HELMIS =, D22.14, 2X, 'ELEVATION MISALIGNMENT (DEG.)'
     *      ,/,
     *3X, 7HR1S   =, D22.14, 2X,30HINNER RADIUS OF TOROIDAL SURF.,/,
     *3X, 7HR2S   =, D22.14, 2X,30HOUTER RADIUS OF TOROIDAL SURF.,/,
     *3X, 7HZROT8 =, D22.14, 2X,28HROTATION ABOUT Z AXIS (DEG.),/,
     *3X, 7HEP1   =, D22.14, 2X,31HREAL  PART OF DIELECTRIC CONST.,/,
     *3X, 7HEP2   =, D22.14, 2X,31HIMAG. PART OF DIELECTRIC CONST.,/,
     *3X, 7HLSW   =,12X,10L1, 2X,17HSURFACE SWITCHES.
     *   )
130   FORMAT (1X, 16A4, A8, 1X, A8, /
     1 1X, 'LSW0  =', 12X, 10L1, 2X, 'GENERAL SYSTEM SWITCHES.')
      END
