!+
!KWIC prhdr.f
!
!$Id: prhdr.f,v 1.3 2004/03/22 15:35:44 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add idum(16) to make length consistent with that
!        in ../include/ident.h
!   95-Jan-20[T. Gaetz]
!      . change version header info; see format 100
!   93-Nov-05[T. Gaetz]
!      . redefine /QPRELQ/ using character variables; move to qprelq.h
!      . change io format to use quoted strings instead of hollerith.
!-

      SUBROUTINE PRHDR
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    PRHDR FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   06/19/80
C    *    TIME:     10:58:52
C    *
C    ******************************************/
C
C  W#8 AT TOP OF FORM THE PROGRAM NAME AND RELEASE NUMBER
C  AND THE PROBLEM IDENTIFIER LINES
C
C  INPUT VIA LABELED COMMON /IDENT/:
C    ID (22, 2) : I*4 - PROBLEM IDENTIFIER
C
C  INPUT VIA LABELED COMMON /QPRELQ/:
C    QPNAME : R*8 - 8 CHARACTER PROGRAM NAME
C    QPREL  : R*4 - 4 CHARACTER RELEASE NUMBER
C    NT     : I*4 - NUMBER OF LINES IN PROBLEM IDENTIFIER
C
C  OUTPUT VIA #6:
C    PROBLEM IDENTIFIER LINE
C
C  OUTPUT VIA #8:
C    PROGRAM NAME AND RELEASE NUMBER
C    PROBLEM IDENTIFIER LINES
C
C  OUTPUT VIA LABELED COMMON /QPRELQ/:
C    LQ : I*4 - CURRENT LINE NUMBER ON PRINTER PAGE
C
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/ident.h'
      include 'saosacLib/qprelq.h'
C
      NPAGE = NPAGE + 1
C  WRITE PROGRAM NAME AND RELEASE NUMBER
      WRITE (8, 100) QPNAME, QPREL, NPAGE
      LQ = 2
C
C  WRITE PROBLEM IDENTIFIER LINES ON #8
      IF ( NT .GT. 1 ) THEN
         WRITE( 8, 600 ) RID, RDATE, RTIME (1)
      ENDIF

      IF ( NT .GT. 0 ) THEN
         WRITE( 8, 600 ) GID, GDATE, GTIME (1)
      ENDIF

      LQ = LQ + NT
C
      WRITE (8, 110)
      LQ = LQ + 1
      RETURN
C
100   FORMAT('1','*** SAO OSAC (', A8,
     1 ') RELEASE (', A4, ') pipelined UNIX version', T74, 'PAGE', I4)
110   FORMAT (1X, 80(1H-))
600   FORMAT (1X, 15A4, A1, 1X, A8, 1X, A8)
      END
