!+
!KWIC progid.f
!
!$Id: progid.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   93-Nov-05[T. Gaetz]
!      . redefine /QPRELQ/ using character variables; move to qprelq.h
!      . add IMPLICIT NONE
!-

      SUBROUTINE PROGID (PN, PR, LINT)  !*** SLASHES TAKEN OUT
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    PROGID FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   07/01/80
C    *    TIME:     10:33:45
C    *
C    ******************************************/
C
C  PURPOSE:
C    TO STORE THE NAME OF MAINLINE OPTICAL SURFACE ANALYSIS PROGRAM
C    CURRENTLY IN EXECUTION, AND ITS RELEASE NUMBER.  REPORT PRINTING
C    SUBROUTINES CAN SUBSEQUENTLY PRINT OUT THIS INFORMATION IN THE TOP
C    OF PAGE HEADER BLOCK.
C
C  INPUT ARGUMENTS:
C    PN   : R*8 - 8 CHARACTERS CONTAINING PROGRAM NAME.
C    PR   : R*4 - 4 CHARACTERS CONTAINING PROGRAM RELEASE DESIGNATION
C    LINT : I*4 - NUMBER OF LINES IN PROBLEM IDENTIFIER
C
C  OUTPUT VIA LABELED COMMON /QPRELQ/:
C    QPNAME : R*8 - SET EQUAL TO PN.
C    QPREL  : R*4 - SET EQUAL TO PR.
C    LQ     : I*4 - LINE NO. ON CURRENT PRINTER PAGE (SET TO NQ).
C    NQ     : I*4 - TOTAL NUM OF LINES PER PRINTER PAGE ALLOWED
C                   (SET TO 60)
C    NT     : I*4 - NUMBER OF LINES IN PROBLEM IDENTIFIER
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE

      CHARACTER*(8) PN
      CHARACTER*(4) PR
      INTEGER       LINT

      include 'saosacLib/qprelq.h'

      QPNAME = PN
      QPREL = PR
      NQ = 60
      LQ = NQ
      NT = LINT
      RETURN
      END
