!+
!KWIC pzprpl.f
!
!$Id: pzprpl.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

      SUBROUTINE PZPRPL (IVS1, IVS2, IVN, IVPRP, IVPRL1, IVPRL2)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    PZPRPL FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 2/7/88
C    *
C   /******************************************/
C
C  PURPOSE: CALCULATE THE "PERPENDICULAR" AND "PARALLEL" DIRECTION
C           UNIT VECTORS FOR DEFINING POLARIZATION COMPONENTS, GIVEN
C           THE INCOMING AND OUTGOING DIRECTION AND NORMAL DIRECTION
C           UNIT VECTOR
C
C  INPUT PARAMETERS:
C    IVS1:   I*4 - IV# OF THE INCOMING PROPAGATION VECTOR
C    IVS2:   I*4 - IV# OF THE OUTGOING PROPAGATION VECTOR
C    IVN:    I*4 - IV# OF THE NORMAL VECTOR
C    IVPRP:  I*4 - DESIRED IV# FOR THE PERPENDICULAR DIRECTION VECTOR
C    IVPRL:  I*4 - DESIRED IV# FOR THE PARALLEL DIRECTION VECTOR
C                  CORRESPONDING TO S1
C    IVPRL:  I*4 - DESIRED IV# FOR THE PARALLEL DIRECTION VECTOR
C                  CORRESPONDING TO S2
C
C  INPUT/OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    IV#'S IVS1, IVS2, IVN, IVPRP, AND IVPRL
C
C  XR: VCROSS, VDOT, VUNIT
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

C
C  BEGIN BY DEFINING THE PERPENDICULAR UNIT VECTOR
C
      IF (DABS (VDOT (IVS2, IVS1)) .GE. 0.99999D0) GO TO 120
C  (USE S2 CROSS S1)
      CALL VCROSS (IVS2, IVS1, IVPRP)
      GO TO 180
120   IF (DABS (VDOT (IVN, IVS1)) .GE. 0.99999D0) GO TO 140
C  (USE N CROSS S1)
      CALL VCROSS (IVN, IVS1, IVPRP)
      GO TO 180
140   IF (DABS (XV (IVN)) .GE. 0.99999D0) GO TO 160
C  (USE N CROSS X)
      XV (IVPRP) = 0.D0
      YV (IVPRP) = ZV (IVN)
      ZV (IVPRP) = - YV (IVN)
      GO TO 180
C  (USE N CROSS Y)
160   XV (IVPRP) = - ZV (IVN)
      YV (IVPRP) = 0.D0
      ZV (IVPRP) = XV (IVN)
C  (WHATEVER WAS USED, GIVE IT UNIT LENGTH)
180   CALL VUNIT (IVPRP, IVPRP, SIZE)
C
C  FINISH BY DEFINING THE PARALLEL UNIT VECTORS
C
      CALL VCROSS (IVS1, IVPRP, IVPRL1)
      CALL VCROSS (IVS2, IVPRP, IVPRL2)
      RETURN
      END
