!+
!KWIC raysum.f
!
!$Id: raysum.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-

      SUBROUTINE RAYSUM
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    RAYSUM FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 06/10/80
C    *
C    *    UPDATE:   02/04/81 (PAUL GLENN)
C    *    TIME:     16:23:48
C    *
C    ******************************************/
C
C  PURPOSE: TO WRITE ON #6 AND #8 THE RAY TRACE SUMMARY REPORT.
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (3) : R*8 - ZOFF - Z OFFSET OF FOCAL PLANE
C
C  INPUT VIA LABELED COMMON /PARX/:
C    GFOC: R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    JRAY : I*4 - CURRENT RAY NUMBER
C
C  INPUT VIA LABELED COMMON /SUMRY/:
C    WF1   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT SURFACE #1
C    WF2   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT SURFACE #2
C    WS1   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT SURFACE #1
C    WS2   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT SURFACE #2
C    JAIL1 : I*4 - NUMBER OF RAYS FAILING AT SURFACE #1
C    JAIL2 : I*4 - NUMBER OF RAYS FAILING AT SURFACE #2
C    LEFT1 : I*4 - NUMBER OF RAYS LEAVING SURFACE # 1
C    LEFT2 : I*4 - NUMBER OF RAYS LEAVING SURFACE # 2
C    XMIN  : R*4 - MINIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    XMAX  : R*4 - MAXIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    YMIN  : R*4 - MINIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C    YMAX  : R*4 - MAXIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C
C  OUTPUT VIA #6 AND #8: RAY SUMMARY REPORT
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
C
      WEIGHT = JRAY
C
      CALL INCLIN (6)
      WRITE (8, 100)
C
C  WRITE SUMMARY INFORMATION FOR 1ST SURFACE
      KURF = 1
      WRITE (8, 110) KURF, JRAY, WEIGHT, JAIL1, WF1, LEFT1, WS1
C
C  WRITE SUMMARY INFORMATION FOR 2ND SURFACE
      KURF = 2
      WRITE (8, 110) KURF, LEFT1, WS1, JAIL2, WF2, LEFT2, WS2
C
C  WRITE SUMMARY INFORMATION FOR FOCAL PLANE
      CALL INCLIN (10)
      WRITE (8, 120) GFOC, GEN (3), XMIN, YMIN, XMAX, YMAX
      RETURN
C
100   FORMAT (/ 32X, 'RAY SUMMARY REPORT' /
     1 32X, 18(1H-) //
     2 T2, 'SURFACE', T20, 'STARTED', T44, 'FAILED', T65, 'SUCCEEDED' /
     3 T4, 'NUM', T15, 'NUM', T27, 'WEIGHT', T38, 'NUM', T50, 'WEIGHT',
     4 T61, 'NUM', T73, 'WEIGHT' /)
110   FORMAT (1X, I5, 3X, 3(I8, F15.5))
120   FORMAT (// 33X, 'RAY FOCUS REPORT' / 33X, 16(1H-) //
     1 1X, 'FOCAL PLANE INTERSECTIONS FOR GFOC =', 1P,D20.12,
     2        ', ZOFF = ', D15.6, //, 14X, 'MINIMUM', 26X, 'MAXIMUM',
     3        /, 8X, 'X', 16X, 'Y', 15X, 'X', 16X, 'Y', /,
     4        4(E16.8, 1X))
      END
