!+
!KWIC rdgi.f
!
!$Id: rdgi.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-17[T. Gaetz]
!      . elminate ascii io to unit 6; see unit 8 for messages
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO CHANGE DIELECTRIC CONSTANT COMMENTS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO INCLUDE THE UNIT NUMBER AS A CALLING PARAMETER
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE RDGI (LU, IER)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    RDGI FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 04/08/80
C    *
C    *    UPDATE:   11/06/80
C    *    TIME:     10:57:15
C    *
C    ******************************************/
C
C  PURPOSE: TO READ INTO MEMORY THE SYSTEM GEOMETRY FILE 'GI'
C           AND TO CHECK THAT THE DATA ARE WITHIN THE LIMIT
C           VALUES. BLOCK DATA PROGRAM 'OSACBL' INITIALIZES
C           THE DEFAULT VALUES AND SETS THE LIMITS.
C
!  INPUT PARAMETER:
!    LU: I*4 - UNIT NUMBER FOR THE GI FILE
C
C  INPUT:
C    FILE 'GI' : GEOMETRY FILE ON UNIT LU
C
C    VIA LABELED COMMON /LIMIT/:
C    GLIM (1, 1 TO 20) LOWER LIMITS FOR GENERAL SYSTEM VARIABLES
C    GLIM (2, 1 TO 20) UPPER LIMITS FOR GENERAL SYSTEM VARIABLES
C    SLIM (1, 1 TO 20) LOWER LIMITS FOR SURFACE VARIABLES
C    SLIM (2, 1 TO 20) UPPER LIMITS FOR SURFACE VARIABLES
C
C    VIA LABELED COMMON /PARX/:
C    NDIM : NUM OF SURFACES FOR WHICH STORAGE HAS BEEN ALLOCATED
C
C    DEFAULT VALUES FOR THE GEN, SURF, LSW0, AND LSW ARRAYS
C
C  OUTPUT ARGUMENT : IER = ERROR CODE :
C    -4 - EOF WHILE READING FILE
C    -3 - ERROR WHILE READING FILE
C    -2 - ERROR IN ITY VALUE
C    -1 - NS > NDIM
C     0 - NO ERROR
C     N - N INPUT PARAMETERS OUTSIDE PERMISSABLE RANGE
C               WARNING : THESE PARAMETERS ASSUME THEIR DEFAULT VALUES
C
C  OUTPUT VIA LABELED COMMON /PARM/ :
C    GEN ( 1) : XAP = X OF CENTER OF ANNULAR APERTURE
C    GEN ( 2) : YAP = Y OF CENTER OF ANNULAR APERTURE
C    GEN ( 3) : ZOFF - Z OFFSET OF FOCAL PLANE
C    GEN ( 4) : NS - TOTAL NUMBER OF SURFACES (EXCLUDE FOCAL PLANE)
C    GEN ( 5) : PSI - POLARIZATION MAJOR AXIS ANGLE (WAS EP1)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 6) : E - RATIO OF MINOR TO MAJOR AXIS AMPLITUDE (WAS EP2)
C               (ABS VALUE BETWEEN 0 AND 1)
C               (POSITIVE FOR LEFT HANDED, NEGATIVE FOR RIGHT HANDED)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 7) : AZBU - AZIMUTH ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 8) : ELBU - ELEVATION ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 9) : R1 - INNER RADIUS OF APERTURE ANNULUS
C    GEN (10) : R2 - OUTER RADIUS OF APERTURE ANNULUS
C    GEN (11) : MING - NUMBER OF RINGS
C    GEN (12) : M2 - NUMBER OF POINTS IN OUTERMOST RING
C    GEN (13 - 20)  ARE NOT USED
C
C    IF J = SURFACE NUMBER THEN,
C    SURF (1, J) : X - X COORD. AT SURFACE CENTER
C    SURF (2, J) : Y - Y COORD. AT SURFACE CENTER
C    SURF (3, J) : Z - Z COORD. AT SURFACE CENTER
C    SURF (4, J) : P - CONIC CONSTANT = 1 - ECCEN. ** 2
C    SURF (5, J) : VERTEX RADIUS OF CURV. OR K FACTOR OF XRAY SURFACE
C    SURF (6, J) : P0 - CENTER RADIUS  (USUALLY 0 FOR CONVENTIONAL)
C    SURF (7, J) : AZMIS - AZIMUTH MISALIGNMENT OF SURFACE (DEG.)
C    SURF (8, J) : ELMIS - ELEVATION MISALIGNMENT OF SURFACE (DEG.)
C    SURF (9, J) : INNER RADIUS OF CONVENTIONAL SURFACE OR
C                  EPICENTER OF OFFSET SURFACE
C    SURF (10,J) : OUTER RADIUS OF CONV. OR LENGTH OF X-RAY SURFACE
C    SURF (11,J) : BORESIGHT ANGLE OF OFFSET SURFACE OR
C                  AZF - AZIMUTH OF NORMAL TO FOLD PLANE OF FLAT SURFACE
C    SURF (12,J) : ELF - ELEVATION NORMAL TO FOLD PLANE OF FLAT SURFACE
C    SURF (13,J) : ZFOLD - Z COORD. OF INTERSECTION OF STD Z AXIS
C                  WITH FOLD PLANE OF FLAT SURFACE, OR
C                  ZROT8 - ROTATION ABOUT Z OF A RECTANGULAR OBSCURATION
C    SURF (14,J) : EP1 - REAL PART OF DIELECTRIC CONSTANT
C    SURF (15,J) : EP2 - IMAGINARY PART OF DIELECTRIC CONSTANT
C    SURF (16 - 20,J) : NOT USED
C
C    VIA LABELED COMMON /PARX/:
C    NS   : ACTUAL NUMBER OF SURFACES
C
C    VIA LABELED COMMON /SWITCH/:
C    LSW0 (1 TO 10) : GENERAL SYSTEM SWITCHES
C    LSW (1 TO 10, J) : SWITCHES FOR SURFACE J
C
C    VIA LABELED COMMON /IDENT/:
C    GID (1 TO 16) : 64 CHARACTER IDENTIFICATION RECORD
C
C  EXTERNAL REFERENCE : INCLIN
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/rain.h'      !
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      COMMON /LIMIT/ GLIM (2, 20), SLIM (2, 20)

      DOUBLE PRECISION VAL
      LOGICAL * 1 LH
C
C  INIT THE ERROR CODE
      IER = 0
C
C  READ THE ID RECORD
      READ (LU, 500, ERR = 140, END = 150) GID
C
C  GET THE NEXT RECORD
C  ITY : SURFACE NUMBER
C  ITN : DATA ITEM NUMBER
C  VAL : DATA ITEM VALUE
5     READ  (LU, * , ERR = 140, END = 150) ITY, ITN, VAL 
!*** changed input to free format

CBUG  WRITE (8, 502) ITY, ITN, VAL
      IF (ITY .EQ. -1) GO TO 201
      IF (ITY .GT. NS .OR. ITY .GT. NDIM .OR. ITY .LT. 0) GO TO 100
C
C  SEE IF ITN IS WITHIN LIMITS
      IF (ITN .LT. 1 .OR. ITN .GT. 30) GO TO 110
C
      IF (ITY .NE. 0) GO TO 30
      IF (ITN .GT. 20) GO TO 20
C
C  CHECK VALUE OF GENERAL SYSTEM PARAMETER AGAINST LIMITS
      IF (VAL .LT. GLIM (1, ITN)) GO TO 120
      IF (VAL .GT. GLIM (2, ITN)) GO TO 120
      GEN (ITN) = VAL
      IF (ITN .EQ. 4) NS = VAL + .0001D0
      IF (NS .LE. NDIM) GO TO 5
      IER = -1
      CALL INCLIN (1)
      WRITE (8, 590) NS, NDIM
      GO TO 201
C
C  SET GENERAL SYSTEM SWITCH
20    CONTINUE
      LH = .TRUE.
      IF (VAL .EQ. 0.0) LH = .FALSE.
      LSW0 (ITN - 20) = LH
      GO TO 5
C
C  CHECK VALUE OF SURFACE INFORMATION AGAINST LIMITS
30    IF (ITN .GT. 20) GO TO 40
      IF (VAL .LT. SLIM (1, ITN)) GO TO 130
      IF (VAL .GT. SLIM (2, ITN)) GO TO 130
      SURF (ITN, ITY) = VAL
      GO TO 5
C
C  SET SURFACE SWITCH
40    CONTINUE
      LH = .TRUE.
      IF (VAL .EQ. 0.0) LH = .FALSE.
      LSW (ITN - 20, ITY) = LH
      GO TO 5
C
C  ERROR IN ITY VALUE
100   CALL INCLIN (1)
      WRITE (8, 600) ITY, NS
      IER = -2
      GO TO 201
C
C  ERROR IN ITN VALUE
110   CALL INCLIN (1)
      WRITE (8, 601) ITN
      GO TO 5
C
C  VALUE OUT OF RANGE (GENERAL SYSTEM INFORMATION)
120   IF (IER .NE. 0) GO TO 121
      CALL INCLIN (3)
      WRITE (8, 602)
121   WRITE (8, 603) ITN, VAL, GLIM (1, ITN), GLIM (2, ITN)
      IER = IER + 1
      GO TO 5
C
C  VALUE OUT OF RANGE (SURFACE INFORMATION)
130   IF (IER .NE. 0) GO TO 131
      CALL INCLIN (3)
      WRITE (8, 602)
131   WRITE (8, 604) ITY, ITN, VAL, SLIM (1, ITN), SLIM (2, ITN)
      IER = IER + 1
      GO TO 5
C
C  ERROR WHILE READING FILE
140   CALL INCLIN (1)
      WRITE (8, 610)
      IER = -3
      GO TO 201
C
C  EOF WHILE READING FILE
150   CALL INCLIN (1)
      WRITE (8, 620)
      IER = -4
      GO TO 201
C
201   RETURN
500   FORMAT (20A4)
 
C !*** PE VERSION WAS FIXED FORMAT INPUT -  501   FORMAT (6X, 2I3, F23.0)
 
590   FORMAT (' FATAL ERROR IN RDGI, NS =', I5,
     1        ', LIMITS: 0 TO NDIM =', I5)
600   FORMAT (' FATAL ERROR IN RDGI, ITY =', I5,
     1        ', LIMITS: 0 TO NS =', I5)
601   FORMAT (' ERROR IN ITN, VALUE READ = ', I5,
     1        'PERMITTED RANGE IS 1 TO 20')
602   FORMAT (' THE FOLLOWING PARAMETERS ARE OUT OF RANGE'/,
     1'0     SURFACE    ITEM       VALUE           MIN            MAX',/
     2'        NUM       NUM       INPUT          LIMIT          LIMIT')
603   FORMAT (10X, I10, 1P,3E15.5)
604   FORMAT ('0', 2I10, 1P,3E15.5)
610   FORMAT (' ERROR WHILE READING GI FILE')
620   FORMAT (' EOF WHILE READING GI FILE')
      END
