!+
!KWIC rdray.f
!
!$Id: rdray.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

!
!  UPDATED 2/26/88 TOR READ EXPANDED RAY FILES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE RDRAY (IOPZ, FOPZ, Q3Z, IER2)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    RDRAY FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/07/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:00:36
C    *
C    ******************************************/
C
C  PURPOSE :  TO READ ALL RELEVANT SURFACE INTERSECTION
C             PARAMETERS FOR ONE RAY
C
C  INPUT VIA /PARX/ :
C     NDIM :  NUMBER OF SURFACES ALLOWED FOR
C     NS   :  NUMBER OF SURFACES
C
C  INPUT VIA /RAIN/ :
C     JRAY :  CURRENT RAY NUMBER
C
C  INPUT VIA VARIOUS RAY FILES :
C     ALL PARAMETERS OUTPUT BY DRAT FOR ONE RAY
C
C  OUTPUT ARGUMENTS :
C     IOPZ :  ARRAY OF INTEGER PATH LENGTHS
C     FOPZ :  ARRAY OF FRACTIONAL PATH LENGTHS
C     Q3Z  :  ARRAY OF 2ND DERIVATIVE MATRICES
C     IER2 :  ERROR FLAG -
C        0 = SUCCESSFUL RAY
C        1 = UNSUCCESSFUL RAY
C        2 = NO RAYS LEFT IN RAY FILES
C
C  OUTPUT VIA /RAIN/ :
C     KODE :  RAY STATUS CODE (SEE CHEX LISTING) AT FIANL SURFACE
C
C  OUTPUT VIA /SUMRY/ :
C     JAIL2 : NUMBER OF RAYS FAILING SYSTEM
C     LEFT2 : NUMBER OF RAYS PASSING SYSTEM
C
C  OUTPUT VIA /XV/, /YV/, /ZV/ :
C     POSITIONS AND DIRECTIONS OF RAY AT EACH SURFACE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries

      DIMENSION IOPZ (21), FOPZ (21), Q3Z (6, 21)
      DOUBLE PRECISION  FOPZ
C
C
C  INITIALIZE FLAGS
      IER2 = 0
      KPASS = 1
C
C  INCREMENT EXPECTED RAY #
      JRAY = JRAY + 1
C
C  LOOP ONCE FOR EACH SURFACE INCLUDING FOCAL PLANE
      JTOP = NS + 1
      DO 700 J = 1, JTOP
C  SET FILE NUMBER, READ 1ST LINE
      ND = J + 8
      READ (ND, 900, END = 800, ERR = 810) KRAY, KING, K2, KODE, IN10
      IF (KRAY .LT. 0) GO TO 750
C  IS THIS THE RIGHT RAY?
      IF (JRAY .NE. KRAY) GO TO 820
C  IS THE RAY SUCCESSFUL?
      IF (KODE .GT. 4) GO TO 220
C  YES, HAS IT FAILED BEFORE?
      IF (KPASS .NE. 1) GO TO 830
C  SUCCESSFUL RAY - READ REMAINING PARAMETERS
      NPOS = J + 30
      NDIR = J + NDIM + 32
      READ (ND, 910) XV (NPOS), YV (NPOS), ZV (NPOS),
     1  XV (NDIR), YV (NDIR), ZV (NDIR), IOPZ (J), FOPZ (J),
     2  (Q3Z (I, J), I = 1, 6), DUM, DUM
      GO TO 250
C  FAILED RAY - SET FLAG
220   KPASS = - 1
C  IS THIS THE LAST (FOCAL PLANE) SURFACE?
250   IF (J .LE. NS) GO TO 700
C  YES - SET THE PROPER COUNTER
      IF (KPASS .EQ. 1) GO TO 650
      JAIL2 = JAIL2 + 1
      IER2 = 1
      GO TO 680
650   LEFT2 = LEFT2 + 1
C  WRITE RAY LINE TO SCALE FILE
680   WRITE (2, 900) KRAY, KING, K2, KODE, IN10
700   CONTINUE
      GO TO 760
C  NO MORE RAYS - SET IER2, DECREMENT JRAY
750   IER2 = 2
      JRAY = JRAY - 1
760   RETURN
C
800   continue
      WRITE (8, 8000) JRAY, J
      STOP 8
810   continue
      WRITE (8, 8010) JRAY, J
      STOP 8
820   continue
      WRITE (8, 8020) JRAY, KRAY, J
      STOP 8
830   continue
      WRITE (8, 8030) JRAY, J
      STOP 8
900   FORMAT (5(I10))
!  (READ TWO ADDITIONAL LINES)
!  910   FORMAT (1P,3D25.17 / 3D20.17, I5, D15.12 / 3F12.9, 4X, 3F12.9)
910   FORMAT (3(1P,D25.17,1X) / 3(D19.16,1X), I5, 1X, D15.12 /
     1        3(F12.9,1X), 4X,
     1        3(F12.9,1X) /
     *        A4 / A4)
8000  FORMAT ('  RDRAY - READ EOF, RAY #(', I5,'+1), SURF #', I3)
8010  FORMAT ('  RDRAY - READ ERR, RAY #(', I5,'+1), SURF #', I3)
8020  FORMAT ('  RDRAY - FATAL ERROR -' /
     1  '  EXPECTING RAY #', I3,' BUT GOT #', I3, ' AT SURF #', I3)
8030  FORMAT ('  RDRAY - FATAL ERROR - RAY #', I5 /
     1  '  PASSED AT SURF #', I3, ', BUT FAILED BEFORE')
      END
