!+
!KWIC redeco.f
!
!$Id: redeco.f,v 1.2 2004/03/17 21:23:40 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Jan-27[T. Gaetz]
!      . change dimension of LSW to (10, 21) for consistency w/ other routines
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO READ THE COEFFICIENTS IN FREE FORMAT
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!-
!
!  UPDATED 5/9/88 TO ALLOW FOR ANNULAR ZERNIKE POLYNOMIALS,
!  TO INCLUDE THE UNIT NUMBER AND PRINT FLAG AS INPUT PARAMETERS,
!  AND TO MAKE DIFFERENT PRINTOUTS FOR CONVENTIONAL VS. X-RAY
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE REDECO (LU, IPRT, IER)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    REDECO FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 07/01/80
C    *
C    *    UPDATE:   03/11/82
C    *    TIME:     08:29:58
C    *
C    ******************************************/
C
C  INPUT THE DEFORMATION COEFFICIENT FILE FOR DRAT
!
!  INPUT PARAMETERS:
!    LU:   I*4 - LOGICAL UNIT NUMBER FOR THE DEFORMATION FILE
!    IPRT: I*4 - 0 = DON'T DO A PRINTOUT ON UNITS 6 AND 8
!                1 = DO
C
C  INPUT VIA D# LU : THE DEFORMATION FILE
C
!  INPUT VIA LABELD COMMON /PARX/:
!    KURF : I*4 - SURFACE NUMBER
!
C  INPUT VIA LABELED COMMON /SWITCH/:
C    SURFACE SWITCH:
C    LSW (9, KURF) : L*1 - F: CONVENTIONAL, T: XRAY SURFACE
C
C  OUTPUT VIA LABELED COMMON /IDENT/:
C    DFID  : 64 CHARACTER IDENTIFIER
C
C  OUTPUT VIA LABELED COMMON /DEFORM/:
C    NLEG  : I*4 - NUMBER OF LEGENDRE DEFORMATION COEFFICIENTS
C    NFOUR : I*4 - NUMBER OF FOURIER DEFORMATION COEFFICIENTS
C    NDF   : I*4 - NUMBER OF DEFORMATION COEFFICIENTS
C    DEFT  : R*8 - SQUARE ROOT OF THE SUM OF THE SQUARES
C                  OF DEFORMATION COEFFICIENTS
C    DEF2  : R*8 - SUM OF THE SQUARES OF DEFORMATION COEFFCIENTS
C    DEFC  : 500*R*8 - THE DEFORMATION COEFFICIENTS
!    OBSC  : R*8 - LINEAR OBSCURATION RATIO
C
C  OUTPUT ARGUMENT:
C    IER   : I*4 ERROR CODE
C            IER = 0  : NO ERROR
C            IER = 1  : EOF
C            IER = 2  : READ ERROR
C            IER = 3  : THERE ARE FEWER COEFFICIENTS IN THE FILE
C                       THAN REQUESTED
!            IER = 4  : THE OBSCURATION RATIO IS ILLEGAL
C
C  EXTERNAL REFERENCES: INCLIN, ZBUILD
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
C
C  INITIALIZE THE ERROR CODE
      IER = 0
C
C  READ THE DEFORMATION IDENTIFIER (DFID) AND I AND J
C  WHERE I = TOTAL NUMBER OF LEGENDRE TERMS FOR XRAY SURFACE
C          = TOTAL NUMBER OF DEFORMATION COEFFICIENTS FOR CONV. SURFACE
C        J = AZIMUTHAL INDEX LIMIT (HIGHEST DEGREE OF FOURIER TERMS)
C            (NOT USED FOR CONVENTIONAL SURFACE)
C
C  XR : INCLIN
C
!
!  BEFORE READING, FIND OUT IF IT IS A CONVENTIONAL SURFACE
!     READ (13, 510, ERR = 300, END = 310) DFID, I, J
!
C
C  IS IT AN XRAY SURFACE?
!      IF (LSW0 (1)) GO TO 50
       IF (LSW (9, KURF)) GO TO 50
C
C  CONVENTIONAL SURFACE  !!! READ AND CHECK THE OBSCURATION RATIO
      READ (LU, 505, ERR = 300, END = 310) DFID, I, OBSC
      IF (OBSC .LT. 0.D0 .OR. OBSC .GE. 1.D0) GO TO 350
      NLEG = 0
      NFOUR = 0
      NDF = I
      M = 325
      GO TO 60
C
C  XRAY SURFACE  !!! READ AS BEFORE
50    READ (LU, 510, ERR = 300, END = 310) DFID, I, J
      NLEG = I
      NFOUR = J
      NDF = I + I * (J + J)
      M = 500
C
60    IF (NDF .GT. M) GO TO 340
C
C  READ THE DEFORMATION COEFFICIENTS
!      CHANGED TO FREE FORM BY M. WILSON ON AUG. 22, 1988
!      READ (LU, 520, ERR = 320, END = 330) (DEFC (L), L = 1, NDF)
      READ (LU, *, ERR = 320, END = 330) (DEFC (L), L = 1, NDF)
C
      SUM = 0.0
      CMAX = - 1.0
C
      WEIGHT = 1.
      DO 100 J = 1, NDF
      H = ABS (DEFC (J))
!     IF (.NOT. LSW0 (1)) GO TO 80
      IF (.NOT. LSW (9, KURF)) GO TO 80
C  (SURFACE IS X-RAY, SO CALCULATE WEIGHTING FACTOR)
      L = MOD (J - 1, NLEG)
      WEIGHT = 1. / (2. * (L + L + 1.))
      IF (J .LE. NLEG) WEIGHT = WEIGHT + WEIGHT
C  (NOW CALCULATE WEIGHTED SUM OF SQUARES)
80    CI = WEIGHT * H * H
      SUM = SUM + CI
      IF (CI .LE. CMAX) GO TO 100
      CMAX = CI
      JMAX = J
100   CONTINUE
C
      DEF2 = SUM
      DEFT = SQRT (DEF2)
      CMAX = SQRT (CMAX)
C
C  WRITE SUMMARY ON D#6 AND D#8:
!  (BUT NOT IF IPRT = 0)
      IF (IPRT .EQ. 0) GO TO 500
!
!  WRITE A DIFFERENT SUMMARY FOR CONVENTIONAL VS. X-RAY
!
!     IF (LSW0 (1)) GO TO 150
      IF (LSW (9, KURF)) GO TO 150
      CALL INCLIN (6)
      WRITE (8, 600)
      WRITE (8, 620) DFID
      WRITE (8, 615) NDF, OBSC, JMAX, CMAX, DEFT, DEF2
      WRITE (8, 630)
      GO TO 180
!
150   CALL INCLIN (7)
      WRITE (8, 600)
      WRITE (8, 620) DFID
      WRITE (8, 610) NDF, NLEG, NFOUR, JMAX, CMAX, DEFT, DEF2
      WRITE (8, 630)
180   CONTINUE
C
C  WRITE THE DEFORMATION COEFFICIENTS
      IF (NDF .GT. 275) GO TO 220
      IF (NDF .GT. 175) GO TO 210
      CALL INCLIN (INT ((NDF + 4.) / 5.))
      WRITE (8, 640) (DEFC (L), L = 1, NDF)
      GO TO 500
C
210   CALL INCLIN (35)
      WRITE (8, 640) (DEFC (L), L = 1, 175)
      CALL INCLIN (55)
      WRITE (8, 640) (DEFC (L), L = 176, NDF)
      GO TO 500
C
220   CALL INCLIN (35)
      WRITE (8, 640) (DEFC (L), L = 1, 175)
      CALL INCLIN (55)
      WRITE (8, 640) (DEFC (L), L = 176, 275)
      CALL INCLIN (55)
      WRITE (8, 640) (DEFC (L), L = 276, NDF)
      GO TO 500
C
C  ERROR WHILE READING THE DEFORMATION ID RECORD
300   continue
      WRITE (8, 650)
      IER = 2
      GO TO 500
C
C  EOF WHILE READING THE DEFORMATION ID RECORD
310   continue
      WRITE (8, 660)
      IER = 1
      GO TO 500
C
C  ERROR WHILE READING THE COEFFICIENTS
320   continue
      WRITE (8, 670)
      IER = 2
      GO TO 500
C
C  EOF WHILE READING THE COEFFICIENTS
330   continue
      WRITE (8, 680)
      IER = 1
      GO TO 500
C
C  INSUFFICIENT NUMBER OF COEFFICIENTS ON FILE
340   continue
      WRITE (8, 690)
      IER = 3
      GO TO 500
!
!  IMPROPER OBSCURATION RATIO
350   continue
      WRITE (8, 695) OBSC
      IER = 4
C
500   RETURN
505   FORMAT (16A4, 1X, I5, F9.6)
510   FORMAT (16A4, 1X, 2I5)
!520  FORMAT (1P,5E15.5)
600   FORMAT (/ T25, 'SUMMARY OF DEFORMATION COEFFICIENTS' /
     1 T25, 35 (1H-) /)
610   FORMAT (1X, 'TOTAL NUMBER OF COEFFICIENTS    =', I15 /
     1        1X, 'NUMBER OF LEGENDRE TERMS        =', I15 /
     2        1X, 'AZIMUTHAL INDEX LIMIT           =', I15 /
     3        1X, 'INDEX OF LARGEST CONTRIBUTION   =', I15 /
     4        1X, 'LARGEST CONTRIBUTION            =', 1P,E15.7 /
     5        1X, 'ROOT SUM SQUARE                 =', E15.7 /
     6        1X, 'SUM OF THE WEIGHTED SQUARES     =', E15.7 /)
615   FORMAT (1X, 'TOTAL NUMBER OF COEFFICIENTS    =', I15 /
     1        1X, 'LINEAR OBSCURATION RATIO        =', F15.6 /
     3        1X, 'INDEX OF LARGEST CONTRIBUTION   =', I15 /
     4        1X, 'LARGEST CONTRIBUTION            =', 1P,E15.7 /
     5        1X, 'ROOT SUM SQUARE                 =', E15.7 /
     6        1X, 'SUM OF THE WEIGHTED SQUARES     =', E15.7 /)
620   FORMAT (1X, 16A4)
630   FORMAT (' THE DEFORMATION COEFFICIENTS:' /)
640   FORMAT (1P,5E15.5)
650   FORMAT ('-REDECO ERROR: ERROR WHILE READING THE DEFORMATION ',
     1 'ID RECORD')
660   FORMAT ('-REDECO ERROR: EOF WHILE READING THE DEFORMATION',
     1 ' ID RECORD')
670   FORMAT ('-REDECO ERROR: ERROR WHILE READING THE COEFFICIENTS')
680   FORMAT ('-REDECO ERROR: EOF WHILE READING THE COEFFICIENTS')
690   FORMAT ('-REDECO ERROR: INSUFFICIENT NUMBER OF COEFFICIENTS',
     1 ' ON FILE')
695   FORMAT ('-REDECO ERROR: OBSC (0 .LE. OBSC .LT. 1) =', 1P,D12.4)
      END
