!+
!KWIC rehead.f
!
!$Id: rehead.f,v 1.2 2004/03/17 21:23:41 dtn Exp $
!
!Revisions:
!   98-Feb-05[T. Gaetz]
!      . change SNGL to DBLE
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   93-Nov-22[T. Gaetz]
!      . removed extraneous GOTO 300 statement after STOP; unreachable code
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . elminate RIDRAY - not used
!      . add target 161 as target for loop-back; branching to the do-loop
!        continue label from outside the loop is poor style.
!   93-Aug-16[T. Gaetz]
!      . add new include file:  /RF_IOFMT/ IOFMT;
!        encodes IO type to distinguish different ascii formats;
!        value is initialized in hedray.f
!      . read in new header record giving IO format version; check for
!        valid version header record (beginning with 'IOFVN: ')
!-

!  UPDATED 8/29/88 TO GET RID OF FREE FORMAT READING, SINCE
!  RAY FILES ARE NEVER WRITTEN BY A USER, AND SINCE VERSION 5
!  USAGE FOUND THAT CERTAIN NEGATIVE NUMBERS CAUSE FREE FORMAT
!  PROBLEMS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE REHEAD (ND, IFLG, IER)
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    REHEAD FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 07/02/80
C    *
C    *    UPDATE:   12/04/81
C    *    TIME:     13:12:51
C    *
C    ******************************************/
C
C  READ THE HEADER RECORD OF THE RAY FILE FOR DRAT
C
C  INPUT PARAMETERS :
C    ND   : INPUT DEVICE #
C    IFLG : 1 MEANS RAY FILE EXPECTED
C          -1 MEANS EITHER A SCAL, ARAY, OR OPD FILE IS EXPECTED
C             (IN THIS CASE, NO REQUIREMENT IS PLACED ON KURF)
C
C  INPUT VIA D# ND WHEN KURF > 1 : THE INPUT RAY FILE
C
C  INPUT VIA /PARX/ :
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C    NS   : I*4 - ACTUAL NUMBER OF SURFACES
C    KURF : I*4 - SURFACE NUMBER
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C    RZER : R*4 - INITIAL NON-ZERO RADIUS OF ANNULAR APERTURE
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C    H2   : R*4 - NOT NEEDED, DUMMIED TO -1. IN NEW VERSION
C
C  OUTPUT ARGUMENT :
C    IER : ERROR CODE
C          IER = 0 : NO ERROR, OR KURF = 1
C          IER = 1 : EOF
C          IER = 2 : READ ERROR
C          IER = 3 : KURF < 1, INCORRECT SURFACE # (N/A IF IFLG = -1)
C          IER = 4 : JURF + 1 DOES NOT EQUAL KURF
C          IER = 5 : THE REMAINING PARX VARIABLES DO NOT AGREE
C
C  OUTPUT VIA D# 6 AND 8 :
C    ERROR MESSAGES
C
C  EXTERNAL REFERENCES: NONE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      INTEGER           IOFMT
      COMMON /RF_IOFMT/ IOFMT             ! io type

      DOUBLE PRECISION RFOC
      character*80 idline
      character*8  iover
      character*4  PID(4)
      DIMENSION  GX(3), RX(3)
      DATA PID /'RZER', '  DR', '  H2', 'GFOC'/
      EQUIVALENCE  (GX(1), RZER)
C
      IER = 0
      IF (IFLG .EQ. -1) GO TO 110
      IF (KURF .LT. 1) GO TO 200
      IF (KURF .EQ. 1) GO TO 300
C
C  READ RAY FILE HEADER CARDS AND DISCARD
110   READ (ND, 500, ERR = 210, END = 220) idline
      READ (ND, 500, ERR = 210, END = 220) idline

C  READ IO FORMAT VERSION NUMBER
      READ (ND, 830, ERR = 250, END = 250) IOVER, IOFMT
      IF ( IOVER .ne. ' IOFVN: ' ) THEN
         write ( * , '(t1,a,i3)' ) iover, iofmt
         GOTO 250
      ENDIF

C  READ THE PARX CARD
!  FREE FORMAT REMOVED 8/29/88
!
      READ (ND, 510, ERR = 230, END = 240) NSR, JURF, MINGR, M2R,
     *  RX, RFOC
C
C  RAY FILE SURFACE NUMBER (JURF) MUST BE THE PREVIOUS SURFACE
      IF (JURF +1 .EQ. KURF) GO TO 120
C                
C  RAY FILE SURFACE NUMBER (JURF) + 1 DOES NOT EQUAL KURF
      IER = 4
      WRITE (8, 810) JURF, KURF
C
C  SEE IF THE  COMMON PARX INTEGER VARIABLES AGREE WITH RAY FILE VALUES
120   IF (NSR .EQ. NS .AND. MINGR .EQ. MING .AND. M2R .EQ. M2) GOTO 130
C
C  ONE OR MORE PARX INTEGER VARIABLES DISAGREE
      IER = 5
      WRITE (8, 820) NS, MING, M2, NSR, MINGR, M2R
C
130   CONTINUE
C  SEE IF THE  COMMON PARX R*4 VARIABLES AGREE WITH RAY FILE VALUES
      DO 160 I = 1, 3
      E = RX(I) - GX(I)
      IF (E .EQ. 0.0) GO TO 160   ! cycle...
      IF (ABS(E) .GT. 1.0E-06 * ABS(GX(I))) GOTO 150
C
C  MINOR DESCREPENCY IN R*4 PARX VARIABLES
      WRITE (8, 840)
      WRITE (8, 860) PID(I), GX(I), RX(I), E
      GOTO 160 ! cycle...
C
C  MAJOR DESCREPENCY IN R*4 PARX VARIABLES
150   IER = 5
      WRITE (8, 850)
      WRITE (8, 860) PID(I), GX(I), RX(I), E
160   CONTINUE  ! end of do loop

161   CONTINUE  ! loop back target: 'minor discrepency in R*8 PARX variables
C
C  SEE IF THE  COMMON PARX GFOC AGREES WITH RAY FILE VALUE
      E = RFOC - GFOC
      IF (E .EQ. 0.0) GOTO 300
      IF (ABS(E) .GT. 1.0E-08 * ABS(DBLE(GFOC))) GOTO 170
C
C  MINOR DESCREPENCY IN R*8 PARX VARIABLES
      WRITE (8, 840)
      WRITE (8, 860) PID(4), GFOC, RFOC, E
      GOTO 161
C
C  MAJOR DESCREPENCY IN R*8 PARX VARIABLES
170   IER = 5
      WRITE (8, 850)
      WRITE (8, 860) PID(4), GFOC, RFOC, E
      WRITE (8, 850) PID(I), GX(I), RX(I), E
      GOTO 300
C
C  ERROR : KURF < 1
200   IER = 3
      WRITE (8, 600) KURF
      GO TO 300
C
C  ERROR WHILE READING RAY FILE ID CARDS
210   IER = 2
      WRITE (8, 610)
      GO TO 300
C
C  EOF WHILE READING RAY FILE ID CARDS
220   IER = 1
      WRITE (8, 620)
      GO TO 300
C
C  ERROR WHILE READING RAY FILE PARX CARD
230   IER = 2
      WRITE (8, 630)
      GO TO 300
C
C  EOF WHILE READING RAY FILE PARX CARD
240   IER = 1
      WRITE (8, 640)
C
C  ERROR WHILE READING RAY FILE PARX CARD
250   continue
      WRITE (8, 831)
      STOP
C
300   RETURN
500   FORMAT (A80)
!
!  510 RESTORED 8/29/88
!
510   FORMAT (4I5, 1P,3E15.6, D15.8)
!
600   FORMAT ('-REHEAD ERROR : KURF =', I11, ' LESS THAN 1')
610   FORMAT ('-REHEAD ERROR: ERROR WHILE READING RAY FILE ID CARDS')
620   FORMAT ('-REHEAD ERROR: EOF WILE READING RAY FILE ID CARDS')
630   FORMAT ('-REHEAD ERROR: ERROR WHILE READING RAY FILE PARX CARD')
640   FORMAT ('-REHEAD ERROR: EOF WHILE READING RAY FILE PARX CARD')
810   FORMAT ('-REHEAD ERROR: RAY FILE SURFACE NUMBER (',
     *  I3, ') PLUS 1 DOES NOT EQUAL KURF(', I3, ')')
820   FORMAT ('-REHEAD ERROR : PARX INTEGER VARIABLES DISAGREE' //
     *  13X, 'G X   F I L E', T48, 'R A Y   F I L E' //
     *  2 (9X, 'NS', 7X, 'MING', 7X, 'M2', 4X) // 3I10, 5X, 3I10 /)
830   FORMAT (T1, A8, I3)
831   FORMAT ('-REHEAD ERROR (FATAL): ',
     &        'unable to read IO format version number' )
840   FORMAT ('-REHEAD WARNS : MINOR DISCREPANCY IN PARX VARIABLE :')
850   FORMAT ('-REHEAD ERROR : MAJOR DISCREPANCY IN PARX VARIABLE :')
860   FORMAT (1X, A4, ' GX VALUE =', 1P,E18.8, ' RAY VALUE =', E18.8,
     *  ' DELTA =', E11.2 /)
      END
