!+
!KWIC rinlz.f
!
!$Id: rinlz.f,v 1.2 2004/03/17 21:23:41 dtn Exp $
!
!Revisions:
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

      SUBROUTINE RINLZ
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    RINLZ FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 12/08/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:06:09
C    *
C    ******************************************/
C
C  INITIALIZE QUANTITIES NEEDED FOR RADIAL FFT CALCULATIONS
C
C  INPUT VIA LABELED COMMON /PARM/ :
C    GEN (9) : R*8 - INNER RADIUS OF ANNULUS
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C    RZER : R*4 - INITIAL NON-ZERO RADIUS OF ANULAR APERTURE
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 10 : COORDINATES OF BEST FOCUS (REF SPHERE CENTER) IN FP
C
C  INPUT VIA LABELED COMMON /ILIMIT/ :
C    NR     : I*4 - NUMBER OF RINGS ALLOWED
C    NTHETA : I*4 - NUMBER OF SPOKES ALLOWED
C    MFFT   : I*4 - LOG-BASE-2 OF NUMBER OF FFT POINTS ALLOWED
C    NGRID  : I*4 - NUMBER OF X OR Y PIXELS ALLOWED IN FOCAL PLANE ARRAY
C
C  INPUT VIA LABELED COMMON /IOPRAM/ :
C    FOGR (1) : R*8 - PIXEL ARRAY CENTER X COORD
C    FOGR (2) : R*8 - PIXEL ARRAY CENTER Y COORD
C    FOGR (3) : R*8 - PIXEL ARRAY X LENGTH
C    FOGR (4) : R*8 - PIXEL ARRAY Y LENGTH
C    FOGR (5) : R*8 - NUMBER OF PIXELS IN X DIRECTION
C    FOGR (6) : R*8 - NUMBER OF PIXELS IN Y DIRECTION
C    ZLAM     : R*4 - WAVELENGTH
C    EFL      : R*4 - EFFECTIVE FOCAL LENGTH
C    RA       : R*4 - INNER RADIUS OF ANNULAR APERTURE
C    RB       : R*4 - OUTER RADIUS OF ANNULAR APERTURE
C    NX       : I*4 - NX = FOGR (5)
C    NY       : I*4 - NY = FOGR (6)
C
C  OUTPUT VIA LABELED COMMON /IOPRAM/ :
C    WMAX : R*4 - MAXIMUM DISTANCE BETWEEN BEST FOCUS, AND CORNERS OF FP
C    MM   : I*4 - LOG-BASE-2 OF NUMBER OF FFT POINTS
C    NN   : I*4 - NUMBER OF FFT POINTS
C
C  OUTPUT VIA LABELED COMMON /RVECTR/ :
C  IF I = RING NUMBER,
C    RAD (I)   : RADIUS OF RING
C    OPD (I)   : OPD OF POINT IN SPOKE
C    WSQRT (I) : SQRT (RAY WEIGHT) OF POINT IN SPOKE
C
C  XR : INCLIN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
C
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /ILIMIT/ NR, NTHETA, MFFT, NGRID
      COMMON /IOPRAM/ FOGR (6), ZLAM, EFL, RA, RB, WMAX, NX, NY, MM, NN
      COMMON /RVECTR/ RAD (50), OPD (50), WSQRT (50)
      DIMENSION NINM (9)
      DOUBLE PRECISION FOGR
      DOUBLE PRECISION WXPLUS, WXMINS, WYPLUS, WYMINS, W1, W2, W3, W4
      DATA NINM /2, 4, 8, 16, 32, 64, 128, 256, 512/, PI2 /6.28319/
C
C
C  CHECK MING AND M2
      IF (MING .GT. NR) GO TO 2000
      IF (M2 .GT. NTHETA) GO TO 2010
C
C  DEFINE WMAX, MM, NN
C  (DEFINE DISTANCE FROM BEST FOCUS TO EACH CORNER OF FOCAL PLANE)
      WXPLUS = FOGR (1) + 0.5D0 * FOGR (3) - XV (10)
      WXMINS = WXPLUS - FOGR (3)
      WYPLUS = FOGR (2) + 0.5D0 * FOGR (4) - YV (10)
      WYMINS = WYPLUS - FOGR (4)
      W1 = DSQRT (WXPLUS * WXPLUS + WYPLUS * WYPLUS)
      W2 = DSQRT (WXMINS * WXMINS + WYPLUS * WYPLUS)
      W3 = DSQRT (WXPLUS * WXPLUS + WYMINS * WYMINS)
      W4 = DSQRT (WXMINS * WXMINS + WYMINS * WYMINS)
C  (SET WMAX AND IMPLIED NUMBER OF PIXELS)
      WAIRY = ZLAM * EFL / (2. * (RB - RA))
      WMAX = DMAX1 (W1, W2, W3, W4, DBLE (MING * WAIRY))
      NMAX = INT (4. * WMAX / WAIRY + 1.)
C  (SET AND TEST NUMBER OF FFT POINTS TO BE USED)
      MXALL = MAX0 (NX, NY, NMAX, 15)
      MM = 0
      DO 150 J = 1, MFFT
      IF (MM .GT. 0) GO TO 200
      IF (NINM (J) .LE. MXALL) GO TO 150
      MM = J
      NN = NINM (J)
150   CONTINUE
200   IF (MM .EQ. 0) GO TO 2020
C
C  SET UP RAD ARRAY
      IF (GEN (9) .EQ. 0.D0) GO TO 220
      JINC = 0
      GO TO 240
220   JINC = 1
      RAD (1) = 0.
240   RADIUS = RZER
      JTOP = MING - JINC
      DO 300 J = 1, JTOP
      RAD (J + JINC) = RADIUS
      RADIUS = SQRT (RADIUS * RADIUS + DR)
300   CONTINUE
      RETURN
C
2000  continue
      CALL INCLIN (2)
      WRITE(8, 8000) MING, NR
      STOP 8
2010  continue
      CALL INCLIN (2)
      WRITE (8, 8010) M2, NTHETA
      STOP 8
2020  continue
      CALL INCLIN (3)
      WRITE (8, 8020) NX, NY, NMAX, MFFT
      STOP 8
C
8000  FORMAT ('  RINLZ - FATAL ERROR -' /
     1  '    NUMBER OF RINGS (ACTUAL, ALLOWED) =', 2I6)
8010  FORMAT ('  RINLZ - FATAL ERROR -' /
     1  '    NUMBER OF SPOKES (ACTUAL, ALLOWED) =', 2I6)
8020  FORMAT ('  RINLZ - FATAL ERROR -' /
     1  '    N-PIX (X-,Y-SPEC), N-PIX (CALC), LOG-2(N-PIX (ALLOWED)) :'
     2  / 4I6)
      END
