!+
!KWIC runsum.f
!
!$Id: runsum.f,v 1.2 2004/03/17 21:23:41 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . convert DPI2 initialization to parameter statements
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO FIX BUG THAT MADE THE EFFECTIVE FOCAL LENGTH
!        !  CALCULATION ANYWHERE FROM SLIGHTLY TO GROSSLY INACCURATE FOR
!        !  SYSTEMS WITH DECENTERED FOCAL PLANES AND/OR ENTRANCE APERTURES
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

!
!  UPDATED 2/26/88 TO USE EXPANDED RAY FILES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE RUNSUM (PS, ES, FS, WS, IER)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    RUNSUM FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 10/28/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:05:19
C    *
C    ******************************************/
C
C  UPDATE VARIOUS RUNNING SUMS FOR AVERAGING CALCULATIONS
C
C  INPUT / OUTPUT PARAMETERS :
C    PS : R*8 - RUNNING SUM OF OPTICAL PATH LENGTH TO FOCAL PLANE
C    ES : R*8 - RUNNING SUM OF EFFECTIVE FOCAL LENGTH
C    FS : R*8 - RUNNING SUM OF DOT PRODUCT OF (FOCAL PLANE INTERSECTION)
C                                        AND (DIRECTION VECTOR)
C    WS : R*8 - RUNNING SUM OF RAY WEIGHT
C
C  INPUT VIA LABELED COMMON /PARM/ :
C    GEN (1) : R*8 - X OF CENTER OF ANNULAR APERTURE
C    GEN (2) : R*8 - Y OF CENTER OF ANNULAR APERTURE
C    GEN (9) : R*8 - INNER RADIUS OF ANNULUS
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    RZER : R*4 - INITIAL NON-ZERO RADIUS OF ANNULAR APERTURE
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C
C  INPUT VIA LABELED COMMON /RAIN/ :
C    JRAY : I*4 - EXPECTED RAY NUMBER
C
C  OUTPUT PARAMETER:
C    IER : I*4 -  -1 = TRAILER RECORD ENCOUNTERED
C                 1  = MORE RAYS TO GO
C
C  OUTPUT VIA LABELED COMMON /SUMRY/ :
C    AQ    : R*8 - BEST FOCUS INFORMATION
C    LEFT2 : I*4 - NUMBER OF SUCCESSFUL RAYS
C    WS2   : R*8 - TOTAL RAY WEIGHT
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 1 : RUNNING SUM OF FOCAL PLANE DIRECTION VECTOR
C
C  XR : VDOT
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION VDOT
      DOUBLE PRECISION PS, ES, FS, WS, WI, FOPZ, A, B, C, T
      DOUBLE PRECISION R0, THT, RSQ, X1, Y1, DISCR
      real * 8    DPI2
      parameter ( DPI2 = 6.28318 53071 79586 47692D0 )
      DATA INIT / 1 /
C
C
C  READ RAY INFO, CHECK FOR TRAILER RECORD
      READ (3, 8000, ERR = 2100, END = 2200) KRAY, KING, K2, JODE, IN10
      IF (KRAY .LT. 0) GO TO 1000
C
C  SEE IF RAY NUMBER = EXPECTED RAY NUMBER
      IF (JRAY .NE. KRAY) GO TO 2000
C
C  LEGITIMATE RAY - SET ERROR FLAG
      IER = 1
      IF (JODE .GT. 4) GO TO 1900
C  (UPDATE RAY WEIGHT)
      WI = IN10 * 1.D-8
      WS = WS + WI
!  (READ POLARIZATION DATA IN TWO ADDITIONAL RECORDS)
      READ (3, 8010, ERR = 2100, END = 2200) XV (10), YV (10), ZV (10),
     1               XV (11), YV (11), ZV (11), IOPZ, FOPZ, Q3,
     2               C2COMP, S2COMP
      IF (INIT .EQ. -1) GO TO 120
      IOPINI = IOPZ
      INIT = -1
C  (UPDATE PATH LENGTH)
120   IOPDEL = IOPZ - IOPINI
      PS = PS + (IOPDEL + FOPZ) * WI
C  (UPDATE EFFECTIVE FOCAL LENGTH)
      A = XV (11) * XV (11) + YV (11) * YV (11)
      B = XV (10) * XV (11) + YV (10) * YV (11)
      IF (GEN (9) .EQ. 0.D0 .AND. K2 .EQ. 1) GO TO 130
      R0 = SQRT (RZER * RZER + (KING - 1.) * DR)
      GO TO 150
130   IF (KING .GT. 1) GO TO 140
      R0 = 0.
      GO TO 150
140   R0 = SQRT (RZER * RZER + (KING - 2.) * DR)
!
!  THE FOLLOWING EXPRESSION USED J2 INSTEAD OF K2, CAUSING THE
!  BUG MENTIONED 5/17/89
!150   THT = DPI2 * (J2 - 1.D0) / M2
150   THT = DPI2 * (K2 - 1.D0) / M2
      X1 = GEN (1) + R0 * DCOS (THT)
      Y1 = GEN (2) + R0 * DSIN (THT)
      RSQ = X1 * X1 + Y1 * Y1
      C = XV (10) * XV (10) + YV (10) * YV (10) - RSQ
      DISCR = B * B - A * C
      IF (DISCR .GT. 0.D0) GO TO 160
C  (UNDEFINED EFL - ADD IN THE AVERAGE VALUE)
      IF (WI .EQ. 0.D0 .OR. WS .EQ. 0.D0) GO TO 170
      ES = ES * WS / (WS - WI)
      GO TO 170
C  (DEFINE EFL AND ADD WEIGHTED VALUE)
160   T = (- B - DSQRT (DISCR)) / A
      ES = ES - T * WI
C  (UPDATE V # 1)
170   XV (1) = XV (1) + XV (11) * WI
      YV (1) = YV (1) + YV (11) * WI
      ZV (1) = ZV (1) + ZV (11) * WI
      FS = FS + VDOT (10, 11) * WI
      GO TO 1900
C
C  TRAILER RECORD - READ WF2 AND AQ, SET ERR FLAG, AND EXIT
1000  READ (3, 8020, ERR = 2100, END = 2200) WF2, AQ
      LEFT2 = K2
      IER = -1
C
1900  RETURN
C
2000  continue
      WRITE (8, 8100) KRAY, JRAY
      STOP 8
2100  continue
      WRITE (8, 8110)
      STOP 8
2200  continue
      WRITE (8, 8120)
      STOP 8
C
8000  FORMAT (5I10)
!  (READ TWO ADDITIONAL RECORDS)
8010  FORMAT (1P,3D25.17 / 3F20.17, I5, F15.12 / 3F12.9, 4X, 3F12.9 /
     1        4F15.9 / 4F15.9)
8020  FORMAT (D20.12 / 2 (4D20.12 /), 2D20.12)
8100  FORMAT ('  RUNSUM - FATAL ERROR - RAY # (IN, EXPECTED) :', 2I6)
8110  FORMAT ('  RUNSUM - FATAL ERROR - ERROR WHILE READING RAY FILE')
8120  FORMAT ('  RUNSUM - FATAL ERROR - EOF WHILE READING RAY FILE')
      END
