!+
!KWIC saoraydum.f
!
!$Id: saoraydum.f,v 1.2 2004/03/17 21:23:41 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!   93-Sep-29[T. Gaetz]
!      . renamed to saoraydum; change error messages to conform
!   93-Apr-09[T. Gaetz]
!      . change over to implicit none; clean up declarations.
!      . strip out commented-out statements; see original RAYDUM to
!        see what was removed.
!-

      SUBROUTINE SAORAYDUM
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    RAYDUM FORTRAN 
C    *    WRITTEN BY JOHN LEGG
C    *            ON 06/10/80
C    *
C    *    UPDATE:   10/10/80
C    *    TIME:     14:07:33
C    *
C    ******************************************/
C
C  PURPOSE: TO WRITE ON #6 AND #8 THE RAY TRACE SUMMARY REPORT.
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (3) : R*8 - ZOFF - Z OFFSET OF FOCAL PLANE
C
C  INPUT VIA LABELED COMMON /PARX/:
C    GFOC: R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C    KURF: I*4 - CURRENT SURFACE NUMBER
C    NS  : I*4 - NUMBER OF SURFACES
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    JRAY : I*4 - CURRENT RAY NUMBER
C
C  INPUT VIA LABELED COMMON /SUMRY/:
C    WF1   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT PREVIOUS SURFACE
C    WF2   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT SURFACE #KURF
C    WS1   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT PREVIOUS SURFACE
C    WS2   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT SURFACE #KURF
C    JAIL1 : I*4 - NUMBER OF RAYS FAILING AT PREVIOUS SURFACE
C    JAIL2 : I*4 - NUMBER OF RAYS FAILING AT SURFACE #KURF
C    LEFT1 : I*4 - NUMBER OF RAYS LEAVING PREVIOUS SURFACE
C    LEFT2 : I*4 - NUMBER OF RAYS LEAVING SURFACE #KURF
C    XMIN  : R*4 - MINIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    XMAX  : R*4 - MAXIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    YMIN  : R*4 - MINIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C    YMAX  : R*4 - MAXIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C
C  OUTPUT VIA #6 AND #8: RAY SUMMARY REPORT
C

      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE

!---  global variables...

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries

!---  local variables...

!CODE saoraydum --------------------------------------------------------

      CALL INCLIN (17)
      WRITE (8, 100)
 
!---  write summary information for current surface
      WRITE (8, 120) KURF
      WRITE (8, 110) LEFT1, WS1, JAIL2, WF2, LEFT2, WS2

      RETURN

!---  format statements...

100   FORMAT (/, tr31, 'Ray Summary Report' , /, tr31 , 18('-') , /)
110   FORMAT (4X, 3(I8, F15.5))
120   FORMAT (/,T29, 'CURRENT SURFACE (#', I5, ')', //,
     1 T15, 'Started', T39, 'Failed', T60, 'Succeeded' /
     2 T10, 'Num', T22, 'Weight', T33, 'Num', T45, 'Weight',
     3 T56, 'Num', T68, 'Weight' /)

      END
