!+
!KWIC saotrader_foc.f
!
!$Id: saotrader_foc.f,v 1.2 2004/03/17 21:23:42 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Dec-05[T. Gaetz]
!      . optionally splice out CSIN & CSOUT calls using logical flag
!        do_osac_reflect (see raystuff.h)
!   95-Oct-06[T. Gaetz]
!      . add 'external csin' to satisfy sgi compiler.
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   95-Jan-23[T. Gaetz]
!      . apply OSAC V7.0 mods...
!        !  UPDATED 5/17/89 TO ADD TOROIDAL SURFACES
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 8/18/89 TO FIX ERROR IN Q3 SYMMETRIC MATRIX STORAGE MODE
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
!        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
!        !  CAN BE COMBINED
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Nov-01[T. Gaetz]
!      . extensive additions to documentation.
!   93-Sep-29[T. Gaetz]
!      . renamed to saotrader_foc; change error messages to conform
!   93-Apr-09[T. Gaetz]
!      . change over to implicit none.
!-
!
!  Same as trader2.f but calls wrad_foc instead of wrad2
!    - MDF Thu Jan 14 09:39:03 EST 1993
!
!  UPDATED 1/21/88 TO ADD OBSCURATION-TYPE SURFACES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 2/7/88 TO INCLUDE FULL POLARIZATION CALCULATIONS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE SAOTRADER_FOC
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    TRADER FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   10/29/81
C    *    TIME:     14:33:03
C    *
C    ******************************************/
C
C  trace a ray last optical surface to focus (for SAOfocus)
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN ( 3) : ZOFF - Z OFFSET OF FOCAL PLANE
C
C    IF J = SURFACE NUMBER THEN,
C    SURF (4, J) : P - CONIC CONSTANT = 1 - ECCEN ** 2
C    SURF (5, J) : VERTEX RADIUS OF CURV. OR K FACTOR OF XRAY SURFACE
C    SURF (6, J) : P0 - CENTER RADIUS  (USUALLY 0 FOR CONVENTIONAL), OR
C                  R - TOROIDAL RADIUS FOR TOROIDAL SURFACE
C
C  INPUT VIA LABELED COMMON /PARX/:
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C    KURF : I*4 - NUMBER OF CURRENT SURFACE
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    FOP  : R*8 - FRACTIONAL PORTION OF PATH LENGTH
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    SWITCH FOR SURFACE J:
C    LSW (1, J) : F - CONCAVE SURFACE, T - CONVEX SURFACE
C    LSW (2, J) : F - NO DEFORMATIONS, T - SURFACE DEFORMATIONS
C    LSW (3, J) : F - CONIC SURFACE, T - FLAT SURFACE
C    LSW (4, J) : F - ON-AXIS SURFACE, T - OFF-AXIS SURFACE
C    LSW (5, J) : F - NOT AN ANNULAR OBSCURATION, T - ANNULAR OBSC
C    LSW (6, J) : F - NOT A RECTANGULAR OBSC, T - RECTANGULAR OBSC
C    LSW (7, J) : F - "OBSC" IS AN OPENING, T - "OBSC" IS OPAQUE
C    LSW (8, J) : F - NOT TOROIDAL, T - TOROIDAL
C    LSW (9, J) : F- CONVENTIONAL SYSTEM, T - X-RAY SYSTEM
C    lsw (10,j) : F - NO SPLINE DEFORMATIONS, T - SPLINE (implies lsw(2,j) - T)
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#1 = INITIAL POSITION
C    V#2 = DIRECTION
C    V#11, 12, 13 = ROTATION MATRIX FOR SURFACE
C    V#14 = TRANSLATION VECTOR FOR SURFACE
C
C  INPUT & OUTPUT VIA /SUMRY/: (THROUGH WRAD)
C    AQ    : 10*R*8 - COEFFICIENTS OF QUADRATIC FOCUS FUNCTION
C    WF1   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT SURFACE
C    WS1   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT SURFACE
C    JAIL1 : I*4 - NUMBER OF RAYS FAILING AT SURFACE
C    XMIN  : R*4 - MINIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    XMAX  : R*4 - MAXIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    YMIN  : R*4 - MINIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C    YMAX  : R*4 - MAXIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C
C  OUTPUT VIA D#24 : RAY001
C
C  INPUT & OUTPUT VIA LABELED COMMON /RAIN/:
C    FOP  : R*8 - FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : I*4 - INTEGER    PORTION OF PATH LENGTH
C    KODE : I*4 - RAY STATUS CODE (SEE CHEX OUTPUT)
C    W    : R*4 - RELATIVE INTENSITY OF RAY
C    Q0   : R*4 - UN-NORMALIZED 2ND DERIVATIVE MATRIX
C    Q3   : R*4 - NORMALIZED Q0
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#7 = POSITION AT FOCAL PLANE
C    V#6 = DIRECTION AT FOCAL PLANE
C
C  XR : CHEX, COLEG4, CONCYL, COXERN, COZERN, CSIN, CSOUT, FLAZER,
C       OBSCUR, VDERO, VROT8, WRAD
C
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE

!---  global variables...

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/qprelq.h'    ! qpname, qprel, lq, nq, nt, npage
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/raystuff.h'  ! info needed for binary pipeline
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

!---  local variables...

      DOUBLE PRECISION RNRM, PZK
      INTEGER mode, j

      external csin

!CODE saotrader_foc ----------------------------------------------------

      IF (KODE .GT. 4 .OR. KODE .LT. 0) GO TO 100
      KODE = 2
      MODE = KODE

CBUG  CALL VWRITE ('INPT', JING, J2, 1, 2, KODE)

!---- handle transformation from STD to BCS ----------------------------
!
!     We start by transforming to the Body-Centered coordinate System
!     (BCS) associated with the current surface.
!
!     Note that:
!
!        #11 = x-axis direction cosines
!        #12 = x-axis direction cosines
!        #13 = x-axis direction cosines
!
!        #14 = translation from STD origin to BCS origin
!
!     First, initialize polarization calculations and convert
!     complex polarization amplitude vectors to BCS
!
      if ( do_osac_reflect ) then
         CALL CSIN ( 2,           ! ray initial direction vector
     &               11 )         ! initial vector of rotation matrix
                                  ! converting STD to BCS coord system
      endif

!     Now, rotate initial ray position, direction (#1, #2) into BCS
!     coordinates to obtain the transformed ray position, direction (#15, #16).
!
      CALL VROT8 ( 1, 2,       ! ray initial position, direction
     &            14,          ! translation vector for surface
     &            11, 12, 13,  ! rotation matrix for surface
     &            15, 16 )     ! ray position, direction in BCS system

CBUG  CALL VWRITE ('ROT1', JING, J2, 15, 16, KODE)


!     We are now in the body-centered system for the surface.  The
!     following code will test against an obscuration surface or
!     test for an interception with an optical surface.
!
!     NOTE that the
!                              incoming ray position, direction (15, 16)
!          is converted to the
!                              outgoing ray position, direction (17, 18)
!
!===> Now in BCS coordinates -------------------------------------------


!---- No surface reflection:  stick input ray vectors directly 
!     into output ray vectors (#17 <== #15; #18 <== #16)

      mode = kode
      xv(17) = xv(15)
      yv(17) = yv(15)
      zv(17) = zv(15)
      xv(18) = xv(16)
      yv(18) = yv(16)
      zv(18) = zv(16)

      x_incept = xv(17)
      y_incept = yv(17)
      z_incept = zv(17)


!---- handle transformation from BCS to STD ----------------------------
!
!     Now we transform everybody from BCS back to the standard coordinates
!     (STD).
!
!     Note that:
!
!        #11 = x-axis direction cosines
!        #12 = x-axis direction cosines
!        #13 = x-axis direction cosines
!
!        #14 = translation from STD origin to BCS origin
!
!     Hence, the transformation will actually be using the inverse
!     rotation matrix (actually, the transpose; the rotation matrix
!     is orthogonal).
!
!---  'derotate' new ray position, direction from BCS back to STD.
!
      CALL VDERO (17, 18,      ! ray new position, direction (in BCS)
     &            14,          ! translation vector for surface
     &            11, 12, 13,  ! rotation matrix:  STD to BCS
     &             5,  6     ) ! ray new position, direction (in STD)

CBUG  CALL VWRITE ('DER1', JING, J2, 5, 6, KODE)


!---  if ray was successful, finish polarization calculations and
!     'derotate' the polarization stuff from BCD back to STD...
!
      IF (do_osac_reflect  .and.  KODE .EQ. MODE) THEN
         CALL CSOUT (  6,      ! outgoing ray unit vector
     &                11 )     ! initial vector of rotation matrix
                               ! converting STD to BCS coord system
      ENDIF
!
!     at this point, everybody is back in the STD coordinate system.
!
!<=== Now in STD coordinates -------------------------------------------


C  BEFORE CALLING WRAD, RENORMALIZE Q3
C  (BUT NOT FOR A FLAT SURFACE)
C  (OR FOR AN OBSCURATION-TYPE SURFACE)
C  (FOR A TOROID, TRANSFORM TO THE STANDARD COORDINATE SYSTEM)

      IF (LSW (3, KURF)) GO TO 100   ! T for flat surface

      IF (LSW (5, KURF) .OR.         ! T for annular obscuration
     &    LSW (6, KURF))             ! T for rectangular obscuration
     &                   GO TO 100

      IF (LSW (8, KURF)) GO TO 90    ! T for toroidal surface

!---  evaluate 1st derivative magnitude of surface f function
      PZK = SURF (4, KURF) * ZV (17) - SURF (5, KURF)
      RNRM = 1.D0 / DSQRT (XV (17) * XV (17) + YV (17) * YV (17)
     &                                + PZK * PZK)

!---  change sign if gradient is out of surface
!     (that is true if the surface is 'convex')
      IF (LSW (1, KURF))             ! T for convex surface
     &                   RNRM = - RNRM

      DO 80 J = 1, 6
         Q3 (J) = Q0 (J) * RNRM
80    CONTINUE


C  TRANSFORM Q0 (BCS) TO Q3 (STD) SEPARATELY FOR A TOROIDAL SURFACE
!  NOTE: THE FOLLOWING 18 LINES OF CODE TO TRANSFORM Q0 TO Q3 WERE
!        PREVIOUSLY IN ERROR BY VIRTUE OF INTERCHANGING THE THIRD
!        AND FOURTH ELEMENTS OF EACH MATRIX
C
90    Q3 (1) = Q0 (1) * XV (11) * XV (11) +
     *         Q0 (3) * XV (12) * XV (12) +
     *         Q0 (6) * XV (13) * XV (13)
      Q3 (2) = Q0 (1) * XV (11) * YV (11) +
     *         Q0 (3) * XV (12) * YV (12) +
     *         Q0 (6) * XV (13) * YV (13)
      Q3 (3) = Q0 (1) * YV (11) * YV (11) +
     *         Q0 (3) * YV (12) * YV (12) +
     *         Q0 (6) * YV (13) * YV (13)
      Q3 (4) = Q0 (1) * XV (11) * ZV (11) +
     *         Q0 (3) * XV (12) * ZV (12) +
     *         Q0 (6) * XV (13) * ZV (13)
      Q3 (5) = Q0 (1) * YV (11) * ZV (11) +
     *         Q0 (3) * YV (12) * ZV (12) +
     *         Q0 (6) * YV (13) * ZV (13)
      Q3 (6) = Q0 (1) * ZV (11) * ZV (11) +
     *         Q0 (3) * ZV (12) * ZV (12) +
     *         Q0 (6) * ZV (13) * ZV (13)


!---  write out ray ----------------------------------------------------

100   continue
      CALL SAOWRAD_FOC

      RETURN

      END
