!KWIC saowrad.f
!
!$Id: saowrad.f,v 1.4 2004/07/16 18:57:46 dtn Exp $
!
!Revisions:
!   97-Oct-27 [D. Grumm]
!      . reworked ray-missed block and set ray-missed flag
!      . change call to c_write to call to the bpipe routine put_ray in 
!        osacbpipe.c
!   96-Jun-05[T. Gaetz]
!      . /SUMRY/:  add save statement; move to include file
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-12[T. Gaetz]
!      . move /raystuff/ to include file; evaluation of norm is now in
!        saotrader (and a derotation to STD is applied.)
!      . adapt to new c_read argument list
!      . posdir broken into pos, dir
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!   93-Oct-28[T. Gaetz]
!      . add fgoodrays to /raystuff/
!   93-Oct-20[T. Gaetz]
!      . change c_write argument list; argument energy removed.
!        argument g_ang now a scalar.
!      . /raystuff/:  g_ang(2) --> g_ang
!        (g_ang's arrayness now handled in c_read/c_write)
!   93-Sep-29[T. Gaetz]
!      . renamed to saowrad; change error messages to conform
!   93-Apr-09[T. Gaetz]
!      . change over to fixed version of c_write; clean up debugging
!        debris.
!   93-Apr-05[T. Gaetz]
!      . change over to implicit none;
!      . strip out commented-out statements
!      . clean up spaghetti; remove dead code.  See original WRAD
!        to see what was removed.
!   93-Apr-15[T. Gaetz]
!      . rename common /graze/ to /raystuff/; add energy, norm to common
!      . remove DATA initialization of norm(.); nonstandard, and not needed.
!
!  UPDATED 2/7/88 TO WRITE THE POLARIZATIOND DATA
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO CURE FORMAT PROBLEM FOR RAY ALONG (0,0,-1)
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  Updated 11-22-91 WAP to change output to E format to fix
!  bug in PV-WAVE
!
      SUBROUTINE SAOWRAD( pos, dir, norm_c, intersect_bcs_c,
     +                    w_c, energy_c, g_ang_c,
     +     c2comp_c, s2comp_c, jray_c, kode_c, ray_missed, outputray )

C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    WRAD FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:08:52
C    *
C    ******************************************/
C
c  write data records of ray files for SAOdrat
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN (3) : ZOFF - Z OFFSET OF FOCAL PLANE
C
C  INPUT VIA LABELED COMMON /PARX/:
C    KURF : I*4 - SURFACE NUMBER
C    NS   : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    FOP  : FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : INTEGER PORTION OF PATH LENGTH
C    JRAY : CURRENT RAY NUMBER
C    JING : CURRENT RING NUMBER
C    J2   : CURRENT SPOKE NUMBER
C    KODE : RAY STATUS CODE (SEE CHEX OUTPUT)
C    W    : RELATIVE INTENSITY OF RAY
C    Q3   : 2ND DERIVATIVE MATRIX OF SURFACE
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
C  INPUT VIA LABELED COMMON /SWITCH/ :
C    LSW (3, KURF) : FLAT SURFACE SWITCH
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#5 : POSITION OF RAY INTERSECTION
C    V#6 : DIRECTION OF RAY AFTER REFLECTION
C
C  OUTPUT VIA D#24: RAY001, VIA D#26: RAY002
C
C  XR : VFOCUS, VLINE
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT NONE
 
!---  global variables...

!---  /raystuff/
!     energy     -- ray energy
!     norm       -- surface normal
!     g_ang      -- graze angle for ray-surface intercept
!     posdir_old -- old values of ray position/direction cosine;
!                   restored in the event the ray misses the surface.
!     fgoodrays  -- 'good rays only' flag; if true, consider only
!                   rays which reflect once from each surface.

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/raystuff.h'  ! info needed for binary pipeline
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays
 
!---  local variables...

      double precision norm_c( 3 ), intersect_bcs_c( 3 )
      double precision w_c, energy_c, g_ang_c
      complex*16       c2comp_c( 2 ), s2comp_c( 2 )
      integer          jray_c, kode_c, outputray

      DOUBLE PRECISION pos(3), dir(3), path
      INTEGER          ray_missed

!CODE saowrad ----------------------------------------------------------



! The default is not to write the rays      
      outputray = 0

      ray_missed = 0
      if ( KODE .ge. 4 ) then
         if ( mod( kode, 10 ) .eq. 6 ) then
!---  (OSAC uses 10*(surface number) + 6 for 'right stop error',
            ray_missed = 1
            g_ang = -6.d0       !  DMG added 9/23
            if ( .not. fgoodrays ) then
               kode     =  2    ! reset osac kode
            endif
         else
            GO TO 20
         endif
      else                      !  DMG added 9/23 and next
         g_ang = xv(16)*xv(19) + yv(16)*yv(19) + zv(16)*zv(19)
      endif

      IF (KODE .LT. 0) GO TO 30
      IF (KODE .EQ. 0) GO TO 50

      pos(1) = XV(5)
      pos(2) = YV(5)
      pos(3) = ZV(5)
      dir(1) = XV(6)
      dir(2) = YV(6)
      dir(3) = ZV(6)

      path   = 0.d0

!xxx  !
!xxx  !---  don't let raydir(3) (z component of ray direction) be -1.000...
!xxx  
!xxx        IF (raydir(3) .EQ. -1.D0) raydir(3) = -.99999999999999

!  DON'T LET P (6) BE -1.000...
!     WRITE (24, 300) P, IOP, FOP, Q3, C2COMP, S2COMP
!
      IF (dir(3) .EQ. -1.D0) dir(3) = -.99999999999999



C     copy data to function parameters
      outputray    = 1
      norm_c( 1 )   = norm( 1 )
      norm_c( 2 )   = norm( 2 )
      norm_c( 3 )   = norm( 3 )
      intersect_bcs_c( 1 ) = x_incept
      intersect_bcs_c( 2 ) = y_incept
      intersect_bcs_c( 3 ) = z_incept
      w_c           = w
      energy_c      = energy
      g_ang_c       = g_ang
      c2comp_c( 1 ) = c2comp( 1 )
      c2comp_c( 2 ) = c2comp( 2 )
      s2comp_c( 1 ) = s2comp( 1 )
      s2comp_c( 2 ) = s2comp( 2 )
      jray_c        = jray
      kode_c        = kode

!---  update ray summary for successful ray
      WS2 = WS2 + W
      LEFT2 = LEFT2 + 1
      go to 100

20    CONTINUE
      IF (KODE .LT. 10*KURF) GO TO 70
      GO TO 40

30    CONTINUE
      IF (KODE .NE. -KURF) GO TO 70

40    CONTINUE
!---  ray failed at current surface
      JAIL2 = JAIL2 + 1
      WF2 = WF2 + W
      GO TO 70

50    CONTINUE
      WRITE (8, 500)

70    CONTINUE
CBUG  WRITE (8, 800) IOP, H, W
CBUG  WRITE (8, 800) IOP, W

100   RETURN

!---  formats...

200   FORMAT (5I10, 3F10.6)
300   FORMAT( 3E25.17 / 3E25.17, I5, F15.12, /
     1        3(F12.9,1X), 4X,
     1        3(F12.9,1X), /
     1        4(F15.9,1X) / 4(F15.9,1X))
400   FORMAT ('- RAY PARALLEL TO THE FOCAL PLANE ')
500   FORMAT ('- KODE = 0 : UNDETERMINED ERROR ')

CBUG800   FORMAT ('-SAOWRADB, IOP=', I6, 'H=',F12.6, 'W=',F10.6)
CBUG800   FORMAT ('-SAOWRADB, IOP=', I6, 'W=',F10.6)

      END
