!+
!KWIC sbuild.f
!
!$Id: sbuild.f,v 1.1 2004/03/16 15:50:08 dtn Exp $
!
!Revisions:
!   95-Feb-01[T. Gaetz]
!      . change IWK1, IWK2, PCOF to assumed-size arrays (for bounds-checking)
!-
      SUBROUTINE SBUILD (NBOT, NPOLYS, OBSC, IWK1, IWK2, PCOF)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    SBUILD FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 4/1/88
C    *
C   /******************************************/
C
C  PURPOSE: BUILD A SEQUENCE OF ORTHONORMAL POLYNOMIALS, USING A
C           GRAM-SCHMIDT PROCEDURE
C
C  INPUT PARAMETERS:
C    NBOT: I*4 - ORDER OF MONOMIAL WHICH IS PROPORTIONAL TO THE
C                FIRST POLYNOMIAL IN THE SEQUENCE
C    NPOLYS: I*4 - NUMBER OF POLYNOMIALS DESIRED IN THE SEQUENCE
C    OBSC: R*8 - LOWER LIMIT OF INTEGRATION IN THE DOT PRODUCT DEF'N
C    IWK1: I*4 - WORK ARRAY WITH A DIMENSION EQUAL TO THE LARGEST
C                NUMBER OF TERMS IN ANY OF THE POLYNOMIALS TO BE
C                DEFINED
C    IWK2: I*4 - WORK ARRAY WITH SAME DIMENSION AS IWK1
C
C  OUTPUT PARAMETERS:
C    PCOF: R*8 - ARRAY OF COEFFICIENTS DEFINING THE SEQUENCE OF
C                POLYNOMIALS.  FOR EACH POLYNOMIAL, THE COEFFICIENTS
C                ARE STORED IN DESCENDING ORDER.  THE SETS OF
C                COEFFICIENTS ARE STORED IN ASCENDING ORDER (I.E.,
C                ASCENDING IN THE OVERALL ORDER OF THE POLYNOMIALS).
C                THERE IS NO ZERO-FILL BETWEEN SETS OF COEFFICIENTS.
C                NOTE THAT THE ORDER OF EACH SUCCEEDING POLYNOMIAL
C                INCREASES BY 2, AND THAT THE ORDER OF EACH SUCCEEDING
C                TERM WITHIN A GIVEN POLYNOMIAL DECREASES BY 2.
C
C  EXTERNAL REFERENCES: POWDOT
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)
      DIMENSION IWK1 (*), IWK2 (*)
      DIMENSION PCOF (*)
      DIMENSION IPBARR (4)
      DATA IPBARR /2, 2, 2, 2/
      DATA SQRT2 /1.41421 35623 73095 04880D0/
C
C
C  ORTHONORMALIZE THE FIRST POLYNOMIAL (MONOMIAL)
C
      N2PL2 = 2 * NBOT + 2
      A = (1.D0 - OBSC * OBSC) / 2.D0
      IF (NBOT .GT. 0) A = A * 2.D0
      PCOF (1) = DSQRT (A * N2PL2 / (1.D0 - OBSC ** N2PL2))
      IF (NPOLYS .EQ. 1) GO TO 400
C
C  PERFORM A GIANT LOOP OVER THE WHOLE ORTHONORMALIZATION PROCESS,
C  SO THAT THE HIGHER ORDER POLYNOMIALS CAN BE TWEEKED TO FIGHT
C  NUMERICAL ROUNDOFF PROBLEMS
C
      DO 300 IGLOOP = 1, 3
C
C  LOOP OVER ALL POLYNOMIALS BEYOND THE FIRST (MONOMIAL)
C  (FOR SUCCESSIVE LOOPINGS THROUGH THE ORTHONORMALIZATION PROCESS,
C  ONLY THE HIGHEST ORDER POLYNOMIALS NEED TO BE TWEEKED)
C
      DO 290 IPOLY = 2, NPOLYS
C
C  FOR THE IPOLY'TH POLYNOMIAL (WITH ORDER NBOT + 2 * (IPOLY - 1)),
C  DO THE INITIALIZATION (INTIALIZE THE POLYNOMIAL TO ITS HIGHEST
C  ORDER MONOMIAL, BUT ONLY IF THIS IS THE FIRST LOOP THROUGH THE
C  ORTHONORMALIZATION PROCESS)
C
      JTOP = IPOLY - 1
      NDX0 = 1 + (IPOLY * (IPOLY - 1)) / 2
      write(*, *) 'sbuild> ndx0 ', ndx0
      IF (IGLOOP .EQ. 1) PCOF (NDX0) = 1.D0
      IWK1 (1) = NBOT + 2 * JTOP
      DO 210 J = 1, JTOP
      write(*, *) 'sbuild> j, ndx0 + j ', j, ndx0+j
      IF (IGLOOP .EQ. 1) PCOF (NDX0 + J) = 0.D0
      IWK1 (1 + J) = IWK1 (J) - 2
210   CONTINUE
      DO 260 J = 1, JTOP
C
C  FOR THE J'TH PREVIOUS ORTHONORMAL POLYNOMIAL, FIND THE DOT
C  PRODUCT - START BY FILLING IN THE J VALUES OF THE EXPONENT
C  (NOTE - STARTING INDEX IN PCOF OF THE J'TH POLYNOMIAL IS
C  NDX = 1 + (J * (J - 1)) / 2)
C
      DO 220 K = 1, J
      IWK2 (K) = NBOT + 2 * (J - K)
220   CONTINUE
C
C  FINISH THE DOT PRODUCT CALCULATION BY CALLING POWDOT
C
      NDX = 1 + (J * (J - 1)) / 2
      CALL POWDOT (PCOF (NDX0), IWK1, IPOLY,
     *             PCOF (NDX), IWK2, J, OBSC, DOTJ)
C
C  WITH THE DOT PRODUCT FOUND, REMOVE THE CORRESPONDING AMOUNT
C  OF THE PREVIOUS ORTHONORMAL POLYNOMIAL FROM THE CURRENT
C  POLYNOMIAL
C
      PROJ = DOTJ / A
      DO 240 K = 1, J
      PCOF (NDX0 + K - J + JTOP) = PCOF (NDX0 + K - J + JTOP) -
     *     PROJ * PCOF ((1 + (J * (J - 1)) / 2) + (K - 1))
240   CONTINUE
260   CONTINUE
C
C  WITH ALL THE PROJECTIONS REMOVED, ORTHONORMALIZE THE RESULTING
C  POLYNOMIAL
C
      DO 270 J = 1, IPOLY
      IWK1 (J) = NBOT + 2 * (IPOLY - J)
270   CONTINUE
      CALL POWDOT (PCOF (NDX0), IWK1, IPOLY,
     *             PCOF (NDX0), IWK1, IPOLY, OBSC, DOT0)
      CONST = DSQRT (A / DOT0)
      DO 280 J = 1, IPOLY
      PCOF (NDX0 + J - 1) = CONST * PCOF (NDX0 + J - 1)
280   CONTINUE
290   CONTINUE
300   CONTINUE
C
400   RETURN
      END
