!+
!KWIC scal.f
!
!$Id: scal.f,v 1.2 2004/03/17 21:23:42 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO DISABLE THE SINE-OF-GRAZING-ANGLE SCALE
!  FACTORS, SINCE REFLECTIVITY VARIATIONS ARE ELIMINATED, AND TO
!  SKIP THE CALCULATION IF THE SURFACE IS AN OBSCURATION
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE SCAL (IOPZ, FOPZ, Q3Z, DP0)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    SCAL FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/07/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:01:28
C    *
C    ******************************************/
C
C  PURPOSE :  CALCULATE AND OUTPUT ALL SCALE FACTOR INFORMATION
C
C  INPUT ARGUMENTS :
C     IOPZ :  ARRAY OF INTEGER PATH LENGTHS
C     FOPZ :  ARRAY OF FRACTIONAL PATH LENGTHS
C     Q3Z  :  ARRAY OF 2ND DERIVATIVE MATRICES
C     DP0  :  ARRAY OF SINS OF GRAZING ANGLES
C
C  INPUT VIA /PARX/ :
C     NS :  NUMBER OF SURFACES
C
C  INPUT VIA /SWITCH/ :
C     LSW0 (1)   :  X-RAY SYSTEM SWITCH
C     LSW (3, J) :  FLATNESS SWITCH AT SURFACE # J
C
C  OUTPUT TO SUBROUTINE WRSUB :
C     SFX     :  X-COMP OF SAGITTAL SCALE FACTOR
C     SFY     :  Y-COMP OF SAGITTAL SCALE FACTOR
C     TFX     :  X-COMP OF TANGENTIAL SCALE FACTOR
C     TFY     :  Y-COMP OF TANGENTIAL SCALE FACTOR
C     DP0 (J) :  BASELINE SIN OF GRAZING ANGLE AT SURF # J
C     DP1S    :  SAGITTAL DERIVATIVE OF SIN OF GRAZING ANGLE
C     DP1T    :  TANGENTIAL DERIVATIVE OF SIN OF GRAZING ANGLE
C     J       :  SURFACE NUMBER
C
C  XR :  ANEW, BNEW, CNEW, VCROSS, VDOT, VSTOR, VUNIT, WRSUB
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DIMENSION IOPZ (21), FOPZ (21), Q3Z (6, 21), DP0 (21),
     1  DP1S (21), DP1T (21)
      DOUBLE PRECISION VDOT
      DOUBLE PRECISION FOPZ, RNRM, PL, PLPRE, PLNOW
C
C
C  LOOP ONCE FOR EACH SURFACE
      DO 700 J = 1, NS
!
!  SKIP ALL OF THIS IF THE SURFACE IS AN OBSCURATION
!
      IF (LSW (5, J) .OR. LSW (6, J)) GO TO 700
!
C
C  INITIALIZE A AND B MATRICES TO ZERO AND IDENTITY
      CALL VSTOR (1, 0.D0, 0.D0, 0.D0)
      CALL VSTOR (2, 0.D0, 0.D0, 0.D0)
      CALL VSTOR (3, 0.D0, 0.D0, 0.D0)
      CALL VSTOR (4, 1.D0, 0.D0, 0.D0)
      CALL VSTOR (5, 0.D0, 1.D0, 0.D0)
      CALL VSTOR (6, 0.D0, 0.D0, 1.D0)
C
C  SET UP SAGITTAL, TANGENTIAL UNIT VECTORS IN V# 29, 30
C
C  IS THE SURFACE FLAT?
      IF (LSW (3, J)) GO TO 200
C  NO, SET UP S-HAT AND T-HAT
C  SET INDEX OF REFLECTED RAY
      NS1 = J + NDIM + 32
C  IS THE INCOMING RAY NORMAL TO THE SURFACE?
      IF (DP0 (J) .GT. .9999) GO TO 140
C  NO, SET NS0 AS TRUE INDEX OF INCIDENT RAY
      NS0 = NS1 - 1
      GO TO 160
C  YES, DERIVE ARBITRARY S-HAT
140   NS0 = 7
      CALL VSTOR (NS0, 1.D0, 0.D0, 0.D0)
      DP = VDOT (NS0, NS1)
      IF (ABS (DP) .LT. .9999) GO TO 160
      CALL VSTOR (NS0, 0.D0, 1.D0, 0.D0)
C  NS0 VECTOR NOW DEFINITELY NON-PARALLEL TO NS1 VECTOR
160   CALL VCROSS (NS1, NS0, 29)
      CALL VUNIT (29, 29, RNRM)
      CALL VCROSS (NS1, 29, 30)
      GO TO 220
C
C  SURFACE IS FLAT - GET S-HAT AND T-HAT FROM Q3 MATRIX
200   XV (29) = Q3Z (1, J)
      YV (29) = Q3Z (2, J)
      ZV (29) = Q3Z (3, J)
      XV (30) = Q3Z (4, J)
      YV (30) = Q3Z (5, J)
      ZV (30) = Q3Z (6, J)
C
C  SUB-LOOP THROUGH EACH SUBSEQUENT SURFACE TO UPDATE A, B, C
220   KBOT = J + 1
      KTOP = NS + 1
      PLPRE = FOPZ (J) + IOPZ (J)
      DO 600 K = KBOT, KTOP
C  BE SURE THIS SURF IS EITHER FOCAL PLANE, OR NON-FLAT
      IF (K .EQ. KTOP) GO TO 300
      IF (LSW (3, K)) GO TO 600
C  SURF IS OK, UPDATE THE PATH LENGTH, PAST AND PRESENT
300   PLNOW = FOPZ (K) + IOPZ (K)
      PL = PLNOW - PLPRE
      PLPRE = PLNOW
C  UPDATE THE A MATRIX
      CALL ANEW (K, PL)
C  IF SURF # K ISN'T THE FOCAL PLANE, UPDATE B MATRIX AND C VECTOR
      IF (K .EQ. KTOP) GO TO 600
      CALL BNEW (Q3Z, K)
!
!C  IF THIS IS AN X-RAY SYSTEM, UPDATE C VECTOR
!      IF (.NOT. LSW0 (1)) GO TO 600
!      CALL CNEW (K)
!      DP1S (K - 1) = VDOT (28, 29)
!      DP1T (K - 1) = VDOT (28, 30)
!
600   CONTINUE
C  EVALUATE AND OUTPUT FINAL SCALE FACTOR INFORMATION
      SFX = VDOT (1, 29)
      SFY = VDOT (2, 29)
      TFX = VDOT (1, 30)
      TFY = VDOT (2, 30)
      CALL WRSUB (SFX, SFY, TFX, TFY, DP0 (J), DP1S, DP1T, J)
700   CONTINUE
      RETURN
      END
