!+
!KWIC snsin.f
!
!$Id: snsin.f,v 1.2 2004/03/17 21:23:42 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /SENS/   for alignment; add save stmt; move to include file
!-
      SUBROUTINE SNSIN (RPUPIL)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    SNSIN FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: READ AND CHECK THE SENSITIVITY (.SNS) FILE
C
C  INPUT VIA FILE #3 (SENSITIVITY, OR .SNS FILE):
C    DFID: 64-CHARACTER ID TEXT
C    NDF: I*4 - NUMBER OF ZERNIKE'S USED IN CHARACTERIZING THE
C               EFFECTS OF THE CHANGES
C    ROBSC: R*8 - INNER PUPIL RADIUS
C    RPUPIL: R*8 - OUTER PUPIL RADIUS (ROBSC AND RPUPIL ARE USED
C                  TO DEFINE THE ANNULAR ZERNIKE POLYNOMIALS)
C    NCH: I*4 - NUMBER OF CONSTRUCTIONAL CHANGES BEING CONSIDERED
C    ICHS (J): I*4 -
C         ARRAY OF INTEGERS DENOTING WHICH CONSTRUCTIONAL
C         PARAMETER TO VARY FOR THE J'TH DESIRED CHANGE.
C         CHANGES ARE EITHER TO GI FILE PARAMETERS (WHICH
C         ARE DEFINED WITH PARAMETER NUMBERS CALLED 'ITN' -
C         SEE OSAC DOCUMENTATION), OR TO DEFORM FILE
C         PARAMETERS (WHICH ARE DEFINED WITH ZERNIKE
C         COEFFICIENT NUMBER 'IDF').  THE TYPE AND NUMBER
C         OF THE DESIRED CHANGE CAN BE GATHERED FROM THE
C         ICHS ELEMENT AS FOLLOWS:
C       1-99:     ICHS = (SYSTEM) ITN NUMBER
C       .GT. 100: ICHS / 100 = SURFACE NUMBER
C                 MOD (ICHS, 100) = (SURFACE) ITN NUMBER
C       .LT. 0:   (- ICHS) / 100 = SURFACE NUMBER
C                 MOD ((- ICHS), 100) = IDF NUMBER
C    SNSMAT (I, J): R*8 -
C         CHANGE IN THE I'TH ANNULAR ZERNIKE POLYNOMIAL COEFFICIENT
C         FOR A UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE
C         PARAMETER.  SNSMAT (1, J) = 0.D0, SINCE PISTON IS ALWAYS
C         THROWN AWAY.
C    XBFSNS (J): R*8 -
C         CHANGE IN X-COORDINATE OF THE BEST FOCUS LOCATION FOR A
C         UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE PARAMETER.
C    YBFSNS (J): R*8 -
C         CHANGE IN Y-COORDINATE OF THE BEST FOCUS LOCATION FOR A
C         UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE PARAMETER.
C
C  OUTPUT PARAMETER:
C    RPUPIL: R*8 - PUPIL OUTER RADIUS
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...

      DATA NCHMAX /50/
C
C
C  READ AND CHECK THE ID TEXT
C
      READ (3, 7000, END = 2000, ERR = 2010) DFID
C
C  READ AND CHECK THE NUMBER OF POLYNOMIALS AND PUPIL DIMENSIONS
C
      READ (3, *, END = 2000, ERR = 2010) NDF, ROBSC, RPUPIL
      IF (NDF .LT. 3 .OR. ROBSC .LT. 0.D0 .OR. RPUPIL .LE. ROBSC)
     *   GO TO 2020
      OBSC = ROBSC / RPUPIL
C
C  READ THE DEFINING CONSTRUCTIONAL CHANGES
C
      READ (3, *, END = 2000, ERR = 2010) NCH
      IF (NCH .LT. 1 .OR. NCH .GT. NCHMAX) GO TO 2030
      READ (3, *, END = 2000, ERR = 2010) (ICHS (J), J = 1, NCH)
C
C  READ THE CORRESPONDING SENSITIVITY MATRIX ELEMENTS
C
      DO 120 J = 1, NCH
      READ (3, *, END = 2000, ERR = 2010) (SNSMAT (I, J), I = 1, NDF)
120   CONTINUE
      READ (3, *, END = 2000, ERR = 2010) (XBFSNS (J), J = 1, NCH)
      READ (3, *, END = 2000, ERR = 2010) (YBFSNS (J), J = 1, NCH)
      RETURN
C
2000  continue
      CALL INCLIN (1)
      WRITE (8, 8000)
      STOP 8
2010  continue
      CALL INCLIN (1)
      WRITE (8, 8010)
      STOP 8
2020  continue
      CALL INCLIN (2)
      WRITE (8, 8020) NDF, ROBSC, RPUPIL
      STOP 8
2030  continue
      CALL INCLIN (1)
      WRITE (8, 8030) NCH
      STOP 8
C
7000  FORMAT (16A4)
8000  FORMAT ('  SNSIN FATAL ERROR - EOF READING SNS FILE')
8010  FORMAT ('  SNSIN FATAL ERROR - ERROR READING SNS FILE')
8020  FORMAT ('  SNSIN FATAL ERROR IN SNS FILE PARAMETERS:' /
     *        '        (NDF, ROBSC, RPUPIL) =', I6, 1P,2D12.4)
8030  FORMAT ('  SNSIN FATAL ERROR: NCH =', I6,
     *        ' (1 .LE. NCH .LE. 50)')
      END
