!+
!KWIC strehl.f
!
!$Id: strehl.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:   add save statement; move to include file
!      . /SUMRY/:  add save statement; move to include file
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO CURE FORMAT PROBLEM FOR RAY ALONG (0,0,-1)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED 2/26/88 TO OUTPUT ATTENUATED E-FIELD AMPLITUDES
!  VIA C2COMP AND S2COMP
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE STREHL (IER, STRFAC)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    STREHL FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 09/23/81
C    *
C    *    UPDATE:   02/05/82
C    *    TIME:     10:57:05
C    *
C    ******************************************/
C
C  WRITE A RECORD TO THE STREHL-ATTENUATED RAY FILE
C
C  INPUT PARAMETERS :
C    IER    : I*4 - 0 = SUCCESSFUL RAY
C                   1 = UNSUCCESSFUL RAY
C                   2 = NO RAYS LEFT
C    STRFAC : R*4 - STREHL ATTENUATION FACTOR FOR SPECULAR RAY
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /RAIN/ :
C    FOP  : R*8 - FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : I*4 - INTEGER    PORTION OF PATH LENGTH
C    JRAY : I*4 - CURRENT RAY NUMBER
C    JING : I*4 - CURRENT RING NUMBER
C    J2   : I*4 - CURRENT SPOKE NUMBERBER OF CURRENT RAY IN CURRENT RING
C    KODE : I*4 - RAY STATUS CODE
C    Q3   : R*4 - NORMALIZED 2ND DERIVATIVE SURFACE MATRIX
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, /ZCOMP/ :
C    V # 5, 6 : POSITION AND DIRECTION OF RAY AT FOCAL PLANE
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZW (NS) : RAY WEIGHT AT FINAL SURFACE
C
C  OUTPUT VIA # 2 :
C    OUTPUT FOR ONE RAY ONTO 'ARAY' (ATTENUATED RAY) FILE
C
C  OUTPUT VIA LABELED COMMON /SUMRY/ :
C    AQ    : R*8 - (VIA VFOCUS) FOCUS INFORMATION
C    WS1   : R*8 - SUM OF WEIGHTS OF UNATTENUATED RAYS AT F.P
C    WS2   : R*8 - SUM OF WEIGHTS OF ATTENUATED RAYS AT F.P.
C    LEFT2 : I*4 - NUMBER OF SUCCESSFUL RAYS AT F.P.
C
C  XR : TRALAY, VFOCUS
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      DIMENSION DUM3 (3)
      DATA DUM3 /3 * 0./
C
      IF (IER .EQ. 2) GO TO 200
C
C  NOT TIME FOR THE TRAILER RECORD YET
      IN10 = 0
      IF (IER .NE. 0) GO TO 150
C  (IF RAY IS SUCCESSFUL, DO VFOCUS, WRITE OTHER LINES, UPDATE LEFT2)
      WS1 = WS1 + ZW (NS)
      DELW = ZW (NS) * STRFAC
!
!  ATTENUATE C2COMP AND S2COMP BY THE SQRT OF STRFAC
!
      STRSQR = DSQRT (STRFAC)
      DO 140 ICOMP = 1, 2
      C2COMP (ICOMP) = C2COMP (ICOMP) * STRSQR
      S2COMP (ICOMP) = S2COMP (ICOMP) * STRSQR
140   CONTINUE
!
      WS2 = WS2 + DELW
      IN10 = 1.0E8 * DELW + 0.5
150   WRITE (7, 8000) JRAY, JING, J2, KODE, IN10, DUM3
      IF (IER .NE. 0) GO TO 900
      CALL VFOCUS (5, 6, DELW, AQ)
      LEFT2 = LEFT2 + 1
!  (ALSO WRITE C2COMP AND S2COMP)
!  DON'T LET ZV (6) BE -1.000...
!     WRITE (7, 8010) XV (5), YV (5), ZV (5),
!    1                XV (6), YV (6), ZV (6), IOP, FOP, DUM3, DUM3,
!    *                C2COMP, S2COMP
!
      IF (ZV (6) .NE. -1.D0)
     *  WRITE (7, 8010) XV (5), YV (5), ZV (5),
     *                  XV (6), YV (6), ZV (6), IOP, FOP, DUM3, DUM3,
     *                  C2COMP, S2COMP
      IF (ZV (6) .EQ. -1.D0)
     *  WRITE (7, 8011) XV (5), YV (5), ZV (5),
     *                  XV (6), YV (6), IOP, FOP, DUM3, DUM3,
     *                  C2COMP, S2COMP
      GO TO 900
C
C  TIME FOR TRAILER RECORD
200   CALL TRALAY (7, JRAY, 0, LEFT2, 0.D0, WS2)
      WRITE (7, 8020) AQ
C
900   RETURN
C
8000  FORMAT (5I10, 3F10.6)
!  (ALSO WRITE C2COMP AND S2COMP)
!  8010  FORMAT (1P, 3D25.17 / 3F20.17, I5, F15.12 / 3F12.9, 4X, 3F12.9)
8010  FORMAT (1P,3D25.17 / 3F20.17, I5, F15.12 / 3F12.9, 4X, 3F12.9 /
     1        4F15.9 / 4F15.9)
8011  FORMAT (1P,3D25.17 / 2F20.17, '-9.99999999999999999',
     *                             I5, F15.12 / 3F12.9, 4X, 3F12.9 /
     1        4F15.9 / 4F15.9)
8020  FORMAT (1P, 2 (4D20.12 /), 2D20.12)
      END
