!+
!KWIC sxfrm.f
!
!$Id: sxfrm.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO ADD EXPONENTIAL-EXPONENTIAL, EXPONENTIAL-
!        !  GAUSSIAN, AND GAUSSIAN-GAUSSIAN AUTOCOVARIANCE FUNCTIONS, WITH
!        !  EVERY TERM BEING MULTIPLIED BY A COSINE
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!        !
!        !  UPDATED 4/13/94 TO ADD AUTOCOVARIANCE FUNCTION FOR MODIFIED
!        !  LORENTZIAN PSD (METHOD 110)
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-

      FUNCTION SXFRM (FX, FY)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    SXFRM FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 02/20/88
C    *
C   /******************************************/
C
C  PURPOSE: FIND THE FOURIER TRANSFORM (AT A GIVEN FREQUENCY) OF
C           THE FINAL SCATTER HALO FOR THE CURRENT RAY
C
C  INPUT PARAMETERS:
C    FX: R*8 - FREQUENCY X-COMPONENT
C    FY: R*8 - FREQUENCY Y-COMPONENT
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    NS   : I*4 - NUMBER OF SURFACES IN SYSTEM
C
C  INPUT VIA LABELED COMMON /PARAMS/ :
C    ZK : R*4 - SYSTEM WAVENUMBER
C    ZW (I) : R*4 - ARRAY OF RAY WEIGHTS
C    DP0 (I) : ARRAY OF SINS OF GRAZING ANGLES
C    SFX,SFY,TFX,TFY (I) : ARRAYS OF SUSEQ SCALE FACTORS
C    METARR (I) : ARRAY OF SCATTERING METHOD NUMBERS
C
C  INPUT VIA LABELED COMMON /SDEFCO/ :
C    SDEF (I, J) : R*4 - ARRAY OF SCATTER DEFINITION PARAMETERS
C
C  INPUT VIA LABELED COMMON /TABLES/ :
C    SIGSQ (1 TO 3, J) : R*4 - VALUES OF SIGMA**2 FOR EACH
C                              SCATTER PROCESS 1 TO 3
C
C  OUTPUT PARAMETER :
C    SFXRM: R*8 - THE FOURIER TRANSFORM OF THE SCATTER AT (FX, FY)
C
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N)
 
      DIMENSION BK (8)

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      COMMON /PARAMS/ ZLAM, ZK, ZW (21), DP0 (21),
     1  DP1S (210), DP1T (210), SFX (21), SFY (21), TFX (21), TFY (21),
     2  METARR (21)
      COMMON /SDEFCO/ SDEF (20, 1)
      COMMON /TABLES/ FOGR (6), V2TAB (801, 5), GTAB (800, 5),
     1  GTAB1 (800, 5), GTAB2 (800, 5), GTAB3 (800, 5),
     2  STHTAB (801), REFTAB (800), VZSTAB (101), FVSTAB (100),
     3  SIGSQ (3, 5), GR0 (3, 5), ACCG, ACCR, ACCF, METSYS (8)

      double precision PI2
      parameter      ( PI2 = 6.28318 53071 79586 47692D0 )
C
C
C  DEFINE THE PREVIOUS {RAY (R), SCATTER XFRM (S), AND WEIGHT (W)}
C  AS FOR A PERFECTLY SPECULAR, UNIT WEIGHT RAY ENTERING THE SYSTEM
C
      RPRE = 1.D0
      SPRE = 0.D0
      WPRE = 1.D0
C
C  LOOP OVER ALL THE SURFACES
C
      DO 200 I = 1, NS
      KURF = I
C
C  SKIP THE SURFACE IF THERE IS NO SCATTER
C
      REFLSQ = ZW (KURF) / WPRE
      SRI = REFLSQ
      S0I = 0.D0
      METH = METARR (KURF)
      IF (METH .EQ. 0) GO TO 180
C
C  DEFINE (VZ**2 * SIGMA**2) FOR THE CURRENT SURFACE
C
      NSYS = SDEF (1, METH)
      CTH = DP0 (KURF)
      VZSQ = 4.D0 * ZK * ZK * CTH * CTH
!
!  USE A DIFFERENT APPROACH TO GET SIGMA**2
!      SGSQ = SDEF (2, METH)
!      IF (NSYS .EQ. 5) SGSQ = SGSQ + SDEF (4, METH)
!
      SGSQ = SIGSQ (1, METH) + SIGSQ (2, METH) + SIGSQ (3, METH)
      VZSSQ = VZSQ * SGSQ
C
C  CHANGE THE (FX, FY) COORDINATES TO THE PROPER ACV ARGUMENTS
C
      X = (ZLAM / CTH) * (TFX (KURF) * FX + TFY (KURF) * FY)
      Y = - ZLAM * (SFX (KURF) * FX + SFY (KURF) * FY)
C
C  EVALUATE G (X, Y)
C
      RSQ = X * X + Y * Y
C  (DOUBLE EXPONENTIAL AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 5) THEN
        R = DSQRT (RSQ)
        GXY = 0.D0
        IF ((SDEF (2, METH) / SGSQ) .GE. 1.D-8) THEN
          EXPA1 = 0.D0
          A1 = SDEF (3, METH) * R
          IF (A1 .LT. 40.D0) EXPA1 = DEXP (- A1)
          GXY = SDEF (2, METH) * EXPA1
        ENDIF
        IF ((SDEF (4, METH) / SGSQ) .GE. 1.D-8) THEN
          EXPA2 = 0.D0
          A2 = SDEF (5, METH) * R
          IF (A2 .LT. 40.D0) EXPA2 = DEXP (- A2)
          GXY = GXY + SDEF (4, METH) * EXPA2
        ENDIF
        GO TO 220
      ENDIF
C  (SINGLE GAUSSIAN AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 6) THEN
        EXPARG = 0.D0
        ARG = SDEF (3, METH) * RSQ
        IF (ARG .LT. 40.D0) EXPARG = DEXP (- ARG)
        GXY = SDEF (2, METH) * EXPARG
        GO TO 220
      ENDIF
C  (DOUBLE EXPONENTIAL-COSINE AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 9) THEN
        R = DSQRT (RSQ)
        GXY = 0.D0
        IF ((SDEF (2, METH) / SGSQ) .GE. 1.D-8) THEN
          EXPA1 = 0.D0
          A1 = SDEF (3, METH) * R
          IF (A1 .LT. 40.D0) EXPA1 = DEXP (- A1)
          GXY = SDEF (2, METH) * EXPA1 * DCOS (SDEF (4, METH) * R)
        ENDIF
        IF ((SDEF (5, METH) / SGSQ) .GE. 1.D-8) THEN
          EXPA2 = 0.D0
          A2 = SDEF (6, METH) * R
          IF (A2 .LT. 40.D0) EXPA2 = DEXP (- A2)
          GXY = GXY + SDEF (5, METH) * EXPA2 * DCOS (SDEF (7, METH) * R)
        ENDIF
        GO TO 220
      ENDIF
C  (EXPONENTIAL-COSINE / GAUSSIAN-COSINE AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 10) THEN
        R = DSQRT (RSQ)
        GXY = 0.D0
        IF ((SDEF (2, METH) / SGSQ) .GE. 1.D-8) THEN
          EXPA1 = 0.D0
          A1 = SDEF (3, METH) * R
          IF (A1 .LT. 40.D0) EXPA1 = DEXP (- A1)
          GXY = SDEF (2, METH) * EXPA1 * DCOS (SDEF (4, METH) * R)
        ENDIF
        IF ((SDEF (5, METH) / SGSQ) .GE. 1.D-8) THEN
          EXPA2 = 0.D0
          A2 = SDEF (6, METH) * RSQ
          IF (A2 .LT. 40.D0) EXPA2 = DEXP (- A2)
          GXY = GXY + SDEF (5, METH) * EXPA2 * DCOS (SDEF (7, METH) * R)
        ENDIF
        GO TO 220
      ENDIF
C  (DOUBLE GAUSSIAN-COSINE AUTOCOVARIANCE FUNCTION)
      IF (NSYS .EQ. 11) THEN
        R = DSQRT (RSQ)
        GXY = 0.D0
        IF ((SDEF (2, METH) / SGSQ) .GE. 1.D-8) THEN
          EXPA1 = 0.D0
          A1 = SDEF (3, METH) * RSQ
          IF (A1 .LT. 40.D0) EXPA1 = DEXP (- A1)
          GXY = SDEF (2, METH) * EXPA1 * DCOS (SDEF (4, METH) * R)
        ENDIF
        IF ((SDEF (5, METH) / SGSQ) .GE. 1.D-8) THEN
          EXPA2 = 0.D0
          A2 = SDEF (6, METH) * RSQ
          IF (A2 .LT. 40.D0) EXPA2 = DEXP (- A2)
          GXY = GXY + SDEF (5, METH) * EXPA2 * DCOS (SDEF (7, METH) * R)
        ENDIF
        GO TO 220
      ENDIF
C  (AUTOCOVARIANCE FUNCTION FOR MODIFIED LORENTZIAN PSD)
      IF (NSYS .EQ. 12) THEN
        R = DSQRT (RSQ)
        F0 = SDEF (4, METH)
        Z = PI2 * F0 * R
        IF (Z .LT. 1.D-6) THEN
          GXY = SDEF (2, METH)
          GO TO 220
        ENDIF
        IF (Z .GT. 60.D0) THEN
          GXY = 0.D0
          GO TO 220
        ENDIF
        B = SDEF (3, METH)
        DNU = B / 2.D0 - 1.D0
        NIN = 1 + IDINT (DNU)
        XNU = DMOD (DNU, 1.D0)
        CALL DBESKS (XNU, Z, NIN, BK)
        GXY = SDEF (2, METH) * 2.D0 ** (1.D0 - DNU) *
     *        Z ** DNU * BK (NIN) / DGAMMA (DNU)
        GO TO 220
      ENDIF
C
C  EVALUATE EXP (-VZ**2*SIG**2 + VZ**2*G(X,Y)) - EXP (-VZ**2*SIG**2)
C
220   EXPA1 = 0.D0
      A1 = VZSSQ - VZSQ * GXY
      IF (A1 .LT. 40.D0) EXPA1 = DEXP (- A1)
      EXPA2 = 0.D0
      IF (VZSSQ .LT. 40.D0) EXPA2 = DEXP (- VZSSQ)
C
C  MULTIPLY THE TERMS OUT TO GET S0 AT THE CURRENT SURFACE
C
      S0I = REFLSQ * (EXPA1 - EXPA2)
C
C  DEFINE SR, THE PRODUCT OF THIS SURFACE'S STREHL RATIO AND REFL
C
      SRI = EXPA2 * REFLSQ
C
C  UPDATE THE RAY AND THE SCATTER AT THE CURRENT SURFACE
C
180   RI = RPRE * SRI
      SI = SPRE * (SRI + S0I) + RPRE * S0I
      RPRE = RI
      SPRE = SI
      WPRE = ZW (KURF)
200   CONTINUE
C
C  THE FINAL ANSWER IS THE SCATTER (TRANSFORM) AT THE LAST SURFACE
C
      SXFRM = SI
      RETURN
      END
