!+
!KWIC vazeld.f
!
!$Id: vazeld.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /SWITCH/: add save statement; move to include file
!      . initialize RAD, SQRT as parameter
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-
!
!  UPDATED TO INITIALIZE POLARIZATION ANGULAR DATA
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
      SUBROUTINE VAZELD (AZ, EL, LD)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VAZELD FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   06/06/80
C    *    TIME:     11:11:31
C    *
C    ******************************************/
C
C  AZIMUTH & ELEVATION TO DIRECTION COSINES
C
C  INPUT ARGUMENTS:
C    AZ   : R*8 AZIMUTH ANGLE (DEG.)
C    EL   : R*8 ELEVATION ANGLE (DEG.)
C    LD   : IV# FOR DIRECTION COSINES
C
C  INPUT VIA /PARM/:
C    GEN ( 5) : PSI - POLARIZATION MAJOR AXIS ANGLE (WAS EP1)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 6) : E - RATIO OF MINOR TO MAJOR AXIS AMPLITUDE (WAS EP2)
C               (ABS VALUE BETWEEN 0 AND 1)
C               (POSITIVE FOR LEFT HANDED, NEGATIVE FOR RIGHT HANDED)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C
C  INPUT VIA /SWITCH/:
C    LSW0 (4) : F - RANDOM POLARIZATION, T - DISCRETE POLARIZATION
C
C  OUTPUT VIA /PLRZ/:
C    CPSI : R*8 - COSINE OF PSI (MAJOR AXIS ANGULAR POSITION)
C    SPSI : R*8 - SINE OF PSI
C    SQRE : R*8 - SQRT (1 + E**2) (OR SQRT (2) FOR RANDOM PLRZTION)
C
C  OUTPUT VIA /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#LD := DIRECTION COSINES
C
      IMPLICIT  DOUBLE PRECISION (A-H, O-Z), INTEGER*4 (I-N)

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /PLRZ/ CPSI, SPSI, SQRE
      real * 8    RAD
      parameter ( RAD = 17.45329 25199 43296 D-03 )
      real * 8    SQRT2
      parameter ( SQRT2 = 1.41421 35623 73095 04880D0 )
C
      CA = DCOS (AZ * RAD)
      CE = DCOS (EL * RAD)
      SA = DSIN (AZ * RAD)
      SE = DSIN (EL * RAD)
C
C  STORE Z DIRECTION
      XV (LD) = SA * CE
      YV (LD) = SE
      ZV (LD) = CA * CE
!
!  ADD SECTION TO INITIALIZE THE POLARIZATION DATA
      IF (LSW0 (4)) GO TO 20
C  (RANDOM POLARIZATION)
      CPSI = 1.D0
      SPSI = 0.D0
      SQRE = SQRT2
      GO TO 30
C  (DISCRETE POLARIZATION)
20    CPSI = DCOS (GEN (5) * RAD)
      SPSI = DSIN (GEN (5) * RAD)
      SQRE = DSQRT (1.D0 + GEN (6) ** 2)
C
30    RETURN
      END
