!+
!KWIC vcross.f
!
!$Id: vcross.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . change to IMPLICIT NONE
!-
      SUBROUTINE VCROSS (JV, KV, LV)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    VCROSS FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 01/23/81
C    *
C    *    UPDATE:   05/07/81
C    *    TIME:     15:32:53
C    *
C    ******************************************/
C
C  CROSS (VECTOR) PRODUCT OF TWO VECTORS
C
C  INPUT ARGUMENTS :
C    JV:  IV# FIRST VECTOR
C    KV:  IV# SECOND VECTOR
C
C  OUTPUT :
C    IV# LV IS (IV# JV CROSS IV# KV)
C
      IMPLICIT NONE

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER JV, KV, LV

      XV (LV) = YV (JV) * ZV (KV) - YV (KV) * ZV (JV)
      YV (LV) = ZV (JV) * XV (KV) - ZV (KV) * XV (JV)
      ZV (LV) = XV (JV) * YV (KV) - XV (KV) * YV (JV)
      RETURN
      END
