!
!KWIC vflect.f
!
!$Id: vflect.f,v 1.2 2004/03/17 21:23:43 dtn Exp $
! *Revisions:
!   96-Jun-05[T. Gaetz]
!      . /RAIN/:   add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Dec-05[T. Gaetz]
!      . move ray unitization into branches of if (to avoid goto 50
!        from being a branch into a block do)
!      . change 50 write(6, ...) to 50 write(8, ...)
!      . add /raystuff/; add optional branch around ray reflection
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . eliminate Q, WLOSS - not used
!-
!
!  UPDATED 2/4/88 TO PERFORM COMPLETE POLARIZATION CALCULATIONS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO ROUND INTENSITY TO AGREE WITH OUTPUT VALUE
!  (OVERCOMES NABRAT/DRAT DIFFERENCES DUE TO GETTING W FROM RAY FILES)
!  PAUL GLENN, BAUER ASSOCIATES, IN.C
!
      SUBROUTINE VFLECT (IN, iNORM, KAY)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VFLECT FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 03/26/80
C    *
C    *    UPDATE:   11/04/80
C    *    TIME:     16:22:21
C    *
C    ******************************************/
C
C  REFLECT A RAY AT A SURFACE &  UPDATE ITS INTENSITY (W)
C
C  INPUT ARGUMENTS:
C  IN    : IV# OF DIRECTION COSINES OF ENTERING RAY
C  iNORM  : IV# OF OUTER iNORMAL TO SURFACE
C  KAY   : IV# DESIRED FOR DIRECTION OF EXITING RAY
C
C  INPUT VIA LABELED COMMON /PARX/:
C    KURF : I*4 - SURFACE NUMBER
C
C  INPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    THE VECTORS IN LOCATIONS IN AND iNORM
C
C  INPUT VIA LABELED COMMON /RAIN/:
C    W    : R*4  RELATIVE INTENSITY (WEIGHT) OF RAY
C
C  INPUT VIA LABELED COMMON /PARM/:
C    SURF (14,KURF) : EP1 - REAL PART OF DIELECTRIC CONSTANT
C    SURF (15,KURF) : EP2 - IMAGINARY PART OF DIELECTRIC CONSTANT
C
C  INPUT VIA LABELED COMMON /PRLZ/:
C    CPSI : R*8 - COSINE OF PSI (MAJOR AXIS ANGULAR POSITION)
C    SPSI : R*8 - SINE OF PSI
C    SQRE : R*8 - SQRT (1 + E**2) (OR SQRT (2) FOR RANDOM PLRZTION)
C
C  INPUT/OUTPUT VIA LABELED COMMON /RAIN/:
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    LSW0 (4) : F - RANDOM POLARIZATION, T - DISCRETE POLARIZATION
C
C  OUTPUT VIA LABELED COMMON /XCOMP/, /YCOMP/, AND /ZCOMP/:
C    THE VECTOR IN LOCATION KAY
C
C  OUTPUT VIA /RAIN/:
C    W : UPDATED WEIGHT
C
C  EXTERNAL REFERENCES: PZREFL
C
C  METHOD : (KAY) = (IN) - 2 ((IN) . (iNORM) / (iNORM) ** 2) (iNORM)
C
      IMPLICIT DOUBLE PRECISION  (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/rain.h'      !
      include 'saosacLib/raystuff.h'  ! info needed for binary pipeline
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      COMMON /PLRZ/ CPSI, SPSI, SQRE
!  COMPLEX VARIABLES CHANGED TO COMPLEX*16
      COMPLEX*16 YS, RPLUS, RMINUS, AC
      DOUBLE PRECISION ST, CTSQ

!dbg      write( 90, 9000 ) ' '
!dbg      write( 90, *    ) 'vflect> __a1_ ', kode, in, kay
!dbg      write( 90, 9000 ) 'vflect> __b1_ ', xv(in),yv(in),zv(in)
!dbg      write( 90, 9000 ) 'vflect> __c1_ ', xv(kay),yv(kay),zv(kay)
C
      if ( .not. do_osac_reflect ) then  ! don't handle reflection

!---     UNITIZE NORMAL

         H = XV (iNORM) ** 2 + YV (iNORM) ** 2 + ZV (iNORM) ** 2
         if (H .LE. 0.0D0) then
            WRITE (8, 500) IN, iNORM, KAY, H, 
     &                     XV(iNORM), YV(iNORM), ZV(iNORM)
            KODE = 0
         else
            H = 1.0D0 / DSQRT (H)
            XV (iNORM) = XV (iNORM) * H
            YV (iNORM) = YV (iNORM) * H
            ZV (iNORM) = ZV (iNORM) * H
         endif
C
!---     transfer in direction vector to out direction vector...

         XV (KAY) = XV (IN)
         YV (KAY) = YV (IN)
         ZV (KAY) = ZV (IN)

      else                          ! OSAC does the reflection...

!---     UNITIZE NORMAL

         H = XV (iNORM) ** 2 + YV (iNORM) ** 2 + ZV (iNORM) ** 2
         IF (H .LE. 0.0D0) GO TO 50
         H = 1.0D0 / DSQRT (H)
         XV (iNORM) = XV (iNORM) * H
         YV (iNORM) = YV (iNORM) * H
         ZV (iNORM) = ZV (iNORM) * H

C     SG : SIN GRAZING ANGLE
C
         SG = XV(IN) * XV(iNORM) + YV(IN) * YV(iNORM) + 
     1        ZV(IN) * ZV(iNORM)
         H = SG + SG
C
         XV (KAY) = XV (IN) - H * XV (iNORM)
         YV (KAY) = YV (IN) - H * YV (iNORM)
         ZV (KAY) = ZV (IN) - H * ZV (iNORM)
C
C     OBTAIN DIELECTRIC CONSTANT
!     (IN DOUBLE PRECISION)
!
         YS = DCMPLX (SURF(14,KURF), SURF(15,KURF))
         ST = DABS(SG)
         CTSQ = 1. - ST * ST
         AC = CDSQRT (YS - CTSQ)
         RPLUS = (YS * ST - AC) / (YS * ST + AC)
         RMINUS = (ST - AC) / (ST + AC)
!
!     MODIFY THE COMPLEX AMPLITUDE VECTORS
!
         ! write( 91, * ) 'vflect: do_osac_reflect> ', do_osac_reflect
         ! if ( do_osac_reflect ) then
            CALL PZREFL (IN, iNORM, KAY, RPLUS, RMINUS)
         ! else
         !    CALL PZREFL_new(IN, iNORM, KAY, RPLUS, RMINUS)
         ! endif
!
!     COMPUTE THE INTENSITY FROM THE MODIFIED AMPLITUDE VECTORS
!
         W = 0.D0
         DO 42 I = 100, 103
         W = W + VDOT (I, I)
42       CONTINUE
         IF (LSW0 (4)) W = W + VDOT (101, 102) - VDOT (100, 103)
         GO TO 60
C
50       WRITE (8, 500) IN, iNORM, KAY, H, XV(iNORM), YV(iNORM),
     1                  ZV(iNORM)
         KODE = 0
C
!        MAKE W AGREE WITH ITS INTEGER-EQUIVALENT OUTPUT VALUE
!60         RETURN
60       IN10 = 1.0E8 * W + 0.5
         W = 1.D-8 * IN10

      endif

!dbg      write( 90, 9000 ) ' '
!dbg      write( 90, 9000 ) ' '
!dbg      write( 90, *    ) 'vflect> __a2_ ', kode, in, kay
!dbg      write( 90, 9000 ) 'vflect> __b2_ ', xv(in),yv(in),zv(in)
!dbg      write( 90, 9000 ) 'vflect> __c2_ ', xv(kay),yv(kay),zv(kay)
!dbg9000  format( a, tr1, 1p, 4e20.12 )

      RETURN
!
500   FORMAT ('- VFLECT ERROR : H =< 0 - IN = ', I10, ' iNORM = ', I10,
     1    /,' KAY = ', I10, ' H = ', 1P,D15.6, ' XV = ', 1P,D15.6, /,
     2     ' YV = ',1P,D15.6, ' ZV = ', 1P,D15.6)
      END
