!+
!KWIC vline.f
!
!$Id: vline.f,v 1.2 2004/03/17 21:23:44 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . switch to IMPLICIT NONE
!-

      SUBROUTINE VLINE (IN, D, L, IX)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VLINE FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 06/03/80
C    *
C    *    UPDATE:   06/05/80
C    *    TIME:     11:38:43
C    *
C    ******************************************/
C
C  LOCATE A POINT ON A LINE
C
C  INPUT ARGUMENTS
C    IN    : IV# STARTING POINT
C    D     : R*8 DISTANCE OF TRAVEL ALONG LINE
C    L     : IV# DIRECTION COSINES OF LINE
C    IX    : IV# FOR LOCATED POINT
C
C    INPUT VIA /XCOMP/, /YCOMP/, & /ZCOMP/
C    V# IN & L
C
C    OUTPUT VIA /XCOMP/, /YCOMP/, & /ZCOMP/
C    V# IX
C
C  METHOD:  V#IX = V#IN + D * V#L
C
      IMPLICIT NONE
C
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION D
      INTEGER          IX, IN, L

      XV(IX) = XV(IN) + D * XV(L)
      YV(IX) = YV(IN) + D * YV(L)
      ZV(IX) = ZV(IN) + D * ZV(L)
      RETURN
      END
