!+
!KWIC vortho.f
!
!$Id: vortho.f,v 1.2 2004/03/17 21:23:44 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 5/17/89 TO INCLUDE AN ANGLE ABOUT THE Z-AXIS FOR
!        !  NON-SYMMETRIC SURFACES SUCH AS TOROIDS
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . switch to IMPLICIT NONE
!      . switch RAD initialization to PARAMETER statement
!-
      SUBROUTINE VORTHO (AZ, EL, ZROT8, I, J, K)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VORTHO FORTRAN
C    *    WRITTEN BY H. JACKSON  M/S 180  X (203) 762-4395
C    *            ON 05/21/80
C    *
C    *    UPDATE:   06/06/80
C    *    TIME:     09:43:14
C    *
C    ******************************************/
C
C  AZIMUTH AND ELEVATION AND Z-ROTATION TO SET OF ORTHONORMAL AXES
C
C  CONVENTION: ASSUME THAT A MATRIX IS MADE UP OF A SERIES OF THREE
C              ROW VECTORS (EACH THREE-LONG).  THIS ROUTINE GENERATES
C              A MATRIX WITH ROWS I,J,K.  (THIS IS THE CONVENITON
C              FOLLOWED BY THE OSAC ROUTINES MMULT AND MVEC.)  THE
C              MATRIX GENERATED BY THIS ROUTINE DOES THE OPPOSITE
C              OF WHAT THE ORIGINAL RIGID BODY MOTION DID TO THE BODY
C              CENTERED COORDINATE SYSTEM.  IN OTHER WORDS, IT DOES
C              WHAT IS REQUIRED TO A LOCATION OR DIRECTION TO TRANSFORM
C              IT FROM STD TO BCS.  SO, SINCE THE ORIGINAL RIGID BODY
C              MOTION CONSISTED OF A Z-ROTATION FOLLOWED BY AN
C              ELEVATION FOLLOWED BY AN AZIMUTH CHANGE, THIS MATRIX
C              CONSISTS OF A NEGATIVE AZIMUTH CHANGE FOLLOWED BY A
C              NEGATIVE ELEVATION FOLLOWED BY A NEGATIVE Z-ROTATION.
C
C  INPUT ARGUMENTS:
C    AZ   : R*8 AZIMUTH ANGLE (DEG.)
C    EL   : R*8 ELEVATION ANGLE (DEG.)
C    ZROT8: R*8 Z-ROTATION ANGLE (DEG.)
C    I    : I*4 IV# DESIRED FOR NEW X AXIS WRT STANDARD
C    J    : I*4 IV# DESIRED FOR NEW Y AXIS WRT STANDARD
C    K    : I*4 IV# DESIRED FOR NEW Z AXIS WRT STANDARD
C
C  OUTPUT VIA /XCOMP/, /YCOMP/, /ZCOMP/:
C    V#I = DIRECTION COSINES OF NEW X AXIS WRT STANDARD
C    V#J = DIRECTION COSINES OF NEW Y AXIS WRT STANDARD
C    V#K = DIRECTION COSINES OF NEW Z AXIS WRT STANDARD
C
      IMPLICIT NONE

      DOUBLE PRECISION RAD
      PARAMETER      ( RAD = .0174532925199433D0 )

      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DOUBLE PRECISION AZ, EL, ZROT8
      INTEGER          I, J, K

      DOUBLE PRECISION E, A, CE, SE, SA, CA, CZ, SZ, Z

      A = AZ * RAD
      E = EL * RAD
      Z = ZROT8 * RAD
      CE =  DCOS (E)
      SE =  DSIN (E)
      CA =  DCOS (A)
      SA =  DSIN (A)
      CZ =  DCOS (Z)
      SZ =  DSIN (Z)
C
      XV (I) = CZ * CA - SZ * SE * SA
      YV (I) = SZ * CE
      ZV (I) = - CZ * SA - SZ * SE * CA
C
      XV (J) = - SZ * CA - CZ * SE * SA
      YV (J) = CZ * CE
      ZV (J) = SZ * SA - CZ * SE * CA
C
      XV (K) = CE * SA
      YV (K) = SE
      ZV (K) = CE * CA
      RETURN
      END
