!+
!KWIC vrot8.f
!
!$Id: vrot8.f,v 1.2 2004/03/17 21:23:44 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!      . switch to IMPLICIT NONE
!-

      SUBROUTINE VROT8 (IP, IDC, JO, IX, JY, KZ, JP, JDC)
C   /****************************************
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    VROT8 FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 06/05/80
C    *
C    *    UPDATE:   08/19/80
C    *    TIME:     10:39:10
C    *
C    ******************************************/
C  PURPOSE : TRANSLATE VECTOR IP BY VECTOR JO
C   THEN ROTATE IP AND IDC ACCORDING TO NEW COORDINATE AXES IX JY KZ
C   PUTTING THE RESULTS IN JP JDC
C  PGM D. HARRIS 03/20/79
C
C  INPUT ARGUMENTS:
C  IP  : VECTOR LOCATION FOR RAY POSITION
C  IDC : VECTOR LOCATION FOR RAY DIRECTION COSINES
C  JO  : VECTOR LOCATION FOR TRANSLATION
C  IX  : VECTOR LOCATION FOR X-AXIS DIRECTION COSINES
C  JY  : VECTOR LOCATION FOR Y-AXIS DIRECTION COSINES
C  KZ  : VECTOR LOCATION FOR Z-AXIS DIRECTION COSINES
C  JP  : VECTOR LOCATION FOR NEW RAY POSITION
C  JDC : VECTOR LOCATION FOR NEW RAY DIRECTION COSINES
C
C  INPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C  THE VECTORS IN LOCATIONS IP, IDC, JO, IX, IY, AND KZ
C
C  OUTPUT VIA /XCOMP/, /YCOMP/, AND /ZCOMP/:
C  THE VECTORS IN LOCATIONS: JP AND JDC
C
C  NOTE : IT IS PERMISSIBLE FOR JP = IP AND FOR JDC = IDC
C
      IMPLICIT NONE
C
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      INTEGER          IP, IDC, JO, IX, JY, KZ, JP, JDC
      DOUBLE PRECISION X, Y, Z

C
C   TRANSLATE POSITION VECTOR
C
      X = XV (IP) - XV (JO)
      Y = YV (IP) - YV (JO)
      Z = ZV (IP) - ZV (JO)
C
C   ROTATE POSITION
C
      XV (JP) = XV (IX) * X + YV (IX) * Y + ZV (IX) * Z
      YV (JP) = XV (JY) * X + YV (JY) * Y + ZV (JY) * Z
      ZV (JP) = XV (KZ) * X + YV (KZ) * Y + ZV (KZ) * Z
C
C  TRANSFER DIRECTION
C
      X = XV(IDC)
      Y = YV(IDC)
      Z = ZV(IDC)
C
C   ROTATE DIRECTION
C
      XV (JDC) = XV(IX) * X + YV(IX) * Y + ZV(IX) * Z
      YV (JDC) = XV(JY) * X + YV(JY) * Y + ZV(JY) * Z
      ZV (JDC) = XV(KZ) * X + YV(KZ) * Y + ZV(KZ) * Z
C
      RETURN
      END
