!+
!KWIC wf2sum.f
!
!$Id: wf2sum.f,v 1.2 2004/03/17 21:23:45 dtn Exp $
!
!Revisions:
!   95-Oct-10[T. Gaetz]
!      . eliminate output to unit 6
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /SENS/   for alignment; add save stmt; move to include file
!-

      SUBROUTINE WF2SUM (RPUPIL)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    WF2SUM FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: WRITE A SUMMARY REPORT FOR WFSNS2 TO UNITS 6 AND 8
C
C  INPUT PARAMETERS:
C    RPUPIL: R*8 - PUPIL OUTER RADIUS
C
C  INPUT VIA LABELED COMMON /DEFORM/:
C    NDF: I*4 - NUMBER OF ZERNIKE'S USED IN CHARACTERIZING THE
C               EFFECTS OF THE CHANGES
C    OBSC: R*8 - LINEAR OBSCURATION RATIO
C
C  INPUT VIA LABELED COMMON /SENS/:
C    NCH: I*4 - NUMBER OF CONSTRUCTIONAL CHANGES BEING CONSIDERED
C    CHGS (J): R*8 - AMOUNT BY WHICH TO VARY THE J'TH CONSTRUCTIONAL
C                    CHANGE PARAMETER.
C    ICHS (J): I*4 -
C         ARRAY OF INTEGERS DENOTING WHICH CONSTRUCTIONAL
C         PARAMETER TO VARY FOR THE J'TH DESIRED CHANGE.
C         CHANGES ARE EITHER TO GI FILE PARAMETERS (WHICH
C         ARE DEFINED WITH PARAMETER NUMBERS CALLED 'ITN' -
C         SEE OSAC DOCUMENTATION), OR TO DEFORM FILE
C         PARAMETERS (WHICH ARE DEFINED WITH ZERNIKE
C         COEFFICIENT NUMBER 'IDF').  THE TYPE AND NUMBER
C         OF THE DESIRED CHANGE CAN BE GATHERED FROM THE
C         ICHS ELEMENT AS FOLLOWS:
C       1-99:     ICHS = (SYSTEM) ITN NUMBER
C       .GT. 100: ICHS / 100 = SURFACE NUMBER
C                 MOD (ICHS, 100) = (SURFACE) ITN NUMBER
C       .LT. 0:   (- ICHS) / 100 = SURFACE NUMBER
C                 MOD ((- ICHS), 100) = IDF NUMBER
C    SNSMAT (I, J): R*8 -
C         CHANGE IN THE I'TH ANNULAR ZERNIKE POLYNOMIAL COEFFICIENT
C         FOR A UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE
C         PARAMETER.  SNSMAT (1, J) = 0.D0, SINCE PISTON IS ALWAYS
C         THROWN AWAY.
C    XBFSNS (J): R*8 -
C         CHANGE IN X-COORDINATE OF THE BEST FOCUS LOCATION FOR A
C         UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE PARAMETER.
C    YBFSNS (J): R*8 -
C         CHANGE IN Y-COORDINATE OF THE BEST FOCUS LOCATION FOR A
C         UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE PARAMETER.
C
C  OUTPUT VIA FILE #'S 6 AND 8:
C    SUMMARY REPORTS
C
C  EXTERNAL REFERENCES: INCLIN
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...

C
C
C  DISPLAY THE PUPIL INFORMATION
C
      CALL INCLIN (4)
      WRITE (8, 8000) NDF, RPUPIL, OBSC
C
C  DISPLAY THE INCREMENTAL CONSTRUCTIONAL CHANGES AND THE
C  CORRESPONDING RMS WAVEFRONT CHANGE SENSITIVITIES AND CENTROID
C  DISPLACEMENT SENSITIVITIES
C
      CALL INCLIN (5)
      WRITE (8, 8010) NCH
      DO 160 ICH = 1, NCH
      IABSCH = IABS (ICHS (ICH))
      KURF = IABSCH / 100
      ITNIDF = MOD (IABSCH, 100)
      IF (ICHS (ICH) .LT. 0) ITNIDF = - ITNIDF
      RMSWF = 0.D0
      IF (NDF .LT. 4) GO TO 160
      DO 140 IDF = 4, NDF
      RMSWF = RMSWF + SNSMAT (IDF, ICH) ** 2
140   CONTINUE
      RMSWF = DSQRT (RMSWF)
      CALL INCLIN (1)
      WRITE (8, 8020) ICH, KURF, ITNIDF, CHGS (ICH), RMSWF,
     *                XBFSNS (ICH), YBFSNS (ICH)
160   CONTINUE
C
C  WRITE A MORE DETAILED SENSITIVITY REPORT TO UNIT 8 ONLY
C
      NLINES = (NDF + 4) / 5
      DO 200 ICH = 1, NCH
      CALL INCLIN (2)
      WRITE (8, 8030) ICH
      DO 180 ILINE = 1, NLINES
      IDBOT = 5 * ILINE - 4
      IDTOP = MIN0 (IDBOT + 4, NDF)
      CALL INCLIN (1)
      WRITE (8, 8040) (SNSMAT (IDF, ICH), IDF = IDBOT, IDTOP)
180   CONTINUE
200   CONTINUE
      RETURN
C
8000  FORMAT (/ '  NUMBER OF ZERNIKE POLYNOMIALS:', I4 /
     *          '  PUPIL OUTER RADIUS:           ', 1P,D14.6 /
     *          '  LINEAR OBSCURATION RATIO:     ', 0P,F10.6)
8010  FORMAT (/ '  NUMBER OF CONSTRUCTIONAL CHANGES:', I4 /
     *          '                                           ',
     *          '* SENSITIVITIES TO UNIT CHANGES *' /
     *          '  CHANGE  SURF #    PARAM #    INCRMNTL    ',
     *          'RMS WVFRNT   CENTROID SENSITIVITY' /
     *          '  NUMBER  (0: SYS)  (-: POLY)  CHANGE      ',
     *          'SNS (NP>3)   DELTA-X     DELTA-Y')
8020  FORMAT (I6, I8, I10, 1P,D17.4, 1P,3D12.4)
8030  FORMAT (/ '  DETAILED ZERNIKE COEFFICIENT SENSITIVITIES',
     *          ' TO CHANGE NO.', I3, ':')
8040  FORMAT (1X, 1P,5D15.7)
      END
