!+
!KWIC wrgi.f
!
!$Id: wrgi.f,v 1.2 2004/03/17 21:23:45 dtn Exp $
!
!Revisions:
!   96-Jun-05[T. Gaetz]
!      . /IDENT/:  add save statement; move to include file
!      . /SWITCH/: add save statement; move to include file
!   95-Mar-21[T. Gaetz]
!      . /PARM/:  add save statement; move to include file
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . initialize ONE with PARAMETER
!-

      SUBROUTINE WRGI
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    WRGI FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: WRITE A COMPLETE GI FILE TO UNIT 3
C
C  INPUT VIA LABELED COMMON /IDENT/:
C    GID (1 TO 16) : 64 CHARACTER GEOMETRY IDENTIFICATION RECORD
C
C  INPUT VIA LABELED COMMON /PARM/:
C    GEN : SYSTEM PARAMETERS
C    SURF : SURFACE PARAMETERS
C
C  INPUT VIA LABELED COMMON /PARX/:
C    NS : I*4 - ACTUAL NUMBER OF SURFACES
C
C  INPUT VIA LABELED COMMON /SWITCH/:
C    LSW0 : GENERAL SYSTEM SWITCHES
C    LSW : SURFACE SWITCHES
C
C  OUTPUT VIA FILE #3:
C    GI FILE
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N)

      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)
      include 'saosacLib/parm.h'      ! gen(.), surf(.,.)
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw

      DOUBLE PRECISION ONE
      PARAMETER      ( ONE = 1.D0 )
C
C
C  WRITE THE ID LINE
C
      WRITE (3, 8000) GID
C
C  WRITE THE SYSTEM PARAMETERS
C
      ITY = 0
      DO 120 ITN = 1, 20
      WRITE (3, 8010) ITY, ITN, GEN (ITN)
120   CONTINUE
C
C  WRITE THE SYSTEM FLAGS
C
      DO 140 I = 1, 10
      IF (.NOT. LSW0 (I)) GO TO 140
      ITN = I + 20
      WRITE (3, 8010) ITY, ITN, ONE
140   CONTINUE
C
C  WRITE THE SURFACE PARAMETERS
C
      DO 200 ITY = 1, NS
      DO 160 ITN = 1, 20
      WRITE (3, 8010) ITY, ITN, SURF (ITN, ITY)
160   CONTINUE
C
C  WRITE THE SYSTEM FLAGS
C
      DO 180 I = 1, 10
      IF (.NOT. LSW (I, ITY)) GO TO 180
      ITN = I + 20
      WRITE (3, 8010) ITY, ITN, ONE
180   CONTINUE
200   CONTINUE
C
C  WRITE THE TRAILER
C
      WRITE (3, 8020)
      RETURN
C
8000  FORMAT (16A4)
8010  FORMAT (6X, 2I3, 1P,D23.15)
8020  FORMAT ('       -1  0      0.0')
      END
