!+
!KWIC anew.f
!
!$Id: anew.f,v 1.2 2004/03/17 21:23:30 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!-

      SUBROUTINE ANEW (J, PL)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    ANEW FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/04/81
C    *
C    *    UPDATE:   11/10/81
C    *    TIME:     11:54:57
C    *
C    ******************************************/
C
C  INPUT ARGUMENTS :
C     J  :  SURFACE # AT WHICH TO UPDATE THE A MATRIX
C     PL :  PATH LENGTH FROM PREVIOUS SURFACE TO CURRENT SURFACE
C
C  INPUT VIA /PARX/ :
C     NDIM : NUMBER OF SURFACES ALLOWED FOR
C
C  OUTPUT :
C     VIA V# (1, 2, 3): THE UPDATED A MATRIX ROWS
C
C  XR :  MADD, MMULT, MOUT, VDOT
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      DOUBLE PRECISION PL
      INTEGER          J

      DOUBLE PRECISION VDOT

C  DEFINE INDECES FOR INITIAL RAY AND NORMAL VECTOR
      NS0 = J + NDIM + 31
      NNORM = NS0 + NDIM + 2
C
C  PERFORM ALL CALCULATIONS
      CALL MADD (1, 4, 10, 1.D0, PL)
      CALL MOUT (NS0, NNORM, 13)
      CALL MMULT (13, 10, 16)
      CON2 = - 1.D0 / VDOT (NS0, NNORM)
      CALL MADD (10, 16, 1, 1.D0, CON2)
      RETURN
      END
