!+
!KWIC azint.f
!
!$Id: azint.f,v 1.2 2004/03/17 21:23:31 dtn Exp $
!
!Revisions:
!   95-Jan-20[T. Gaetz]
!      . add OSAC V7.0 modification:
!        !  UPDATED 3/28/90 TO CONVERT COMPLEX * 8 TO COMPLEX * 16
!        !  PAUL GLENN, BAUER ASSOCIATES, INC.
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . change DPI, DPI2 initialization to PARAMETER
!-

      SUBROUTINE AZINT (X, Y, CINTGL)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    AZINT FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5768
C    *            ON 12/04/81
C    *
C    *    UPDATE:   01/23/82
C    *    TIME:     18:19:23
C    *
C    ******************************************/
C
C  PERFORM THE AZIMUTHAL INTEGRATION OF THE RADIAL FFT'S
C
C  INPUT PARAMETERS :
C    X   : R*4 - X COORD OF PIXEL RELATIVE TO REF SPHERE
C    Y   : R*4 - Y COORD OF PIXEL RELATIVE TO REF SPHERE
C    FFT : COMPLEX*8 - ARRAY OF RADIAL FOURIER TRANSFORMS
C
C  OUTPUT PARAMETER :
C    CINTGL : COMPLEX*16 - RESULT OF THE AZIMUTHAL INTEGRATION
C
C  INPUT VIA LABELED COMMON /PARX/ :
C    M2 : I*4 - NUMBER OF SPOKES
C
C  INPUT VIA LABELED COMMON /FFTCO/ :
C    FFT (I, J) : COMPLEX*8 - FFT ARRAY FOR SPOKE NUMBER J
C
C  INPUT VIA LABELED COMMON /IOPRAM/ :
C    WMAX : R*4 - MAXIMUM DISTANCE BETWEEN BEST FOCUS, AND CORNERS OF FP
C    NN   : I*4 - NUMBER OF POINTS IN FFT ARRAYS
C
C  INPUT VIA LABELED COMMON /TVECTR/ :
C  IF I = SPOKE NUMBER,
C    THETA0 (I) : R*4 - AZIMUTHAL ANGLE OF START OF SPOKE REGION
C    IMODE (I)  : I*4 - INTERPOLATION MODE  1 = CONSTANT IN THETA
C                                           2 = LINEAR IN THETA
C                                           3 = QUADRATIC IN THETA
C    I1 (I)     : I*4 - SPOKE NUMBER FOR 1ST INTERPOLATION THETA
C    I2 (I)     : I*4 - SPOKE NUMBER FOR 2ND INTERPOLATION THETA
C    I3 (I)     : I*4 - SPOKE NUMBER FOR 3RD INTERPOLATION THETA
C    ITFLG (I)  : LOGICAL*1 - .TRUE.  = SOME GOOD RAYS IN SPOKE
C                             .FALSE. = NO GOOD RAYS IN SPOKE
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 
C
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      COMMON /FFTCO/ FFT (512, 1)
      COMMON /IOPRAM/ FOGR (6), ZLAM, EFL, RA, RB, WMAX, NX, NY, MM, NN
      COMMON /TVECTR/ THETA0 (20), IMODE (20), I1 (20), I2 (20),
     1                I3 (20), ITFLG (20)
      DOUBLE PRECISION     FOGR, THETA0
      DOUBLE PRECISION     DELTH, SDEL, CDEL, TS2, TSSQ2
      DOUBLE PRECISION     T0, SINT, COST, TBAS, SINOLD, THDEL,
     1                     TSTART, TSPOKE
      COMPLEX * 16 FFT
      COMPLEX * 16 A0, A1, A2, B0, B1, B2, C0, C1, C2
      COMPLEX * 16 AA, AB, BA, BB, CA, CB, F21, F22, F23
      COMPLEX * 16 DVAL, DINTGL
!
!      COMPLEX * 8  CINTGL
!
      COMPLEX * 16 CINTGL
      LOGICAL * 1  ITFLG
      DOUBLE PRECISION DPI
      PARAMETER      ( DPI = 3.14159 26535 89793 24D0 )
      DOUBLE PRECISION DPI2
      PARAMETER      ( DPI2 = 2.d0 * DPI )

C
C  INITIALIZE VARIABLES
      DINTGL = (0.D0, 0.D0)
      CON1 = 0.5 * (NN - 2.)
      CON0 = CON1 + 1.
      CONX = X * CON1 / WMAX
      CONY = Y * CON1 / WMAX
      RHO = SQRT (X * X + Y * Y)
      TSPOKE = DPI2 / M2
      K1BOLD = 0
      N1OLD = 0
C
C  SEE IF POINT TOO CLOSE TO THE BEST FOCUS POINT
      IF (ABS (RHO) .LT. 1.D-30) GO TO 120  !*** WAS D-60 ON IBM
      DTH0 = WMAX / (CON1 * RHO)
      NIN = IDINT (0.5D0 * TSPOKE / DTH0)
      NIN = NIN + NIN + 2
      DELTH = TSPOKE / NIN
      GO TO 140
120   NIN = 2
      DELTH = 0.5D0 * TSPOKE
C
C  SET TRIG QUANTITIES
140   SDEL = DSIN (DELTH)
      CDEL = DCOS (DELTH)
      TS2 = TSPOKE + TSPOKE
      TSSQ2 = TSPOKE * TSPOKE
      TSSQ2 = TSSQ2 + TSSQ2
      T0 = -0.5D0 * TSPOKE - DELTH
      SINT = DSIN (T0)
      COST = DCOS (T0)
      TSTART = -1.5D0 * TSPOKE
C
C  LOOP OVER EACH SPOKE
      DO 900 J = 1, M2
      TSTART = TSTART + TSPOKE
      IF (.NOT. ITFLG (J)) GO TO 800
C
C  PERFORM INTEGRATION OVER THETA
      N1 = I1 (J)
      N2 = I2 (J)
      N3 = I3 (J)
      NMODE = IMODE (J)
      TBAS = THETA0 (J)
      IF (J .LT. N1) TBAS = TBAS - DPI2
      IADD = -1
C
C  LOOP OVER THETA SUB-INCREMENTS FOR THIS SPOKE
      DO 700  N = 1, NIN
C
C  UPDATE TRIG QUANTITIES
      T0 = T0 + DELTH
      SINOLD = SINT
      SINT = SINT * CDEL + COST * SDEL
      COST = COST * CDEL - SINOLD * SDEL
C
C  DEFINE K FOR INTERPOLATION, DEFINE NEW COEFFICIENTS IF NECESSARY
      RK1 = CON0 + CONX * COST + CONY * SINT
      K1BAS = 2 * INT (0.5 * RK1 + 0.5) - 1
      IF (K1BAS .EQ. K1BOLD .AND. N1 .EQ. N1OLD) GO TO 410
C
C  DEFINE COEFFICIENTS FOR CONSTANT INTERPOLATION IN THETA
      C0 = FFT (K1BAS, N1)
      F21 = FFT (K1BAS + 1, N1)
      A0 = 0.5D0 * (C0 - F21 - F21 + FFT (K1BAS + 2, N1))
      B0 = A0 + C0 - F21
      GO TO (400, 320, 330), NMODE
C
C  DEFINE COEFFICIENTS FOR LINEAR INTERPOLATION IN THETA
320   CA = FFT (K1BAS, N2)
      F22 = FFT (K1BAS + 1, N2)
      AA = 0.5D0 * (CA - F22 - F22 + FFT (K1BAS + 2, N2))
      BA = AA + CA - F22
      A1 = (AA - A0) / TSPOKE
      B1 = (BA - B0) / TSPOKE
      C1 = (CA - C0) / TSPOKE
      GO TO 400
C
C  DEFINE COEFFICIENTS FOR QUADRATIC INTERPOLATION IN THETA
330   CA = FFT (K1BAS, N2)
      F22 = FFT (K1BAS + 1, N2)
      AA = 0.5D0 * (CA - F22 - F22 + FFT (K1BAS + 2, N2))
      BA = AA + CA - F22
      CB = FFT (K1BAS, N3)
      F23 = FFT (K1BAS + 1, N3)
      AB = 0.5D0 * (CB - F23 - F23 + FFT (K1BAS + 2, N3))
      BB = AB + CB - F23
      A1 = (4.D0 * AA - AB - 3.D0 * A0) / TS2
      A2 = (AB - AA - AA + A0) / TSSQ2
      B1 = (4.D0 * BA - BB - 3.D0 * B0) / TS2
      B2 = (BB - BA - BA + B0) / TSSQ2
      C1 = (4.D0 * CA - CB - 3.D0 * C0) / TS2
      C2 = (CB - CA - CA + C0) / TSSQ2
C
400   K1BOLD = K1BAS
      N1OLD = N1
C
C  INTERPOLATE TO GET VALUE
410   RK1DEL = RK1 - K1BAS
      RK1DSQ = RK1DEL * RK1DEL
      GO TO (440, 450, 460), NMODE
C
C  CONSTANT INTERPOLATION IN THETA
440   DVAL = A0 * RK1DSQ - B0 * RK1DEL + C0
      GO TO 500
C
C  LINEAR INTERPOLATION IN THETA
450   DVAL = A0 * RK1DSQ - B0 * RK1DEL + C0
     1    + (A1 * RK1DSQ - B1 * RK1DEL + C1) * (T0 - TBAS)
      GO TO 500
C
C  QUADRATIC INTERPOLATION IN THETA
460   THDEL = T0 - TBAS
      THDSQ = THDEL * THDEL
      DVAL = A0 * RK1DSQ - B0 * RK1DEL + C0
     1    + (A1 * RK1DSQ - B1 * RK1DEL + C1) * THDEL
     2    + (A2 * RK1DSQ - B2 * RK1DEL + C2) * THDSQ
C
C  UPDATE INTEGRAL WITH PROPER WEIGHT
500   DINTGL = DINTGL + DVAL
      IF (IADD .EQ. -1) GO TO 520
      DINTGL = DINTGL + DVAL
      IADD = -1
      GO TO 700
520   IADD = 1
700   CONTINUE
      GO TO 900
C
C  REDEFINE CONSTANT PARAMETERS FOR ILLEGITIMATE SPOKE
800   T0 = TSTART + TSPOKE - DELTH
      SINT = DSIN (T0)
      COST = DCOS (T0)
900   CONTINUE
C
C  APPLY PROPER NORMALIZATION TO FINAL ANSWER
      CINTGL = 0.66666667D0 * DELTH * DINTGL
      RETURN
      END
