*+
*KWIC block002.h
*
*$Id: block002.h,v 1.3 2004/03/17 21:23:31 dtn Exp $
*
*Revisions:
*   97-May-29 [D. Grumm]
*     .Replaced logical switch lsw(10,*) specifying coefficient type with 
*      dfm_type which takes a value of 1 (spline), 0 (Legendre-Fourier), 
*      or 2 (both types, spline coefficients read first). 
*     . for 2nd deformation, added: fnm2_dfm, theta02, dfm2_scale
*     . change RTIME to CHARACTER*(8)
*   96-Jun-05[T. Gaetz]
*      . /COMIC/:  add save statement; move to include file
*      . /IDENT/:  add save statement; move to include file
*      . /RAIN/:   add save statement; move to include file
*      . /SUMRY/:  add save statement; move to include file
*      . /SWITCH/: add save statement; move to include file
*   95-Nov-15[T. Gaetz]
*      . reformat GLIM and SLIM initialization; change lower limit of
*        SLIM(3) to be 1.0D-6 (to allow optic at negative z)
*   95-Jan-27[T. Gaetz]
*      . add OSAC V7.0 mods:
*        !  UPDATED 5/17/89 TO ADD COMMENTS AND VARIABLES FOR FINITE SOURCE
*        !  UPDATED 5/9/88 TO ADD COMMENTS AND VARIABLES FOR TOROIDAL SURFACES
*        !  PAUL GLENN, BAUER ASSOCIATES, INC.
*        !
*        !  UPDATED 4/1/91 TO CHANGE THE X-RAY FLAG FROM A SYSTEM FLAG
*        !  TO A SURFACE FLAG, SO THAT X-RAY AND CONVENTIONAL SURFACES
*        !  CAN BE COMBINED
*        !  PAUL GLENN, BAUER ASSOCIATES, INC.
*   94-Jan-27[T. Gaetz]
*      . slightly collapse data statement to reduce number of continuations
*   93-Oct-20[T. Gaetz]
*      . rename block002.f to block002.h; move to include directory
*   93-Oct-15[T. Gaetz]
*      . add documentation for global variables; remove nonstandard
*        duplication of dimensioning information; make 'magic'
*        dimensioning numbers into named constants.
*        [for consistency with spline_eval and read_spl]
*   93-Oct-01[T. Gaetz]
*      . remove IMPLICIT NONE (to avoid duplication)
*   93-Apr-14[T. Gaetz]
*      . add IMPLICIT NONE
*      . explicit declaration of all variable types...
*-
!
!  UPDATED 1/20/88 TO CHANGE DATA VALUES OF 1.D60 TO 1.D30
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 1/22/88 TO ADD COMMENTS FOR OBSCURATION-TYPE SURFACES
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 2/4/88 TO ADD COMMENTS AND VARIABLES FOR MODIFIED
!  REFLECTIVITY DEFINITIONS AND CALCULATIONS
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
!  UPDATED 5/9/88 TO ADD COMMENTS AND VARIABLES FOR FINITE SOURCE
!  DISTANCE, FOR ANNULAR (I.E., OBSCURED) ZERNIKE POLYNOMIALS, AND
!  FOR OPD SENSITIVITY CALCULATIONS, AND TO MAKE DFID CHARACTER*4
!  PAUL GLENN, BAUER ASSOCIATES, INC.
!
C      BLOCK DATA
C   /******************************************/
C    *
C    *    PERKIN-ELMER CORPORATE COMPUTING
C    *      SOFTWARE ENGINEERING SECTION
C    *
C    *    OSACBL FORTRAN
C    *    WRITTEN BY JOHN LEGG
C    *            ON 04/02/80
C    *
C    *    UPDATE:   11/30/81
C    *    TIME:     13:22:51
C    *
C    ******************************************/
C
C  PURPOSES:
C    1 - INITIALIZE GENERAL SYSTEM INFORMATION AND
C        SURFACE VARIABLES TO THEIR DEFAULT VALUES
C    2 - SET LIMITS FOR THE DATA INPUT FROM THE GEOMETRY FILE
C    3 - PROVIDE FOR 21 OPTICAL SURFACES IN DIMENSION STATEMENTS
C
C  /AXOFF/ VARIABLES INITIALIZED:
C    CB : R*4 - COS (BETA) WHERE BETA IS THE BORESIGHT ANGLE, OR
!               COS (ZROT8) WHERE ZROT8 IS THE RECT OBSC ROT ANGLE OR
!                                 THE TOROIDAL ROTATION ANGLE
C    CE : R*4 - CB * PHIL WHERE PHIL IS THE SCALING FACTOR = 1 / R2S
C    SB : R*4 - SIN (BETA), OR
!               SIN (ZROT8)
C    SE : R*4 - SB * PHIL
C    YEP: R*4 - Y COORD. OF EPICENTER
C
C  /COMIC/ VARIABLES INITIALIZED:
C    XD   : R*8 - X COORD. OF INTERSECTION OF RAY WITH SURFACE
C    YD   : R*8 - Y COORD. OF INTERSECTION OF RAY WITH SURFACE
C    ZD   : R*8 - Z COORD. OF INTERSECTION OF RAY WITH SURFACE
C    XL   : R*8 - DIRECTION COSINE WRT X AXIS
C    YL   : R*8 - DIRECTION COSINE WRT Y AXIS
C    ZL   : R*8 - DIRECTION COSINE WRT Z AXIS
C    XG   : R*8 - X COMPONENT OF GRADIENT OF SURFACE AT (XD,YD,ZD)
C    YG   : R*8 - Y COMPONENT OF GRADIENT OF SURFACE AT (XD,YD,ZD)
C    ZG   : R*8 - Z COMPONENT OF GRADIENT OF SURFACE AT (XD,YD,ZD)
C    PHIL : R*4 - 2/L FOR X-RAY SYSTEM, 1/R2S FOR CONVENTIONAL SYSTEM
C
C  /DEFORM/ VARIABLES INITIALIZED:
C    NLEG  : I*4 - NUMBER OF LEGENDRE DEFORMATION COEFFICIENTS
C    NFOUR : I*4 - NUMBER OF FOURIER DEFORMATION COEFFICIENTS
C    NDF   : I*4 - NUMBER OF DEFORMATION COEFFICIENTS
C    DEFT  : R*4 - SQUARE ROOT OF THE SUM OF THE SQUARES
C                  OF DEFORMATION COEFFICIENTS
C    DEF2  : R*4 - SUM OF THE SQUARES OF DEFORMATION COEFFCIENTS
C    DEFC  : 500*R*4 - THE DEFORMATION COEFFICIENTS
!  FOLLOWING /DEFORM/ PARAMETERS ADDED 5/9/88 FOR ANNULAR ZERNIKE'S
C    IWK1  : I*4 - 13-LONG WORK ARRAY FOR ZERNIKE BUILDING
C    IWK2  : I*4 - 13-LONG WORK ARRAY FOR ZERNIKE BUILDING
C    NDXARR : I*4 - 25x25 ARRAY FOR ACCESSING COFMAT ELEMENTS
C    NNDX   : I*4 - DATA ITEM SPECIFYING DIMENSION OF NDXARR
C    COFMAT : R*8 - 819-LONG ARRAY OF DEFINING ZERNIKE COEFFICIENTS
C    OBSC  : R*8 - LINEAR OBSCURATION RATIO
C    (IWK1 THROUGH COFMAT ARE DIMENSIONED FOR 325 ZERNIKE'S)
C
C  /IDENT/ VARIABLES INITIALIZED:
C    GID (1 TO 16) : 64 CHARACTER GEOMETRY IDENTIFICATION RECORD
C    GDATE         : CHAR*8 - 8 CHARACTER GEOMETRY DATE
C    GTIME         : R*8 - 8 CHARACTER GEOMETRY TIME + 8 CHAR DUMMY
C    RID (1 TO 16) : 64 CHARACTER RAY OR SCAL FILE IDENTIFICATION RECORD
C    RDATE         : CHAR*8 - 8 CHARACTER RAY OR SCAL FILE DATE
C    RTIME         : R*8 - 8 CHARACTER RAY OR SCAL FILE TIME
C                          + 8 CHAR DUMMY
C    DFID(1 TO 16) : 64 CHARACTER DEFORMATION FILE IDENTIFIER
C
C  /LIMIT/ VARIABLES INITIALIZED, ALL ARE REAL * 4:
C    GLIM (1, 1 TO 20) LOWER LIMITS FOR GENERAL SYSTEM VARIABLES
C    GLIM (2, 1 TO 20) UPPER LIMITS FOR GENERAL SYSTEM VARIABLES
C    SLIM (1, 1 TO 20) LOWER LIMITS FOR SURFACE VARIABLES
C    SLIM (2, 1 TO 20) UPPER LIMITS FOR SURFACE VARIABLES
C
C  /PARM/ VARIABLES INITIALIZED, ALL ARE REAL * 8:
C    GEN ( 1) : XAP = X OF CENTER OF ANNULAR APERTURE
C    GEN ( 2) : YAP = Y OF CENTER OF ANNULAR APERTURE
C    GEN ( 3) : ZOFF - Z OFFSET OF FOCAL PLANE
C    GEN ( 4) : NS - TOTAL NUMBER OF SURFACES (EXCLUDE FOCAL PLANE)
C    GEN ( 5) : PSI - POLARIZATION MAJOR AXIS ANGLE (WAS EP1)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 6) : E - RATIO OF MINOR TO MAJOR AXIS AMPLITUDE (WAS EP2)
C               (ABS VALUE BETWEEN 0 AND 1)
C               (POSITIVE FOR LEFT HANDED, NEGATIVE FOR RIGHT HANDED)
C               (APPLIES ONLY IF DISCRETE POLARIZATION FLAG SET)
C    GEN ( 7) : AZBU - AZIMUTH ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 8) : ELBU - ELEVATION ANGLE OF INCOMING BUNDLE (DEG.)
C    GEN ( 9) : R1 - INNER RADIUS OF APERTURE ANNULUS
C    GEN (10) : R2 - OUTER RADIUS OF APERTURE ANNULUS
C    GEN (11) : MING - NUMBER OF RINGS
C    GEN (12) : M2 - NUMBER OF POINTS IN OUTERMOST RING
!  (PTSRC ADDED 5/9/88)
C    GEN (13) : PTSRC - DISTANCE FROM PT SOURCE TO PUPIL CENTER
C    GEN (14 - 20)  ARE NOT USED
C
C    IF J = SURFACE NUMBER THEN,
C    SURF (1, J) : X - X COORD. AT SURFACE CENTER
C    SURF (2, J) : Y - Y COORD. AT SURFACE CENTER
C    SURF (3, J) : Z - Z COORD. AT SURFACE CENTER
C    SURF (4, J) : P - CONIC CONSTANT = 1 - ECCEN. ** 2
C    SURF (5, J) : VERTEX RADIUS OF CURV. OR K FACTOR OF XRAY SURFACE
C    SURF (6, J) : P0 - CENTER RADIUS  (USUALLY 0 FOR CONVENTIONAL),
!                  OR ZROT8 - ANGLE ABOUT Z FOR RECTANGULAR OBSCURATION,
!                  OR RTOR - TOROIDAL RADIUS FOR TOROIDAL SURFACE
C    SURF (7, J) : AZMIS - AZIMUTH MISALIGNMENT OF SURFACE (DEG.)
C    SURF (8, J) : ELMIS - ELEVATION MISALIGNMENT OF SURFACE (DEG.)
C    SURF (9, J) : INNER RADIUS OF CONVENTIONAL SURFACE OR
C                  EPICENTER OF OFFSET SURFACE OR
C                  INNER RADIUS OR X-WIDTH OF OBSCURATION
C    SURF (10,J) : OUTER RADIUS OF CONV. OR LENGTH OF X-RAY SURFACE OR
C                  OUTER RADIUS OR Y-WIDTH OF OBSCURATION
C    SURF (11,J) : BORESIGHT ANGLE OF OFFSET SURFACE, OR
C                  AZF - AZIMUTH OF NRML TO FOLD PLANE OF FLAT SURF, OR
!                  ZROT8 - ANGLE ABOUT Z FOR TOROIDAL SURFACE
C    SURF (12,J) : ELF - ELEVATION NORMAL TO FOLD PLANE OF FLAT SURFACE
C    SURF (13,J) : ZFOLD - Z COORD. OF INTERSECTION OF STD Z AXIS
C                  WITH FOLD PLANE OF FLAT SURFACE, OR
C                  ZROT8 - ROTATION ABOUT Z OF A RECTANGULAR OBSCURATION
C    SURF (14,J) : EP1 - REAL PART OF DIELECTRIC CONSTANT
C    SURF (15,J) : EP2 - IMAGINARY PART OF DIELECTRIC CONSTANT
C    SURF (16 - 20,J) : NOT USED
C
C  /PARX/ VARIABLES INITIALIZED:
C    GFOC : R*8 - GEOMETRIC FOCUS OF SYSTEM WRT STD
C    NDIM : I*4 - NUMBER OF SURFACES ALLOWED FOR
C    NS   : I*4 - ACTUAL NUMBER OF SURFACES
C    KURF : I*4 - SURFACE NUMBER
C    MING : I*4 - NUMBER OF RINGS IN FIRST SPOKE
C    M2   : I*4 - NUMBER OF SPOKES
C    RZER : R*4 - INITIAL NON-ZERO RADIUS OF ANNULAR APERTURE
C    DR   : R*4 - DELTA (R**2) BETWEEN RINGS
C    H2   : R*4 - NOT NEEDED, DUMMIED TO -1. IN NEW VERSION
C
!  /PLRZ/ ADDED TO HOLD TEMPORARY POLARIZATION VARIABLES
C  /PLRZ/ VARIABLES INITIALIZED:
C    CPSI : R*8 - COSINE OF PSI (MAJOR AXIS ANGULAR POSITION)
C    SPSI : R*8 - SINE OF PSI
C    SQRE : R*8 - SQRT (1 + E**2) (OR SQRT (2) FOR RANDOM PLRZTION)
C
C  /QPRELQ/ VARIABLES INITIALIZED:
C    QPNAME : R*8 - 8 CHARACTER PROGRAM NAME
C    QPREL  : R*4 - 4 CHARACTER RELEASE NUMBER
C    LQ     : I*4 - CURRENT LINE NUMBER ON PRINTER PAGE
C    NQ     : I*4 - TOTAL NUMBER OF LINES PER PRINTER PAGE ALLOWED
C    NT     : I*4 - NUMBER OF LINES IN PROBLEM IDENTIFIER
C    NPAGE  : I*4 - PAGE NUMBER
C
C  /RAIN/ VARIABLES INITIALIZED:
C    FOP  : R*8 - FRACTIONAL PORTION OF PATH LENGTH
C    IOP  : I*4 - INTEGER    PORTION OF PATH LENGTH
C    JRAY : I*4 - CURRENT RAY NUMBER
C    JING : I*4 - CURRENT RING NUMBER
C    MR   : I*4 - NUMBER OF RINGS IN CURRENT SPOKE
C    J2   : I*4 - CURRENT SPOKE NUMBER
C    KODE : I*4 - RAY STATUS CODE (SEE CHEX OUTPUT)
C    R    : R*4 - RADIUS OF CURRENT RING
C    W    : R*4 - RELATIVE INTENSITY OF RAY
C    Q0   : R*4 - UN-NORMALIZED 2ND DERIV. MATRIX OF SURF
C    Q3   : R*4 - NORMALIZED Q0
!  (C2COMP, S2COMP ADDED 2/4/88)
C    C2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF COS (OMEGA T) POLARIZATION
C    S2COMP: C*16 - 2-D COMPLEX AMPLITUDE OF SIN (OMEGA T) POLARIZATION
C
!  /SENS/ ADDED TO STORE OPD SENSITIVITY VARIABLES
C  /SENS/ VARIABLES INITIALIZED:
C    NCH: I*4 - NUMBER OF CONSTRUCTIONAL CHANGES BEING CONSIDERED
C    CHGS (J): R*8 - AMOUNT BY WHICH TO VARY THE J'TH CONSTRUCTIONAL
C                    CHANGE PARAMETER.  (THE CONSTRUCTIONAL CHANGE
C                    PARAMETERS ARE DEFINED IN THE .SNS FILE BELOW.)
C                    (IT IS THE USER'S RESPONSIBILITY TO BE SURE THAT
C                    THE DESIRED CHANGES MATCH IN NUMBER AND FORM
C                    WITH THE CHANGES DEFINED IN THE SENSITIVITY
C                    CALCULATIONS LEADING TO THE .SNS FILE.)
C                  TO DEFINE THE ANNULAR ZERNIKE POLYNOMIALS)
C    ICHS (J): I*4 -
C         ARRAY OF INTEGERS DENOTING WHICH CONSTRUCTIONAL
C         PARAMETER TO VARY FOR THE J'TH DESIRED CHANGE.
C         CHANGES ARE EITHER TO GI FILE PARAMETERS (WHICH
C         ARE DEFINED WITH PARAMETER NUMBERS CALLED 'ITN' -
C         SEE OSAC DOCUMENTATION), OR TO DEFORM FILE
C         PARAMETERS (WHICH ARE DEFINED WITH ZERNIKE
C         COEFFICIENT NUMBER 'IDF').  THE TYPE AND NUMBER
C         OF THE DESIRED CHANGE CAN BE GATHERED FROM THE
C         ICHS ELEMENT AS FOLLOWS:
C       1-99:     ICHS = (SYSTEM) ITN NUMBER
C       .GT. 100: ICHS / 100 = SURFACE NUMBER
C                 MOD (ICHS, 100) = (SURFACE) ITN NUMBER
C       .LT. 0:   (- ICHS) / 100 = SURFACE NUMBER
C                 MOD ((- ICHS), 100) = IDF NUMBER
C    SNSMAT (I, J): R*8 -
C         CHANGE IN THE I'TH ANNULAR ZERNIKE POLYNOMIAL COEFFICIENT
C         FOR A UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE
C         PARAMETER.  SNSMAT (1, J) = 0.D0, SINCE PISTON IS ALWAYS
C         THROWN AWAY.
C    XBFSNS (J): R*8 -
C         CHANGE IN X-COORDINATE OF THE BEST FOCUS LOCATION FOR A
C         UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE PARAMETER.
C    YBFSNS (J): R*8 -
C         CHANGE IN Y-COORDINATE OF THE BEST FOCUS LOCATION FOR A
C         UNIT CHANGE IN THE J'TH CONSTRUCTIONAL CHANGE PARAMETER.
C    ZCOF0 (I): R*8 -
C         I'TH ANNULAR ZERNIKE POLYNOMIAL COEFFICIENT FOR THE
C         NOMINAL OPD FILE
C
C  /SUMRY/ VARIABLES INITIALIZED:
C    AQ    : 10*R*8 - COEFFICIENTS OF QUADRATIC FOCUS FUNCTION
C    WF1   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT SURFACE #1
C    WF2   : R*8 - SUM OF WEIGHTS OF RAYS FAILING AT SURFACE #2
C    WS1   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT SURFACE #1
C    WS2   : R*8 - SUM OF WEIGHTS OF SUCCESSFUL RAYS AT SURFACE #2
C    JAIL1 : I*4 - NUMBER OF RAYS FAILING AT SURFACE #1
C    JAIL2 : I*4 - NUMBER OF RAYS FAILING AT SURFACE #2
C    LEFT1 : I*4 - NUMBER OF RAYS LEAVING S #1 OR PRECEEDING SURFACE
C    LEFT2 : I*4 - NUMBER OF RAYS LEAVING SURFACE #2 OR CURRENT SURFACE
C    XMIN  : R*4 - MINIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    XMAX  : R*4 - MAXIMUM X COORD. FOR RAYS HITTING FOCAL PLANE
C    YMIN  : R*4 - MINIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C    YMAX  : R*4 - MAXIMUM Y COORD. FOR RAYS HITTING FOCAL PLANE
C    WX    : R*8 - RUNNING SUM OF W * X COORD. AT FOCAL PLANE
C    WY    : R*8 - RUNNING SUM OF W * Y COORD. AT FOCAL PLANE
C    WR    : R*8 - RUNNING SUM OF W * (R) AT FOCAL PLANE
C    WXSQ  : R*8 - RUNNING SUM OF W * X**2 AT FOCAL PLANE
C    WYSQ  : R*8 - RUNNING SUM OF W * Y**2 AT FOCAL PLANE
C    SUMS FOR SURFACE J:
C    STAV (1, J) : R*4 - RUNNING SUM OF MAGNITUDES OF SAGITTAL
C                         SCALE FACTORS
C    STAV (2, J) : R*4 - DITTO FOR TANGENTIAL SCALE FACTORS
C
C  /SWITCH/ VARIABLES INITIALIZED, ALL ARE LOGICAL * 1:
C    GENERAL SYSTEM SWITCHES:
C    LSW0 (1) : NOT USED (FORMERLY X-RAY SYSTEM SWITCH)
C    LSW0 (2) : NOT USED
C    LSW0 (3) : F - ZOFF WRT GFOC, T - ZOFF WRT STD
!  FOLLOWING SWITCH ADDED FOR POLARIZATION
C    LSW0 (4) : F - RANDOM POLARIZATION, T - DISCRETE POLARIZATION
C    LSW0 (5 TO 10) : NOT USED
C    SWITCHES FOR SURFACE J:
C    LSW (1, J) : F - CONCAVE SURFACE, T - CONVEX SURFACE
C    LSW (2, J) : F - NO SURFACE DEFORMATIONS, T - SURFACE DEFORMATIONS
C    LSW (3, J) : F - NOT FLAT, T - FLAT
C    LSW (4, J) : F - ON AXIS, T - OFF AXIS
!  FOLLOWING THREE SWITCHES ADDED FOR OBSCURATION-TYPE SURFACES
C    LSW (5, J) : F - NOT AN ANNULAR OBSCURATION, T - ANNULAR OBSC
C    LSW (6, J) : F - NOT A RECTANGULAR OBSC, T - RECTANGULAR OBSC
C    LSW (7, J) : F - "OBSC" IS AN OPENING, T - "OBSC" IS OPAQUE
!  FOLLOWING SWITCH ADDED FOR TOROIDAL SURFACE
C    LSW (8, J) : F - NOT TOROIDAL, T - TOROIDAL
!  FOLLOWING SWITCH ADDED FOR X-RAY SURFACE
!    LSW (9, J) : F - CONVENTIONAL, T - X-RAY
C    LSW (10, J) : NOT USED

C
C  /XCOMP/, /YCOMP/, /ZCOMP/ VARIABLES INITIALIZED, ALL ARE REAL * 8:
C    XV : X COMPONENTS OF VECTORS
C    YV : Y COMPONENTS OF VECTORS
C    ZV : Z COMPONENTS OF VECTORS
C
C      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO REAL*8
 
*---  global variables...
*
C     -------------------------------------------------------------

      DOUBLE PRECISION CB, CE, SB, SE, YEP
      COMMON /AXOFF/   CB, CE, SB, SE, YEP

      include 'saosacLib/comic.h'     ! xd,yd,zd,xl,yl,zl,xg,yg,zg,phil
      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/ident.h'     ! misc identifiers (times, dates, ...)

      DOUBLE PRECISION GLIM,         SLIM
      COMMON /LIMIT/   GLIM (2, 20), SLIM (2, 20)

      include 'saosacLib/parm.h'      ! gen, surf, ...
      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...

      DOUBLE PRECISION CPSI, SPSI, SQRE
      COMMON /PLRZ/    CPSI, SPSI, SQRE

      include 'saosacLib/qprelq.h'    ! qpname, qprel, lq, nq, nt, npage
      include 'saosacLib/rain.h'      ! 
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...
      include 'saosacLib/sumry.h'     ! data for summaries
      include 'saosacLib/switch.h'    ! switches: lsw0, lsw
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

*DATA INITIALIZATION ---------------------------------------------------

C  /AXOFF/ VARIABLES INITIALIZED:
      DATA CB, CE, SB, SE, YEP / 5 * 0.0D0 /

C  /COMIC/ VARIABLES INITIALIZED:
      DATA XD, YD, ZD, XL, YL, ZL, XG, YG, ZG, PHIL
     1 /9 * 0.0D0, 0.0D0/

C  /DEFORM/ VARIABLES INITIALIZED:
      DATA NLEG, NFOUR, NDF, DEFT, DEF2, DEFC,
     1     IWK1, IWK2, NDXARR, NNDX, COFMAT, OBSC
     2     /3 * 0, 502 * 0.D0, 651 * 0, 25, 820 * 0.D0/

C  /IDENT/ VARIABLES INITIALIZED:
      DATA GID, GDATE, GTIME, RID, RDATE, RTIME, DFID /54 * ' '/

C  /LIMIT/ VARIABLES INITIALIZED :
!  (CHANGE SLIM'S 5, 6, AND 11 FOR TOROIDAL SURFACES)
      DATA GLIM /
     &   -1.0D6,   1.0D6,  !  1 XAP = x of center of annular aperture
     &   -1.0D6,   1.0D6,  !  2 YAP = y of center of annular aperture
     &   -1.0D6,   1.0D6,  !  3 ZOFF - z offset of focal plane
     &    1.D0,  999.D0,   !  4 NS - tot number of surfaces (excl foc plane)
     &  -90.D0,   90.D0,   !  5 PSI - polarization major axis angle (was ep1)
     &   -1.D0,    1.D0,   !  6 E - ratio of minor to major axis amp (was ep2)
     & -180.D0,  180.D0,   !  7 AZBU - azimuth angle of incoming bundle (deg.)
     &  -90.D0,   90.D0,   !  8 ELBU - elevation angle of incoming bundle (deg.)
     &    0.D0,    1.0D6,  !  9 R1 - inner radius of aperture annulus
     &    1.D0,    1.0D6,  ! 10 R2 - outer radius of aperture annulus
     &    1.D0,    1.0D6,  ! 11 MING - number of rings
     &    1.D0,    1.0D6,  ! 12 M2 - number of points in outermost ring
     &    1.D-6,   1.D30,  ! 13 PTSRC - distance from pt source to pupil center
     &    14 * 0.0D0       ! 14-20 are not used
     &  /
      DATA SLIM /
     &  -1000.D0,    1000.D0, !  1 X - X COORD. AT SURFACE CENTER
     &  -1000.D0,    1000.D0, !  2 Y - Y COORD. AT SURFACE CENTER
     &     -1.0D6,   1.0D6,   !  3 Z - Z COORD. AT SURFACE CENTER
     &     -1.0D6,   1.0D6,   !  4 P - CONIC CONSTANT = 1 - ECCEN.**2
     &     -1.0D38,  1.0D38,  !  5 VERTEX RAD OF CURV. OR K FACT OF XRAY SURF
     &     -1.0D38,  1.0D38,  !  6 P0 - CENTER RADIUS, OR ZROT8, OR RTOR
     &     -180.D0,  180.D0,  !  7 AZMIS - AZIMUTH MISALIGN'T OF SURF (DEG.)
     &      -90.D0,   90.D0,  !  8 ELMIS - ELEVATION MISALIGN'T OF SURF (DEG.)
     &       -1.0D6,   1.0D6, !  9
     &        0.D0,    1.0D6, ! 10
     &     -180.D0,  180.D0,  ! 11 BORESIGHT ANGLE, or AZF, or ZROT8
     &      -90.D0,   90.D0,  ! 12 ELF - ELEV NORM TO FOLD PLANE OF FLAT SURF
     &       -1.0D6,   1.0D6, ! 13 ZFOLD, or ZROT8
     &     -100.D0,  100.D0,  ! 14 EP1 - REAL PART OF DIELECTRIC CONST
     &     -100.D0,  100.D0,  ! 15 EP2 - IMAGINARY PART OF DIELECTRIC CONST
     &      10 * 0.D0         ! 16
     &  /

C  /PARM/ VARIABLES INITIALIZED :
      DATA GEN /10 * 0.0D0, 1.0D0, 2.0D0, 1.D30, 7 * 0.0D0/
      DATA SURF /13 * 0.D0, -1.D0, 6 * 0.D0,   
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0,
     *           13 * 0.D0, -1.D0, 6 * 0.D0/

C  /PARX/ VARIABLES INITIALIZED :
      DATA GFOC, NDIM, NS, KURF, MING, M2, RZER, DR, H2
     1  /0.0D0, 21, 2, 3 * 0, 3 * 0.0D0/

C  /QPRELQ/ VARIABLES INITIALIZED:
      DATA QPNAME, QPREL, LQ, NQ, NT, NPAGE /' ', ' ', 0, 60, 2*0/

C  /RAIN/ VARIABLES INITIALIZED :
      DATA FOP, IOP, JRAY, JING, MR, J2, KODE, R, W, Q0, Q3
     1  /0.D0, 6 * 0, 14 * 0.0D0/

C  /SUMRY/ VARIABLES INITIALIZED:
      DATA AQ, WF1, WF2, WS1, WS2, JAIL1, JAIL2,
     1 LEFT1, LEFT2, XMIN, XMAX, YMIN, YMAX,
     2 WX, WY, WR, WXSQ, WYSQ, STAV
!!!  3 /14 * 0.0D0, 4 * 0, 1.0D60, -1.0D60, 1.0D60, -1.0D60,
     3 /14 * 0.0D0, 4 * 0, 1.0D30, -1.0D30, 1.0D30, -1.0D30,
     4 5 * 0.0D0, 42 * 0.0D0 /

C  /SWITCH/ VARIABLES INITIALIZED :
      DATA LSW0 / 10 * .FALSE./, LSW / 210 * .FALSE./

C  /XCOMP/, /YCOMP/, /ZCOMP/ VARIABLES INITIALIZED :
      DATA XV, YV, ZV / 150 * 0.0D0, 150 * 0.0D0, 150 * 0.0D0/

C!!!   END
