!+
!KWIC bnew.f
!
!$Id: bnew.f,v 1.2 2004/03/17 21:23:31 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . reorder /PARX/   for alignment; add save stmt; move to include file
!      . /XCOMP/, /YCOMP/, /ZCOMP/:      add save stmt; move to include file
!-

      SUBROUTINE BNEW (Q3Z, J)
C   /******************************************/
C    *
C    *    PERKIN-ELMER OPTICAL TECHNOLOGY DIVISION
C    *
C    *    BNEW FORTRAN
C    *    WRITTEN BY P. GLENN M/S 841 X (203) 797-5521
C    *            ON 05/05/81
C    *
C    *    UPDATE:   11/01/83
C    *    TIME:     08:09:23
C    *
C    ******************************************/
C
C  INPUT ARGUMENTS :
C     Q3Z :  ARRAY OF 6-LONG 'Q3' ARRAYS
C     J   :  SURFACE # AT WHICH TO UPDATE THE B MATRIX
C
C  INPUT VIA /PARX/ :
C     NDIM : NUMBER OF SURFACES ALLOWED FOR
C
C  OUTPUT :
C     VIA V# (4, 5, 6): THE UPDATED B MATRIX ROWS
C
C  XR :  MADD, MMULT, MOUT, VDOT
C
      
      !*** ALL REAL*4 VARIABLES HAVE BEEN CHANGED TO DOUBLE PRECISION
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-N) 

      include 'saosacLib/parx.h'      ! gfoc, ndim, ns, kurf, ...
      include 'saosacLib/xyzcomp.h'   ! xv, yv, zv scratch arrays

      DIMENSION Q3Z (6, 21)
      DOUBLE PRECISION VDOT
C
C  DEFINE INDECES FOR INITIAL RAY AND NORMAL VECTOR
      NS0 = J + NDIM + 31
      NNORM = NS0 + NDIM + 2
C
C  PUT Q3 (FULL STORAGE MODE) INTO V# (10, 11, 12)
C  AND THEN PUT Q3 * A INTO V# (7, 8, 9)
      XV (10) = Q3Z (1, J)
      YV (10) = Q3Z (2, J)
      ZV (10) = Q3Z (4, J)
      XV (11) = Q3Z (2, J)
      YV (11) = Q3Z (3, J)
      ZV (11) = Q3Z (5, J)
      XV (12) = Q3Z (4, J)
      YV (12) = Q3Z (5, J)
      ZV (12) = Q3Z (6, J)
      CALL MMULT (10, 1, 7)
C
C  PUT MIRROR MATRIX INTO V# (10, 11, 12)
      XV (10) = 1.D0 - 2.D0 * XV (NNORM) * XV (NNORM)
      YV (10) =      - 2.D0 * XV (NNORM) * YV (NNORM)
      ZV (10) =      - 2.D0 * XV (NNORM) * ZV (NNORM)
      XV (11) = YV (10)
      YV (11) = 1.D0 - 2.D0 * YV (NNORM) * YV (NNORM)
      ZV (11) =      - 2.D0 * YV (NNORM) * ZV (NNORM)
      XV (12) = ZV (10)
      YV (12) = ZV (11)
      ZV (12) = 1.D0 - 2.D0 * ZV (NNORM) * ZV (NNORM)
C
C  PERFORM THE REST OF THE CALCULATIONS
      CALL MOUT (NNORM, NS0, 13)
      CALL MMULT (10, 4, 16)
      CALL MMULT (13, 7, 19)
      CALL MMULT (10, 7, 22)
      CALL MADD (19, 22, 13, 1.D0, VDOT (NNORM, NS0))
      CALL MADD (16, 13, 4, 1.D0, -2.D0)
      RETURN
      END
