      COMPLEX * 16 FUNCTION CDCBRT (CZ, NPI2)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    CDCBRT FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/16/89
C    *
C   /******************************************/
C
C  PURPOSE: COMPLEX CUBE ROOT, WITH ARBITRARY 2PI BIAS
C
C  INPUT PARAMETERS:
C    CZ: C * 16 - COMPLEX NUMBER TO BE CUBE-ROOTED
C    NPI2: I * 4 - MULTIPLE OF 2 PI TO ADD TO THE ARGUMENT OF CZ
C                  (DEFINED FROM -PI TO +PI BEFORE ADDING NPI2)
C
C  OUTPUT PARAMETER:
C    CDCBRT: C * 16 - CUBE ROOT OF CZ
C
C
      IMPLICIT DOUBLE PRECISION (A - B, D - H, O - Z)
      IMPLICIT INTEGER (I-N) 
      COMPLEX * 16 CZ
      DATA PI2 /6.28318 53071 79586D0/
C
      IF (CZ .EQ. DCMPLX (0.D0, 0.D0)) GO TO 200
C
      RMAG = CDABS (CZ)
      ANG = DATAN2 (DIMAG (CZ), DREAL (CZ))
      ANG = ANG + NPI2 * PI2
      DC = DCOS (ANG / 3.D0)
      DS = DSIN (ANG / 3.D0)
      RCBRT = RMAG ** 0.333333333333333333D0
      CDCBRT = DCMPLX (DC * RCBRT, DS * RCBRT)
      RETURN
C
200   CDCBRT = DCMPLX (0.D0, 0.D0)
      RETURN
      END
