!+
!KWIC cdfin.f
!
!$Id: cdfin.f,v 1.2 2004/03/17 21:23:31 dtn Exp $
!
!Revisions:
!   93-Nov-08[T. Gaetz]
!      . reorder /DEFORM/ for alignment; add save stmt; move to include file
!      . reorder /SENS/   for alignment; add save stmt; move to include file
!   93-Oct-15[T. Gaetz]
!      . elminateformatted io to unit 6 (unit 6 just replicated unit 8);
!        unit 6 should be clear of ascii output
!-

      SUBROUTINE CDFIN (ROBSC, RPUPIL)
C   /******************************************/
C    *
C    *    BAUER ASSOCIATES, INC.
C    *
C    *    CDFIN FORTRAN
C    *    WRITTEN BY P. GLENN (617) 235-8775
C    *            ON 5/9/88
C    *
C   /******************************************/
C
C  PURPOSE: READ AND CHECK THE CHANGE DEFINITION (.CDF) FILE
C
C  INPUT VIA FILE #1 (CHANGE DEFINITION, OR .CDF FILE):
C    RID: 64-CHARACTER ID TEXT
C    NDF: I*4 - NUMBER OF ZERNIKE'S USED IN CHARACTERIZING THE
C               EFFECTS OF THE CHANGES
C    ROBSC: R*8 - INNER PUPIL RADIUS
C    RPUPIL: R*8 - OUTER PUPIL RADIUS (ROBSC AND RPUPIL ARE USED
C                  TO DEFINE THE ANNULAR ZERNIKE POLYNOMIALS)
C    NCH: I*4 - NUMBER OF CONSTRUCTIONAL CHANGES BEING CONSIDERED
C    ICHS (J): I*4 -
C         ARRAY OF INTEGERS DENOTING WHICH CONSTRUCTIONAL
C         PARAMETER TO VARY FOR THE J'TH DESIRED CHANGE.
C         CHANGES ARE EITHER TO GI FILE PARAMETERS (WHICH
C         ARE DEFINED WITH PARAMETER NUMBERS CALLED 'ITN' -
C         SEE OSAC DOCUMENTATION), OR TO DEFORM FILE
C         PARAMETERS (WHICH ARE DEFINED WITH ZERNIKE
C         COEFFICIENT NUMBER 'IDF').  THE TYPE AND NUMBER
C         OF THE DESIRED CHANGE CAN BE GATHERED FROM THE
C         ICHS ELEMENT AS FOLLOWS:
C       1-99:     ICHS = (SYSTEM) ITN NUMBER
C       .GT. 100: ICHS / 100 = SURFACE NUMBER
C                 MOD (ICHS, 100) = (SURFACE) ITN NUMBER
C       .LT. 0:   (- ICHS) / 100 = SURFACE NUMBER
C                 MOD ((- ICHS), 100) = IDF NUMBER
C    CHGS (J): R*8 - AMOUNT BY WHICH TO VARY THE J'TH CONSTRUCTIONAL
C                    CHANGE PARAMETER
C
C  OUTPUT PARAMETERS:
C    ROBSC (SEE INPUT ABOVE)
C    RPUPIL (SEE INPUT ABOVE)
C
C
      IMPLICIT DOUBLE PRECISION (A - H, O - Z)
      IMPLICIT INTEGER (I-N) 

      include 'saosacLib/deform.h'    ! fourier-legendre deformation coeffs
      include 'saosacLib/sens.h'      ! sensitivity arrays: chgs, snsmat...
      include 'saosacLib/ident.h'

C      COMMON /IDENT/ GID (16), GDATE, GTIME (2),
C     1               RID (16), RDATE, RTIME (2),
C     2               DFID (16)
C      CHARACTER * 4 GID, RID
C      CHARACTER * 4 DFID
      DATA NCHMAX /50/
C
C
C  READ AND CHECK THE ID TEXT
C
      READ (1, 7000, END = 2000, ERR = 2010) RID
C
C  READ AND CHECK THE NUMBER OF POLYNOMIALS AND PUPIL DIMENSIONS
C
      READ (1, *, END = 2000, ERR = 2010) NDF, ROBSC, RPUPIL
      IF (NDF .LT. 3 .OR. ROBSC .LT. 0.D0 .OR. RPUPIL .LE. ROBSC)
     *   GO TO 2020
      OBSC = ROBSC / RPUPIL
C
C  READ THE DEFINING CONSTRUCTIONAL CHANGES AND THE DESIRED
C  INCREMENTAL AMOUNTS OF THE CHANGES
C
      READ (1, *, END = 2000, ERR = 2010) NCH
      IF (NCH .LT. 1 .OR. NCH .GT. NCHMAX) GO TO 2030
      DO 120 ICH = 1, NCH
      READ (1, *, END = 2000, ERR = 2010) ICHS (ICH), CHGS (ICH)
120   CONTINUE
      RETURN
C
2000  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8000)
      STOP 8
2010  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8010)
      STOP 8
2020  CONTINUE
      CALL INCLIN (2)
      WRITE (8, 8020) NDF, ROBSC, RPUPIL
      STOP 8
2030  CONTINUE
      CALL INCLIN (1)
      WRITE (8, 8030) NCH
      STOP 8
C
7000  FORMAT (16A4)
8000  FORMAT ('  CDFIN FATAL ERROR - EOF READING CDF FILE')
8010  FORMAT ('  CDFIN FATAL ERROR - ERROR READING CDF FILE')
8020  FORMAT ('  CDFIN FATAL ERROR IN CDF FILE PARAMETERS:' /
     *        '        (NDF, ROBSC, RPUPIL) =', I6, 1P,2D12.4)
8030  FORMAT ('  CDFIN FATAL ERROR: NCH =', I6,
     *        ' (1 .LE. NCH .LE. 50)')
      END
